/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable,
Comparable {
    private transient Calendar cal = null;
    private transient long fastTime;
    private static Calendar staticCal = null;
    private static Calendar utcCal = null;
    private static int defaultCenturyStart = 0;
    private static final long serialVersionUID = 7523967970034938905L;
    private static SoftReference simpleFormatter = null;
    private static SoftReference gmtFormatter = null;
    private static final String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final int[] ttb;

    static {
        int[] nArray = new int[32];
        nArray[0] = 14;
        nArray[1] = 1;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 4;
        nArray[12] = 5;
        nArray[13] = 6;
        nArray[14] = 7;
        nArray[15] = 8;
        nArray[16] = 9;
        nArray[17] = 10;
        nArray[18] = 11;
        nArray[19] = 12;
        nArray[20] = 13;
        nArray[21] = 10000;
        nArray[22] = 10000;
        nArray[23] = 10000;
        nArray[24] = 10300;
        nArray[25] = 10240;
        nArray[26] = 10360;
        nArray[27] = 10300;
        nArray[28] = 10420;
        nArray[29] = 10360;
        nArray[30] = 10480;
        nArray[31] = 10420;
        ttb = nArray;
    }

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, 0);
    }

    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        if (staticCal == null) {
            Date.makeStaticCalendars();
        }
        Calendar calendar = staticCal;
        synchronized (calendar) {
            staticCal.setTimeZone(TimeZone.getDefault());
            staticCal.clear();
            staticCal.set(n + 1900, n2, n3, n4, n5, n6);
            this.fastTime = staticCal.getTimeInMillis();
        }
    }

    public Date(long l) {
        this.fastTime = l;
    }

    public Date(String string) {
        this(Date.parse(string));
    }

    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        if (utcCal == null) {
            Date.makeStaticCalendars();
        }
        Calendar calendar = utcCal;
        synchronized (calendar) {
            utcCal.clear();
            utcCal.set(n + 1900, n2, n3, n4, n5, n6);
            long l = utcCal.getTimeInMillis();
            Object var9_8 = null;
            return l;
        }
    }

    public boolean after(Date date) {
        return this.getTime() > date.getTime();
    }

    public boolean before(Date date) {
        return this.getTime() < date.getTime();
    }

    public Object clone() {
        Date date = null;
        try {
            date = (Date)super.clone();
            if (date.cal != null) {
                date.cal = (Calendar)date.cal.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return date;
    }

    public int compareTo(Object object) {
        return this.compareTo((Date)object);
    }

    public int compareTo(Date date) {
        long l;
        long l2 = this.getTime();
        return l2 < (l = date.getTime()) ? -1 : (l2 == l ? 0 : 1);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    public int getDate() {
        return this.getField(5);
    }

    public int getDay() {
        return this.getField(7) - 1;
    }

    private final int getField(int n) {
        if (this.cal == null) {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            Calendar calendar = staticCal;
            synchronized (calendar) {
                staticCal.setTimeZone(TimeZone.getDefault());
                staticCal.setTimeInMillis(this.fastTime);
                int n2 = staticCal.get(n);
                Object var4_6 = null;
                return n2;
            }
        }
        TimeZone timeZone = TimeZone.getDefault();
        if (!timeZone.equals(this.cal.getTimeZone())) {
            long l = this.cal.getTimeInMillis();
            this.cal.setTimeZone(TimeZone.getDefault());
            this.cal.setTimeInMillis(l);
        }
        return this.cal.get(n);
    }

    public int getHours() {
        return this.getField(11);
    }

    public int getMinutes() {
        return this.getField(12);
    }

    public int getMonth() {
        return this.getField(2);
    }

    public int getSeconds() {
        return this.getField(13);
    }

    public long getTime() {
        return this.cal == null ? this.fastTime : this.cal.getTimeInMillis();
    }

    public int getTimezoneOffset() {
        int n;
        if (this.cal == null) {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            Calendar calendar = staticCal;
            synchronized (calendar) {
                staticCal.setTimeZone(TimeZone.getDefault());
                staticCal.setTimeInMillis(this.getTime());
                n = staticCal.get(15) + staticCal.get(16);
            }
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            if (!timeZone.equals(this.cal.getTimeZone())) {
                long l = this.cal.getTimeInMillis();
                this.cal.setTimeZone(TimeZone.getDefault());
                this.cal.setTimeInMillis(l);
            }
            n = this.cal.get(15) + this.cal.get(16);
        }
        return -(n / 1000 / 60);
    }

    public int getYear() {
        return this.getField(1) - 1900;
    }

    public int hashCode() {
        long l = this.getTime();
        return (int)l ^ (int)(l >> 32);
    }

    private static void makeStaticCalendars() {
        staticCal = new GregorianCalendar();
        utcCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        defaultCenturyStart = staticCal.get(1) - 80;
    }

    /*
     * Unable to fully structure code
     */
    public static long parse(String var0) {
        block43: {
            if (Date.staticCal == null) {
                Date.makeStaticCalendars();
            }
            var1_1 = -2147483648;
            var2_2 = -1;
            var3_3 = -1;
            var4_4 = -1;
            var5_5 = -1;
            var6_6 = -1;
            var7_7 = -1;
            var8_8 = -1;
            var9_9 = 0;
            var10_10 = -1;
            var11_11 = -1;
            var12_12 = -1;
            var13_13 = 0;
            if (var0 == null) break block43;
            var14_14 = var0.length();
            block0: while (var9_9 < var14_14) {
                block44: {
                    var8_8 = var0.charAt(var9_9);
                    ++var9_9;
                    if (var8_8 <= 32 || var8_8 == 44) continue;
                    if (var8_8 == 40) {
                        var15_15 = 1;
                        while (var9_9 < var14_14) {
                            var8_8 = var0.charAt(var9_9);
                            ++var9_9;
                            if (var8_8 == 40) {
                                ++var15_15;
                                continue;
                            }
                            if (var8_8 == 41 && --var15_15 <= 0) continue block0;
                        }
                        continue;
                    }
                    if (var8_8 < 48 || var8_8 > 57) break block44;
                    var10_10 = var8_8 - 48;
                    if (true) ** GOTO lbl39
                    do {
                        var10_10 = var10_10 * 10 + var8_8 - 48;
                        ++var9_9;
lbl39:
                        // 2 sources

                        if (var9_9 >= var14_14) break;
                        v0 = var0.charAt(var9_9);
                        var8_8 = v0;
                    } while (v0 >= '0' && var8_8 <= 57);
                    if (var13_13 == 43 || var13_13 == 45 && var1_1 != -2147483648) {
                        var10_10 = var10_10 < 24 ? (var10_10 *= 60) : var10_10 % 100 + var10_10 / 100 * 60;
                        if (var13_13 == 43) {
                            var10_10 = -var10_10;
                        }
                        if (var12_12 != 0 && var12_12 != -1) break block43;
                        var12_12 = var10_10;
                    } else if (var10_10 >= 70) {
                        if (var1_1 != -2147483648 || var8_8 > 32 && var8_8 != 44 && var8_8 != 47 && var9_9 < var14_14) break block43;
                        var1_1 = var10_10;
                    } else if (var8_8 == 58) {
                        if (var4_4 < 0) {
                            var4_4 = (byte)var10_10;
                        } else {
                            if (var5_5 >= 0) break block43;
                            var5_5 = (byte)var10_10;
                        }
                    } else if (var8_8 == 47) {
                        if (var2_2 < 0) {
                            var2_2 = (byte)(var10_10 - 1);
                        } else {
                            if (var3_3 >= 0) break block43;
                            var3_3 = (byte)var10_10;
                        }
                    } else {
                        if (var9_9 < var14_14 && var8_8 != 44 && var8_8 > 32 && var8_8 != 45) break block43;
                        if (var4_4 >= 0 && var5_5 < 0) {
                            var5_5 = (byte)var10_10;
                        } else if (var5_5 >= 0 && var6_6 < 0) {
                            var6_6 = (byte)var10_10;
                        } else if (var3_3 < 0) {
                            var3_3 = (byte)var10_10;
                        } else {
                            if (var1_1 != -2147483648 || var2_2 < 0 || var3_3 < 0) break block43;
                            var1_1 = var10_10;
                        }
                    }
                    var13_13 = 0;
                    continue;
                }
                if (var8_8 == 47 || var8_8 == 58 || var8_8 == 43 || var8_8 == 45) {
                    var13_13 = var8_8;
                    continue;
                }
                var15_15 = var9_9 - 1;
                while (var9_9 < var14_14) {
                    var8_8 = var0.charAt(var9_9);
                    if (!(var8_8 >= 65 && var8_8 <= 90 || var8_8 >= 97 && var8_8 <= 122)) break;
                    ++var9_9;
                }
                if (var9_9 <= var15_15 + 1) break block43;
                var16_16 = Date.wtb.length;
                while (--var16_16 >= 0) {
                    if (!Date.wtb[var16_16].regionMatches(true, 0, var0, var15_15, var9_9 - var15_15)) continue;
                    var17_17 = Date.ttb[var16_16];
                    if (var17_17 == 0) break;
                    if (var17_17 == 1) {
                        if (var4_4 <= 12 && var4_4 >= 1) {
                            if (var4_4 >= 12) break;
                            var4_4 += 12;
                            break;
                        }
                        break block43;
                    }
                    if (var17_17 == 14) {
                        if (var4_4 <= 12 && var4_4 >= 1) {
                            if (var4_4 != 12) break;
                            var4_4 = 0;
                            break;
                        }
                        break block43;
                    }
                    if (var17_17 <= 13) {
                        if (var2_2 < 0) {
                            var2_2 = (byte)(var17_17 - 2);
                            break;
                        }
                        break block43;
                    }
                    var12_12 = var17_17 - 10000;
                    break;
                }
                if (var16_16 >= 0) {
                    var13_13 = 0;
                    continue;
                }
                break block43;
            }
            if (var1_1 != -2147483648 && var2_2 >= 0 && var3_3 >= 0) {
                if (var1_1 < 100 && (var1_1 += Date.defaultCenturyStart / 100 * 100) < Date.defaultCenturyStart) {
                    var1_1 += 100;
                }
                var1_1 -= 1900;
                if (var6_6 < 0) {
                    var6_6 = 0;
                }
                if (var5_5 < 0) {
                    var5_5 = 0;
                }
                if (var4_4 < 0) {
                    var4_4 = 0;
                }
                if (var12_12 == -1) {
                    return new Date(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6).getTime();
                }
                return Date.UTC(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6) + (long)(var12_12 * 60000);
            }
        }
        throw new IllegalArgumentException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fastTime = objectInputStream.readLong();
    }

    public void setDate(int n) {
        this.setField(5, n);
    }

    private final void setField(int n, int n2) {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
            this.cal.setTimeInMillis(this.fastTime);
        }
        this.cal.set(n, n2);
    }

    public void setHours(int n) {
        this.setField(11, n);
    }

    public void setMinutes(int n) {
        this.setField(12, n);
    }

    public void setMonth(int n) {
        this.setField(2, n);
    }

    public void setSeconds(int n) {
        this.setField(13, n);
    }

    public void setTime(long l) {
        if (this.cal == null) {
            this.fastTime = l;
        } else {
            this.cal.setTimeInMillis(l);
        }
    }

    public void setYear(int n) {
        this.setField(1, n + 1900);
    }

    public String toGMTString() {
        DateFormat dateFormat = null;
        if (gmtFormatter != null) {
            dateFormat = (DateFormat)gmtFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            gmtFormatter = new SoftReference(dateFormat);
        }
        return dateFormat.format(this);
    }

    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(this);
    }

    public String toString() {
        DateFormat dateFormat = null;
        if (simpleFormatter != null) {
            dateFormat = (DateFormat)simpleFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            simpleFormatter = new SoftReference(dateFormat);
        }
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            dateFormat.setTimeZone(TimeZone.getDefault());
            String string = dateFormat.format(this);
            Object var4_4 = null;
            return string;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTime());
    }
}

