/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import sun.awt.font.NativeFontWrapper;

public class StandardGlyphVector
extends GlyphVector {
    private Font font;
    private int[] glyphs;
    private float[] positions;
    private FontRenderContext frc;
    private double[] glyphTX;

    public StandardGlyphVector(Font font, String string, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.populateGlyphVector(this.font, string.toCharArray(), 0, string.length(), dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, CharacterIterator characterIterator, FontRenderContext fontRenderContext) {
        char[] cArray = new char[characterIterator.getEndIndex() - characterIterator.getBeginIndex()];
        char c = characterIterator.first();
        while (c != '\uffff') {
            cArray[characterIterator.getIndex() - characterIterator.getBeginIndex()] = c;
            c = characterIterator.next();
        }
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, 0, cArray.length, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, n, n2, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, char[] cArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = null;
        this.positions = null;
        this.frc = fontRenderContext;
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.populateGlyphVector(this.font, cArray, 0, cArray.length, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), this);
    }

    public StandardGlyphVector(Font font, int[] nArray, FontRenderContext fontRenderContext) {
        this.font = font;
        this.glyphs = nArray;
        this.positions = null;
        this.frc = fontRenderContext;
    }

    public Object clone() {
        try {
            StandardGlyphVector standardGlyphVector = (StandardGlyphVector)super.clone();
            if (this.positions != null) {
                standardGlyphVector.positions = (float[])this.positions.clone();
            }
            return standardGlyphVector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public boolean equals(GlyphVector glyphVector) {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int n) {
        return this.glyphs[n];
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray2[n3] = this.glyphs[n3 + n];
            ++n3;
        }
        return nArray2;
    }

    public float[] getGlyphInfo() {
        float[] fArray = new float[this.glyphs.length * 8];
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.getGlyphInfo(this.font, this.glyphs, this.positions, this.glyphs.length, dArray, this.frc.usesFractionalMetrics(), this.frc.isAntiAliased(), fArray);
        return fArray;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        return null;
    }

    public Shape getGlyphLogicalBounds(int n) {
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(this.font, this.getGlyphTX(), this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), fArray);
        this.initPositions();
        float f = this.positions[n * 2];
        float f2 = this.positions[n * 2 + 1] - fArray[0];
        float f3 = f;
        float f4 = f2 + fArray[1] + fArray[2];
        GlyphMetrics glyphMetrics = this.getGlyphMetrics(n);
        return new Rectangle2D.Float(f, f2, (f3 += glyphMetrics.getAdvance()) - f, f4 - f2);
    }

    public GlyphMetrics getGlyphMetrics(int n) {
        GlyphMetrics glyphMetrics = new GlyphMetrics(0.0f, new Rectangle2D.Float(), 0);
        NativeFontWrapper.getGlyphMetrics(this.font, this.glyphs[n], this.getGlyphTX(), this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), glyphMetrics);
        return glyphMetrics;
    }

    public Shape getGlyphOutline(int n) {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath = (GeneralPath)NativeFontWrapper.getGlyphOutline(this, this.font, this.getGlyphTX(), this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), n, generalPath);
        return generalPath;
    }

    public Point2D getGlyphPosition(int n) {
        this.initPositions();
        return new Point2D.Float(this.positions[n * 2], this.positions[n * 2 + 1]);
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        return this.internalGetGlyphPositions(n, n2, fArray);
    }

    public float[] getGlyphPositions(float[] fArray) {
        return this.internalGetGlyphPositions(0, this.glyphs.length + 1, fArray);
    }

    private double[] getGlyphTX() {
        if (this.glyphTX != null) {
            return this.glyphTX;
        }
        this.glyphTX = new double[6];
        float f = this.font.getSize2D();
        AffineTransform affineTransform = (AffineTransform)this.frc.getTransform().clone();
        affineTransform.scale(f, f);
        affineTransform.preConcatenate(this.font.getTransform());
        affineTransform.getMatrix(this.glyphTX);
        return this.glyphTX;
    }

    public AffineTransform getGlyphTransform(int n) {
        return new AffineTransform();
    }

    public Shape getGlyphVisualBounds(int n) {
        this.initPositions();
        Shape shape = this.getGlyphOutline(n);
        return shape.getBounds();
    }

    public Rectangle2D getLogicalBounds() {
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(this.font, this.getGlyphTX(), this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), fArray);
        float f = 0.0f;
        float f2 = -fArray[0];
        float f3 = 0.0f;
        float f4 = fArray[1] + fArray[2];
        if (this.glyphs.length > 0) {
            this.initPositions();
            f3 = this.positions[this.positions.length - 2];
        }
        return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
    }

    public int getNumGlyphs() {
        return this.glyphs.length;
    }

    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    public Shape getOutline(float f, float f2) {
        GeneralPath generalPath = new GeneralPath(0);
        double[] dArray = this.getGlyphTX();
        generalPath = (GeneralPath)NativeFontWrapper.getGlyphVectorOutline(this, this.font, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), (float)dArray[4] + f, (float)dArray[5] + f2, generalPath);
        return generalPath;
    }

    public Rectangle2D getVisualBounds() {
        Shape shape = this.getOutline();
        return shape.getBounds();
    }

    private void initPositions() {
        if (this.positions == null) {
            this.performDefaultLayout();
        }
    }

    float[] internalGetGlyphPositions(int n, int n2, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n2 * 2];
        }
        this.initPositions();
        int n3 = 0;
        while (n3 < n2) {
            fArray2[n3 * 2] = this.positions[(n3 + n) * 2];
            fArray2[n3 * 2 + 1] = this.positions[(n3 + n) * 2 + 1];
            ++n3;
        }
        return fArray2;
    }

    public void performDefaultLayout() {
        double[] dArray = this.getGlyphTX();
        NativeFontWrapper.layoutGlyphVector(this.font, dArray, this.frc.isAntiAliased(), this.frc.usesFractionalMetrics(), (float)dArray[4], (float)dArray[5], this);
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.initPositions();
        this.positions[n * 2] = (float)point2D.getX();
        this.positions[n * 2 + 1] = (float)point2D.getY();
    }

    public void setGlyphPositions(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("srcPositions is null");
        }
        int n = this.glyphs.length * 2 + 2;
        if (fArray.length != n) {
            throw new IllegalArgumentException("srcPositions.length != " + n);
        }
        if (this.positions == null) {
            this.positions = (float[])fArray.clone();
        } else {
            System.arraycopy(fArray, 0, this.positions, 0, n);
        }
    }

    public void setGlyphPositions(float[] fArray, int n, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("numEntries = " + n3);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex = " + n2);
        }
        if (n2 + n3 > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries = " + (n2 + n3));
        }
        this.initPositions();
        System.arraycopy(fArray, n, this.positions, n2 * 2, n3 * 2);
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
    }
}

