/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class CompactStringArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int DEBUGSHOWOVERLAPLIMIT = 100;
    private static final boolean DEBUGTRACE = false;
    private static final boolean DEBUGSMALL = false;
    private static final boolean DEBUGOVERLAP = false;
    private static final int DEBUGSMALLLIMIT = 30000;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private char[] values;
    private short[] indices;
    private StringBuffer exceptions = new StringBuffer();
    private boolean isCompact;

    public CompactStringArray() {
        this("");
    }

    public CompactStringArray(String string) {
        this.values = new char[65536];
        this.indices = new short[512];
        this.setElementAt('\u0000', '\uffff', string);
        int n = 0;
        while (n < 512) {
            this.indices[n] = (short)(n << 7);
            ++n;
        }
        this.isCompact = false;
    }

    public CompactStringArray(short[] sArray, char[] cArray, String string) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n = 0;
        while (n < 512) {
            short s = sArray[n];
            if (s < 0 || s >= cArray.length + 128) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n;
        }
        this.indices = sArray;
        this.values = cArray;
    }

    private int FindOverlappingPosition(int n, char[] cArray, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 128;
            if (n3 + 128 > n2) {
                n4 = (short)(n2 - n3);
            }
            int n5 = 0;
            while (n5 < n4) {
                if (this.values[n + n5] != this.values[cArray[n3 + n5]]) break;
                n5 = (short)(n5 + 1);
            }
            if (n5 == n4) break;
            n3 += 128;
        }
        return n3;
    }

    private short capacity() {
        return (short)this.values.length;
    }

    public Object clone() {
        try {
            CompactStringArray compactStringArray = (CompactStringArray)super.clone();
            compactStringArray.values = (char[])this.values.clone();
            compactStringArray.indices = (short[])this.indices.clone();
            compactStringArray.exceptions = new StringBuffer(this.exceptions.toString());
            return compactStringArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void compact() {
        if (!this.isCompact) {
            char[] cArray = new char[65536];
            int n = 128;
            int n2 = 0;
            while (n2 < 128) {
                cArray[n2] = (char)n2;
                n2 = (short)(n2 + 1);
            }
            this.indices[0] = 0;
            int n3 = 1;
            while (n3 < 512) {
                int n4 = n3 << 7;
                int n5 = this.FindOverlappingPosition(n4, cArray, n);
                int n6 = n5 + 128;
                if (n6 > n) {
                    n2 = (short)n;
                    while (n2 < n6) {
                        cArray[n2] = (char)(n2 - n5 + n4);
                        n2 = (short)(n2 + 1);
                    }
                    n = n6;
                }
                this.indices[n3] = (short)n5;
                n3 = (short)(n3 + 1);
            }
            char[] cArray2 = new char[n];
            n2 = 0;
            while (n2 < n) {
                cArray2[n2] = this.values[cArray[n2]];
                n2 = (short)(n2 + 1);
            }
            this.values = null;
            this.values = cArray2;
            this.isCompact = true;
        }
    }

    public String elementAt(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        this.elementAt(c, stringBuffer);
        return stringBuffer.toString();
    }

    public void elementAt(char c, StringBuffer stringBuffer) {
        char c2 = this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
        if (c2 >= '\ue000' && c2 <= '\uf800') {
            int n = c2 - 57344;
            while (true) {
                if ((c2 = this.exceptions.charAt(n)) == '\uffff') {
                    return;
                }
                stringBuffer.append(c2);
                ++n;
            }
        }
        stringBuffer.append(c2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactStringArray compactStringArray = (CompactStringArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactStringArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void expand() {
        if (this.isCompact) {
            char[] cArray = new char[65536];
            int n = 0;
            while (n < 65536) {
                cArray[n] = this.values[(this.indices[n >> 7] & 0xFFFF) + (n & 0x7F)];
                ++n;
            }
            n = 0;
            while (n < 512) {
                this.indices[n] = (short)(n << 7);
                ++n;
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    private char getArrayValue(int n) {
        return this.values[n];
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    private short getIndexArrayValue(int n) {
        return this.indices[n];
    }

    public char[] getStringArray() {
        return this.values;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    void printIndex(char n, short s) {
        int n2 = n;
        while (n2 < s) {
            System.out.println(String.valueOf(n2) + " -> : " + (this.indices[n2] >= 0 ? this.indices[n2] : this.indices[n2] + 65536));
            ++n2;
        }
        System.out.println();
    }

    void printPlainArray(int n, int n2, char[] cArray) {
        if (cArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                System.out.print(" " + this.getArrayValue(cArray[n3]));
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n + n2) {
                System.out.print(" " + this.getArrayValue(n4));
                ++n4;
            }
        }
        System.out.println("    Range: start " + n + " , count " + n2);
    }

    public void setElementAt(char c, char c2, String string) {
        if (c >= c2) {
            return;
        }
        this.setElementAt(c, string);
        char c3 = this.values[c];
        int n = c + '\u0001';
        while (n <= c2) {
            this.values[n] = c3;
            ++n;
        }
    }

    public void setElementAt(char c, String string) {
        char c2;
        if (this.isCompact) {
            this.expand();
        }
        if (string.length() == 1 && ((c2 = string.charAt(0)) < '\ue000' || c2 >= '\uf800')) {
            this.values[c] = c2;
            return;
        }
        String string2 = String.valueOf(string) + '\uffff';
        int n = this.exceptions.toString().indexOf(string2);
        if (n != -1) {
            this.values[c] = (char)(57344 + n);
            return;
        }
        this.values[c] = (char)(57344 + this.exceptions.length());
        int n2 = 0;
        while (n2 < string.length()) {
            this.exceptions.append(string.charAt(n2));
            ++n2;
        }
        this.exceptions.append('\uffff');
    }

    void writeArrays() {
        int n = 0;
        n = this.values.length > 0 ? this.values.length : this.values.length + 65536;
        System.out.println("{");
        int n2 = 0;
        while (n2 < 511) {
            System.out.print("(short)" + (this.getIndexArrayValue(n2) >= 0 ? this.getIndexArrayValue(n2) : this.getIndexArrayValue(n2) + 65536) + ", ");
            if (n2 != 0 && n2 % 10 == 0) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("(char)" + (this.getIndexArrayValue(511) >= 0 ? this.getIndexArrayValue(n2) : this.getIndexArrayValue(n2) + 65536) + " }");
        System.out.println("{");
        n2 = 0;
        while (n2 < n - 1) {
            char c = this.getArrayValue(n2);
            if (c < ' ' || c > '~' && c < '\u00a0' || c > '\u0100') {
                System.out.print("(char)0x" + Integer.toString(c, 16).toUpperCase() + ",");
            } else {
                System.out.print("'" + c + "',");
            }
            if (n2 != 0 && n2 % 10 == 0) {
                System.out.println();
            }
            ++n2;
        }
        System.out.println("(char)" + this.getArrayValue(n - 1) + " }");
        System.out.println("\"" + this.exceptions.toString() + "\"");
    }
}

