/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ParseException;

class PatternEntry {
    static final int RESET = -2;
    static final int UNSET = -1;
    int strength = -1;
    String chars = "";
    String extension = "";

    PatternEntry(int n, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        this.strength = n;
        this.chars = stringBuffer.toString();
        this.extension = stringBuffer2.length() > 0 ? stringBuffer2.toString() : "";
    }

    void addToBuffer(StringBuffer stringBuffer, boolean bl, boolean bl2, PatternEntry patternEntry) {
        if (bl2 && stringBuffer.length() > 0) {
            if (this.strength == 0 || patternEntry != null) {
                stringBuffer.append('\n');
            } else {
                stringBuffer.append(' ');
            }
        }
        if (patternEntry != null) {
            stringBuffer.append('&');
            if (bl2) {
                stringBuffer.append(' ');
            }
            patternEntry.appendQuotedChars(stringBuffer);
            this.appendQuotedExtension(stringBuffer);
            if (bl2) {
                stringBuffer.append(' ');
            }
        }
        switch (this.strength) {
            case 3: {
                stringBuffer.append('=');
                break;
            }
            case 2: {
                stringBuffer.append(',');
                break;
            }
            case 1: {
                stringBuffer.append(';');
                break;
            }
            case 0: {
                stringBuffer.append('<');
                break;
            }
            case -2: {
                stringBuffer.append('&');
                break;
            }
            case -1: {
                stringBuffer.append('?');
                break;
            }
        }
        if (bl2) {
            stringBuffer.append(' ');
        }
        PatternEntry.appendQuoted(this.chars, stringBuffer);
        if (bl && this.extension.length() != 0) {
            stringBuffer.append('/');
            PatternEntry.appendQuoted(this.extension, stringBuffer);
        }
    }

    static void appendQuoted(String string, StringBuffer stringBuffer) {
        boolean bl = false;
        char c = string.charAt(0);
        if (Character.isSpaceChar(c)) {
            bl = true;
            stringBuffer.append('\'');
        } else if (PatternEntry.isSpecialChar(c)) {
            bl = true;
            stringBuffer.append('\'');
        } else {
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\u0010': 
                case '@': {
                    bl = true;
                    stringBuffer.append('\'');
                    break;
                }
                case '\'': {
                    bl = true;
                    stringBuffer.append('\'');
                    break;
                }
                default: {
                    if (!bl) break;
                    bl = false;
                    stringBuffer.append('\'');
                    break;
                }
            }
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append('\'');
        }
    }

    public void appendQuotedChars(StringBuffer stringBuffer) {
        PatternEntry.appendQuoted(this.chars, stringBuffer);
    }

    public void appendQuotedExtension(StringBuffer stringBuffer) {
        PatternEntry.appendQuoted(this.extension, stringBuffer);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        PatternEntry patternEntry = (PatternEntry)object;
        boolean bl = this.chars.equals(patternEntry.chars);
        return bl;
    }

    final String getChars() {
        return this.chars;
    }

    final String getExtension() {
        return this.extension;
    }

    final int getStrength() {
        return this.strength;
    }

    static boolean isSpecialChar(char c) {
        return c <= '/' && c >= ' ' || c <= '?' && c >= ':' || c <= '`' && c >= '[' || c <= '~' && c >= '{';
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.addToBuffer(stringBuffer, true, false, null);
        return stringBuffer.toString();
    }

    static class Parser {
        private String pattern;
        private int i;
        private StringBuffer newChars = new StringBuffer();
        private StringBuffer newExtension = new StringBuffer();

        public Parser(String string) {
            this.pattern = string;
            this.i = 0;
        }

        /*
         * Unable to fully structure code
         */
        public PatternEntry next() throws ParseException {
            var1_1 = -1;
            this.newChars.setLength(0);
            this.newExtension.setLength(0);
            var2_2 = true;
            var3_3 = false;
            block10: while (this.i < this.pattern.length()) {
                block27: {
                    var4_4 = this.pattern.charAt(this.i);
                    if (!var3_3) break block27;
                    if (var4_4 == '\'') {
                        var3_3 = false;
                    } else if (this.newChars.length() == 0) {
                        this.newChars.append(var4_4);
                    } else if (var2_2) {
                        this.newChars.append(var4_4);
                    } else {
                        this.newExtension.append(var4_4);
                    }
                    ** GOTO lbl-1000
                }
                switch (var4_4) {
                    case '=': {
                        if (var1_1 != -1) break block10;
                        var1_1 = 3;
                        ** GOTO lbl73
                    }
                    case ',': {
                        if (var1_1 != -1) break block10;
                        var1_1 = 2;
                        ** GOTO lbl73
                    }
                    case ';': {
                        if (var1_1 != -1) break block10;
                        var1_1 = 1;
                        ** GOTO lbl73
                    }
                    case '<': {
                        if (var1_1 != -1) break block10;
                        var1_1 = 0;
                        ** GOTO lbl73
                    }
                    case '&': {
                        if (var1_1 != -1) break block10;
                        var1_1 = -2;
                        ** GOTO lbl73
                    }
                    case '/': {
                        var2_2 = false;
                        ** GOTO lbl73
                    }
                    case '\'': {
                        var3_3 = true;
                        var4_4 = this.pattern.charAt(++this.i);
                        if (this.newChars.length() == 0) {
                            this.newChars.append(var4_4);
                        } else if (var2_2) {
                            this.newChars.append(var4_4);
                        } else {
                            this.newExtension.append(var4_4);
                        }
                        ** GOTO lbl73
                    }
                    default: {
                        if (var1_1 == -1) {
                            throw new ParseException("missing char (=,;<&) : " + this.pattern.substring(this.i, this.i + 10 < this.pattern.length() ? this.i + 10 : this.pattern.length()), this.i);
                        }
                        if (PatternEntry.isSpecialChar(var4_4) && !var3_3) {
                            throw new ParseException("Unquoted punctuation character : " + Integer.toString(var4_4, 16), this.i);
                        }
                        if (var2_2) {
                            this.newChars.append(var4_4);
                        } else {
                            this.newExtension.append(var4_4);
                        }
                    }
lbl73:
                    // 12 sources

                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': lbl-1000:
                    // 5 sources

                    {
                        ++this.i;
                    }
                }
            }
            if (var1_1 == -1) {
                return null;
            }
            if (this.newChars.length() == 0) {
                throw new ParseException("missing chars (=,;<&): " + this.pattern.substring(this.i, this.i + 10 < this.pattern.length() ? this.i + 10 : this.pattern.length()), this.i);
            }
            return new PatternEntry(var1_1, this.newChars, this.newExtension);
        }
    }
}

