/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;

public class JRootPane
extends JComponent
implements Accessible {
    protected JMenuBar menuBar;
    protected Container contentPane;
    protected JLayeredPane layeredPane;
    protected Component glassPane;
    protected JButton defaultButton;
    protected DefaultAction defaultPressAction;
    protected DefaultAction defaultReleaseAction;

    public JRootPane() {
        this.setGlassPane(this.createGlassPane());
        this.setLayeredPane(this.createLayeredPane());
        this.setContentPane(this.createContentPane());
        this.setLayout(this.createRootLayout());
        this.setDoubleBuffered(true);
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (this.glassPane != null && this.glassPane.getParent() == this && this.getComponent(0) != this.glassPane) {
            this.add(this.glassPane, 0);
        }
    }

    public void addNotify() {
        SystemEventQueueUtilities.addRunnableCanvas(this);
        super.addNotify();
        this.enableEvents(8L);
    }

    protected Container createContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setName(String.valueOf(this.getName()) + ".contentPane");
        jPanel.setLayout(new BorderLayout(){

            public void addLayoutComponent(Component component, Object object) {
                if (object == null) {
                    object = "Center";
                }
                super.addLayoutComponent(component, object);
            }
        });
        return jPanel;
    }

    protected Component createGlassPane() {
        JPanel jPanel = new JPanel();
        jPanel.setName(String.valueOf(this.getName()) + ".glassPane");
        jPanel.setVisible(false);
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected JLayeredPane createLayeredPane() {
        JLayeredPane jLayeredPane = new JLayeredPane();
        jLayeredPane.setName(String.valueOf(this.getName()) + ".layeredPane");
        return jLayeredPane;
    }

    protected LayoutManager createRootLayout() {
        return new RootLayout();
    }

    public Component findComponentAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        int n3 = this.countComponents();
        Component[] componentArray = this.getComponents();
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null && component != this.glassPane && (component = component instanceof Container ? ((Container)component).findComponentAt(n - component.getX(), n2 - component.getY()) : component.locate(n - component.getX(), n2 - component.getY())) != null && component.isVisible()) {
                return component;
            }
            ++n4;
        }
        return this;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJRootPane();
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public JLayeredPane getLayeredPane() {
        return this.layeredPane;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected String paramString() {
        return super.paramString();
    }

    public void removeNotify() {
        SystemEventQueueUtilities.removeRunnableCanvas(this);
        super.removeNotify();
    }

    public void setContentPane(Container container) {
        if (container == null) {
            throw new IllegalComponentStateException("contentPane cannot be set to null.");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.contentPane);
        }
        this.contentPane = container;
        this.layeredPane.add((Component)this.contentPane, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    public void setDefaultButton(JButton jButton) {
        JButton jButton2 = this.defaultButton;
        if (jButton2 != jButton) {
            this.defaultButton = jButton;
            if (jButton != null) {
                if (this.defaultPressAction == null) {
                    this.defaultPressAction = new DefaultAction(this, true);
                    this.defaultReleaseAction = new DefaultAction(this, false);
                    this.registerKeyboardAction(this.defaultPressAction, KeyStroke.getKeyStroke(10, 0, false), 2);
                    this.registerKeyboardAction(this.defaultReleaseAction, KeyStroke.getKeyStroke(10, 0, true), 2);
                    this.registerKeyboardAction(this.defaultPressAction, KeyStroke.getKeyStroke(10, 2, false), 2);
                    this.registerKeyboardAction(this.defaultReleaseAction, KeyStroke.getKeyStroke(10, 2, true), 2);
                }
                this.defaultPressAction.setOwner(jButton);
                this.defaultReleaseAction.setOwner(jButton);
            } else {
                this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
                this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, true));
                this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 2, false));
                this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 2, true));
                this.defaultPressAction = null;
                this.defaultReleaseAction = null;
            }
            if (jButton2 != null) {
                jButton2.repaint();
            }
            if (jButton != null) {
                jButton.repaint();
            }
        }
        this.firePropertyChange("defaultButton", jButton2, jButton);
    }

    public void setGlassPane(Component component) {
        if (component == null) {
            throw new NullPointerException("glassPane cannot be set to null.");
        }
        boolean bl = false;
        if (this.glassPane != null && this.glassPane.getParent() == this) {
            this.remove(this.glassPane);
            bl = this.glassPane.isVisible();
        }
        component.setVisible(bl);
        this.glassPane = component;
        this.add(this.glassPane, 0);
        if (bl) {
            this.repaint();
        }
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        if (this.menuBar != null && this.menuBar.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.menuBar);
        }
        this.menuBar = jMenuBar;
        if (this.menuBar != null) {
            this.layeredPane.add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
        }
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        if (jLayeredPane == null) {
            throw new IllegalComponentStateException("layeredPane cannot be set to null.");
        }
        if (this.layeredPane != null && this.layeredPane.getParent() == this) {
            this.remove(this.layeredPane);
        }
        this.layeredPane = jLayeredPane;
        this.add((Component)this.layeredPane, -1);
    }

    public void setMenuBar(JMenuBar jMenuBar) {
        if (this.menuBar != null && this.menuBar.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.menuBar);
        }
        this.menuBar = jMenuBar;
        if (this.menuBar != null) {
            this.layeredPane.add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
        }
    }

    static class DefaultAction
    extends AbstractAction {
        JButton owner;
        JRootPane root;
        boolean press;

        DefaultAction(JRootPane jRootPane, boolean bl) {
            this.root = jRootPane;
            this.press = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.owner != null && SwingUtilities.getRootPane(this.owner) == this.root) {
                ButtonModel buttonModel = this.owner.getModel();
                if (this.press) {
                    buttonModel.setArmed(true);
                    buttonModel.setPressed(true);
                } else {
                    buttonModel.setPressed(false);
                }
            }
        }

        public boolean isEnabled() {
            return this.owner.getModel().isEnabled();
        }

        public void setOwner(JButton jButton) {
            this.owner = jButton;
        }
    }

    protected class RootLayout
    implements LayoutManager2,
    Serializable {
        protected RootLayout() {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public void layoutContainer(Container container) {
            Rectangle rectangle = container.getBounds();
            Insets insets = JRootPane.this.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (JRootPane.this.layeredPane != null) {
                JRootPane.this.layeredPane.setBounds(insets.left, insets.top, n2, n3);
            }
            if (JRootPane.this.glassPane != null) {
                JRootPane.this.glassPane.setBounds(insets.left, insets.top, n2, n3);
            }
            if (JRootPane.this.menuBar != null) {
                Dimension dimension = JRootPane.this.menuBar.getPreferredSize();
                JRootPane.this.menuBar.setBounds(0, 0, n2, dimension.height);
                n += dimension.height;
            }
            if (JRootPane.this.contentPane != null) {
                JRootPane.this.contentPane.setBounds(0, n, n2, n3 - n);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            Insets insets = JRootPane.this.getInsets();
            Dimension dimension = JRootPane.this.menuBar != null ? JRootPane.this.menuBar.getMaximumSize() : new Dimension(0, 0);
            Dimension dimension2 = JRootPane.this.contentPane != null ? JRootPane.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - insets.top - insets.bottom - dimension.height - 1);
            return new Dimension(Math.min(dimension2.width, dimension.width) + insets.left + insets.right, dimension2.height + dimension.height + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = JRootPane.this.getInsets();
            Dimension dimension = JRootPane.this.contentPane != null ? JRootPane.this.contentPane.getMinimumSize() : container.getSize();
            Dimension dimension2 = JRootPane.this.menuBar != null ? JRootPane.this.menuBar.getMinimumSize() : new Dimension(0, 0);
            return new Dimension(Math.max(dimension.width, dimension2.width) + insets.left + insets.right, dimension.height + dimension2.height + insets.top + insets.bottom);
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = JRootPane.this.getInsets();
            Dimension dimension = JRootPane.this.contentPane != null ? JRootPane.this.contentPane.getPreferredSize() : container.getSize();
            Dimension dimension2 = JRootPane.this.menuBar != null ? JRootPane.this.menuBar.getPreferredSize() : new Dimension(0, 0);
            return new Dimension(Math.max(dimension.width, dimension2.width) + insets.left + insets.right, dimension.height + dimension2.height + insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected class AccessibleJRootPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJRootPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ROOT_PANE;
        }
    }
}

