/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;
import sun.audio.ContinuousAudioDataStream;

public class SunAudioClip
implements AudioClip {
    AudioData data;
    AudioDataStream stream;
    boolean DEBUG = false;

    public SunAudioClip(InputStream inputStream) throws IOException {
        if (this.DEBUG) {
            System.out.println("Instantiating sun.audio.SunAudioClip");
        }
        AudioStream audioStream = new AudioStream(inputStream);
        this.data = audioStream.getData();
    }

    protected void finalize() {
        block2: {
            if (this.stream == null) break block2;
            AudioPlayer.player.stop(this.stream);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void loop() {
        if (this.data != null) {
            this.stop();
            this.stream = new ContinuousAudioDataStream(this.data);
            AudioPlayer.player.start(this.stream);
            if (this.DEBUG) {
                System.err.println("Clip should be looping");
            }
        }
    }

    public synchronized void play() {
        if (this.data != null) {
            this.stop();
            this.stream = new AudioDataStream(this.data);
            AudioPlayer.player.start(this.stream);
            if (this.DEBUG) {
                System.err.println("Clip should be playing");
            }
        }
    }

    public synchronized void stop() {
        if (this.stream != null) {
            AudioPlayer.player.stop(this.stream);
        }
        if (this.DEBUG) {
            System.err.println("Clip should be stopped");
        }
    }

    public String toString() {
        return this.getClass().toString();
    }
}

