/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.Segment;
import sun.awt.font.Shaping;
import sun.awt.font.StandardGlyphVector;
import sun.awt.font.TextSource;

public class ExtendedTextSourceLabel
extends ExtendedTextLabel {
    TextSource source;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    StandardGlyphVector gv;
    Segment shapedSeg;
    float[] charinfo;
    private static final int posx = 0;
    private static final int posy = 1;
    private static final int advx = 2;
    private static final int advy = 3;
    private static final int visx = 4;
    private static final int visy = 5;
    private static final int visw = 6;
    private static final int vish = 7;
    private static final int numvals = 8;

    public ExtendedTextSourceLabel(TextSource textSource) {
        this.source = textSource;
    }

    public ExtendedTextSourceLabel(TextSource textSource, ExtendedTextSourceLabel extendedTextSourceLabel, int n) {
        this.source = textSource;
    }

    public ExtendedTextLabel applyJustificationDeltas(float[] fArray, int n, boolean[] blArray) {
        float[] fArray2 = (float[])this.getCharinfo().clone();
        blArray[0] = false;
        StandardGlyphVector standardGlyphVector = (StandardGlyphVector)this.getGV().clone();
        float[] fArray3 = standardGlyphVector.getGlyphPositions(null);
        int n2 = standardGlyphVector.getNumGlyphs();
        char[] cArray = this.source.getChars();
        int n3 = this.source.getStart();
        float f = 0.0f;
        int n4 = 0;
        while (n4 < n2) {
            if (Character.isWhitespace(cArray[n3 + this.v2l(n4)])) {
                int n5 = n4 * 2;
                fArray3[n5] = fArray3[n5] + f;
                float f2 = fArray[n + n4 * 2] + fArray[n + n4 * 2 + 1];
                int n6 = n4 * 8;
                fArray2[n6] = fArray2[n6] + f;
                int n7 = n4 * 8 + 4;
                fArray2[n7] = fArray2[n7] + f;
                int n8 = n4 * 8 + 2;
                fArray2[n8] = fArray2[n8] + f2;
                f += f2;
            } else {
                int n9 = n4 * 2;
                fArray3[n9] = fArray3[n9] + (f += fArray[n + n4 * 2]);
                int n10 = n4 * 8;
                fArray2[n10] = fArray2[n10] + f;
                int n11 = n4 * 8 + 4;
                fArray2[n11] = fArray2[n11] + f;
                f += fArray[n + n4 * 2 + 1];
            }
            ++n4;
        }
        int n12 = n2 * 2;
        fArray3[n12] = fArray3[n12] + f;
        standardGlyphVector.setGlyphPositions(fArray3);
        ExtendedTextSourceLabel extendedTextSourceLabel = new ExtendedTextSourceLabel(this.source);
        extendedTextSourceLabel.gv = standardGlyphVector;
        extendedTextSourceLabel.charinfo = fArray2;
        return extendedTextSourceLabel;
    }

    public boolean caretAtOffsetIsValid(int n) {
        if (n == 0 || n == this.source.getLength()) {
            return true;
        }
        char c = this.source.getChars()[this.source.getStart() + n];
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        int n2 = this.l2v(n);
        if (!this.source.dataIsLTR() && ++n2 == this.source.getLength()) {
            return true;
        }
        return this.getCharinfo()[n2 * 8 + 2] != 0.0f;
    }

    public static ExtendedTextLabel create(TextSource textSource) {
        return new ExtendedTextSourceLabel(textSource);
    }

    protected Rectangle2D createAlignBounds() {
        LineMetrics lineMetrics = this.source.getLineMetrics();
        float[] fArray = this.getCharinfo();
        float f = 0.0f;
        float f2 = -lineMetrics.getAscent();
        float f3 = 0.0f;
        float f4 = lineMetrics.getAscent() + lineMetrics.getDescent();
        boolean bl = this.source.lineIsLTR();
        int n = fArray.length - 8;
        while (n > 0 && (fArray[n + 2] == 0.0f || bl && fArray[n + 6] == 0.0f)) {
            n -= 8;
        }
        if (n >= 0) {
            int n2 = 0;
            while (n2 < n && (fArray[n2 + 2] == 0.0f || !bl && fArray[n2 + 6] == 0.0f)) {
                n2 += 8;
            }
            f = Math.max(0.0f, fArray[n2]);
            f3 = fArray[n] + fArray[n + 2] - f;
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    protected float[] createCharinfo() {
        StandardGlyphVector standardGlyphVector = this.getGV();
        return standardGlyphVector.getGlyphInfo();
    }

    protected StandardGlyphVector createGV() {
        Font font = this.source.getFont();
        FontRenderContext fontRenderContext = this.source.getFRC();
        Segment segment = this.getShapedSegment();
        return new StandardGlyphVector(font, segment.text, segment.start, segment.length, fontRenderContext);
    }

    protected Rectangle2D createLogicalBounds() {
        return this.getGV().getLogicalBounds();
    }

    protected Segment createShapedSegment() {
        Segment segment = new Segment();
        Shaping.getShapedSegment(this.source, segment);
        return segment;
    }

    protected Rectangle2D createVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        graphics2D.drawGlyphVector(this.getGV(), f, f2);
    }

    public Rectangle2D getAlignBounds(float f, float f2) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)f), (float)(this.ab.getY() + (double)f2), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    public float getCharAdvance(int n) {
        this.validate(n);
        return this.getCharinfo()[this.l2v(n) * 8 + 2];
    }

    public float getCharAdvanceBetween(int n, int n2) {
        float f = 0.0f;
        float[] fArray = this.getCharinfo();
        --n;
        while (++n < n2) {
            f += fArray[this.l2v(n) * 8 + 2];
        }
        return f;
    }

    public Rectangle2D getCharVisualBounds(int n, float f, float f2) {
        this.validate(n);
        float[] fArray = this.getCharinfo();
        n = this.l2v(n) * 8;
        return new Rectangle2D.Float(fArray[n + 4] + f, fArray[n + 5] + f2, fArray[n + 6], fArray[n + 7]);
    }

    public float getCharX(int n) {
        this.validate(n);
        return this.getCharinfo()[this.l2v(n) * 8];
    }

    public float getCharY(int n) {
        this.validate(n);
        return this.getCharinfo()[this.l2v(n) * 8 + 1];
    }

    private final float[] getCharinfo() {
        if (this.charinfo == null) {
            this.charinfo = this.createCharinfo();
        }
        return this.charinfo;
    }

    private final StandardGlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    public float getItalicAngle() {
        return this.source.getFont().getItalicAngle();
    }

    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n, int n2, int n3) {
        StandardGlyphVector standardGlyphVector = this.getGV();
        float[] fArray = this.getCharinfo();
        float f = standardGlyphVector.getFont().getSize2D();
        GlyphJustificationInfo glyphJustificationInfo = new GlyphJustificationInfo(0.0f, false, 3, 0.0f, 0.0f, false, 3, 0.0f, 0.0f);
        GlyphJustificationInfo glyphJustificationInfo2 = new GlyphJustificationInfo(f, true, 1, 0.0f, f, true, 1, 0.0f, f / 4.0f);
        GlyphJustificationInfo glyphJustificationInfo3 = new GlyphJustificationInfo(f, true, 2, f, f, false, 3, 0.0f, 0.0f);
        char[] cArray = this.source.getChars();
        int n4 = this.source.getStart();
        int n5 = standardGlyphVector.getNumGlyphs();
        int n6 = 0;
        int n7 = n5;
        boolean bl = this.source.dataIsLTR();
        if (n2 != 0 || n3 != this.source.getLength()) {
            if (bl) {
                n6 = n2;
                n7 = n3;
            } else {
                n6 = n5 - n3;
                n7 = n5 - n2;
            }
        }
        int n8 = 0;
        while (n8 < n5) {
            GlyphJustificationInfo glyphJustificationInfo4 = null;
            if (n8 >= n6 && n8 < n7) {
                int n9;
                char c;
                glyphJustificationInfo4 = fArray[n8 * 8 + 2] == 0.0f ? glyphJustificationInfo : (Character.isWhitespace(c = cArray[n4 + (n9 = this.v2l(n8))]) ? glyphJustificationInfo2 : (c >= '\u4e00' && c < '\ua000' || c >= '\uac00' && c < '\ud7b0' || c >= '\uf900' && c < '\ufb00' ? glyphJustificationInfo3 : glyphJustificationInfo));
            }
            glyphJustificationInfoArray[n + n8] = glyphJustificationInfo4;
            ++n8;
        }
    }

    public int getLineBreakIndex(int n, float f) {
        float[] fArray = this.getCharinfo();
        int n2 = this.source.getLength();
        --n;
        while (f >= 0.0f && ++n < n2) {
            f -= fArray[this.l2v(n) * 8 + 2];
        }
        return n;
    }

    public LineMetrics getLineMetrics() {
        return this.source.getLineMetrics();
    }

    public Rectangle2D getLogicalBounds(float f, float f2) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)f), (float)(this.lb.getY() + (double)f2), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    public int getNumCharacters() {
        return this.source.getLength();
    }

    public int getNumJustificationInfos() {
        return this.getGV().getNumGlyphs();
    }

    public Shape getOutline(float f, float f2) {
        return this.getGV().getOutline(f, f2);
    }

    private final Segment getShapedSegment() {
        if (this.shapedSeg == null) {
            this.shapedSeg = this.createShapedSegment();
        }
        return this.shapedSeg;
    }

    public ExtendedTextLabel getSubset(int n, int n2, int n3) {
        return new ExtendedTextSourceLabel(this.source.getSubSource(n, n2 - n, n3));
    }

    public Rectangle2D getVisualBounds(float f, float f2) {
        if (this.vb == null) {
            this.vb = this.createVisualBounds();
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)f), (float)(this.vb.getY() + (double)f2), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    protected int l2v(int n) {
        return this.source.dataIsLTR() ? n : this.source.getLength() - 1 - n;
    }

    public int logicalToVisual(int n) {
        this.validate(n);
        return this.l2v(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("[source:");
        stringBuffer.append(this.source);
        stringBuffer.append(", lb:");
        stringBuffer.append(this.lb);
        stringBuffer.append(", ab:");
        stringBuffer.append(this.ab);
        stringBuffer.append(", vb:");
        stringBuffer.append(this.vb);
        stringBuffer.append(", gv:");
        stringBuffer.append(this.gv);
        stringBuffer.append(", seg:");
        stringBuffer.append(this.shapedSeg);
        stringBuffer.append(", ci:");
        stringBuffer.append(this.charinfo == null ? "null" : Integer.toString(this.charinfo.length));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected int v2l(int n) {
        return this.source.dataIsLTR() ? n : this.source.getLength() - 1 - n;
    }

    private void validate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index " + n + " < 0");
        }
        if (n >= this.source.getLength()) {
            throw new IllegalArgumentException("index " + n + " < " + this.source.getLength());
        }
    }

    public int visualToLogical(int n) {
        this.validate(n);
        return this.v2l(n);
    }
}

