/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.log;

import java.io.IOException;
import java.io.InputStream;
import sun.rmi.log.LogException;

public class LogInputStream
extends InputStream {
    private InputStream in;
    private int length;

    public LogInputStream(InputStream inputStream, int n) throws IOException {
        this.in = inputStream;
        this.length = n;
    }

    public int available() {
        return this.length;
    }

    private void checkRead(int n) throws LogException {
        if (this.length < n) {
            throw new LogException("length=" + String.valueOf(this.length - n) + ", numBytes=" + String.valueOf(n));
        }
    }

    public void close() {
        this.length = 0;
    }

    private void doneRead(int n) throws IndexOutOfBoundsException {
        this.length -= n;
        if (this.length < 0) {
            throw new IndexOutOfBoundsException("LogInputStream internal error: length=" + String.valueOf(this.length) + ", numBytes=" + String.valueOf(n));
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public int read() throws IOException, LogException {
        this.checkRead(1);
        int n = this.in.read();
        if (n != -1) {
            this.doneRead(1);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException, LogException {
        this.checkRead(byArray.length);
        int n = this.in.read(byArray);
        if (n > 0) {
            this.doneRead(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, LogException {
        this.checkRead(n2);
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.doneRead(n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException, LogException {
        if (l > Integer.MAX_VALUE) {
            throw new IOException("Too many bytes to skip - " + l);
        }
        this.checkRead((int)l);
        long l2 = this.in.skip(l);
        if (l2 > 0L) {
            this.doneRead((int)l2);
        }
        return l2;
    }
}

