/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.AWTError;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class PrinterJob {
    public abstract void cancel();

    public PageFormat defaultPage() {
        return this.defaultPage(new PageFormat());
    }

    public abstract PageFormat defaultPage(PageFormat var1);

    public abstract int getCopies();

    public abstract String getJobName();

    public static PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return (PrinterJob)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("java.awt.printerjob", null);
                try {
                    return (PrinterJob)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("PrinterJob not found: " + string);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate PrinterJob: " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access PrinterJob: " + string);
                }
            }
        });
    }

    public abstract String getUserName();

    public abstract boolean isCancelled();

    public abstract PageFormat pageDialog(PageFormat var1);

    public abstract void print() throws PrinterException;

    public abstract boolean printDialog();

    public abstract void setCopies(int var1);

    public abstract void setJobName(String var1);

    public abstract void setPageable(Pageable var1) throws NullPointerException;

    public abstract void setPrintable(Printable var1);

    public abstract void setPrintable(Printable var1, PageFormat var2);

    public abstract PageFormat validatePage(PageFormat var1);
}

