/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String str;
    private int length;
    private int next = 0;
    private int mark = 0;

    public StringReader(String string) {
        this.str = string;
        this.length = string.length();
    }

    public void close() {
        this.str = null;
    }

    private void ensureOpen() throws IOException {
        if (this.str == null) {
            throw new IOException("Stream closed");
        }
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.mark = this.next;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                int n = -1;
                Object var3_4 = null;
                return n;
            }
            char c = this.str.charAt(this.next++);
            Object var3_5 = null;
            return c;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n > cArray.length) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n + n2 > cArray.length) throw new IndexOutOfBoundsException();
            if (n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            int n3 = Math.min(this.length - this.next, n2);
            this.str.getChars(this.next, this.next + n3, cArray, n);
            this.next += n3;
            return n3;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean bl = true;
            Object var3_3 = null;
            return bl;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.next = this.mark;
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.next >= this.length) {
                long l2 = 0L;
                Object var6_5 = null;
                return l2;
            }
            long l3 = Math.min((long)(this.length - this.next), l);
            this.next = (int)((long)this.next + l3);
            long l4 = l3;
            Object var6_6 = null;
            return l4;
        }
    }
}

