/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;

public class ReferenceQueue {
    static ReferenceQueue NULL = new Null();
    static ReferenceQueue ENQUEUED = new Null();
    private Lock lock = new Lock();
    private Reference head = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean enqueue(Reference reference) {
        Reference reference2 = reference;
        synchronized (reference2) {
            if (reference.queue == ENQUEUED) {
                return false;
            }
            Lock lock = this.lock;
            synchronized (lock) {
                reference.queue = ENQUEUED;
                reference.next = this.head == null ? reference : this.head;
                this.head = reference;
                this.lock.notifyAll();
                return true;
            }
        }
    }

    public Reference poll() {
        Lock lock = this.lock;
        synchronized (lock) {
            Reference reference = this.reallyPoll();
            Object var3_3 = null;
            return reference;
        }
    }

    private Reference reallyPoll() {
        if (this.head != null) {
            Reference reference = this.head;
            this.head = reference.next == reference ? null : reference.next;
            reference.queue = NULL;
            reference.next = reference;
            return reference;
        }
        return null;
    }

    public Reference remove() throws InterruptedException {
        return this.remove(0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reference remove(long l) throws IllegalArgumentException, InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout value");
        }
        Lock lock = this.lock;
        synchronized (lock) {
            Reference reference = this.reallyPoll();
            if (reference != null) {
                return reference;
            }
            do {
                this.lock.wait(l);
                reference = this.reallyPoll();
                if (reference == null) continue;
                return reference;
            } while (l == 0L);
            return null;
        }
    }

    private static class Null
    extends ReferenceQueue {
        Null() {
        }

        boolean enqueue(Reference reference) {
            return false;
        }
    }

    private static class Lock {
        Lock() {
        }
    }
}

