/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributeEntry;
import java.text.AttributedCharacterIterator;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class AttributedString {
    private static final int ARRAY_SIZE_INCREMENT = 10;
    String text;
    int runArraySize;
    int runCount;
    int[] runStarts;
    Vector[] runAttributes;
    Vector[] runAttributeValues;

    public AttributedString(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
    }

    public AttributedString(String string, Map map) {
        if (string == null || map == null) {
            throw new NullPointerException();
        }
        this.text = string;
        if (string.length() == 0) {
            if (map.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        int n = map.size();
        if (n > 0) {
            this.createRunAttributeDataVectors();
            Vector vector = new Vector(n);
            Vector vector2 = new Vector(n);
            this.runAttributes[0] = vector;
            this.runAttributeValues[0] = vector2;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                vector.addElement(entry.getKey());
                vector2.addElement(entry.getValue());
            }
        }
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator) {
        this(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this(attributedCharacterIterator, n, n2, null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException();
        }
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        if (n < n3 || n2 > n4 || n > n2) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        StringBuffer stringBuffer = new StringBuffer();
        attributedCharacterIterator.setIndex(n);
        char c = attributedCharacterIterator.current();
        while (attributedCharacterIterator.getIndex() < n2) {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.text = stringBuffer.toString();
        if (n == n2) {
            return;
        }
        HashSet hashSet = new HashSet();
        if (attributeArray == null) {
            hashSet.addAll(attributedCharacterIterator.getAllAttributeKeys());
        } else {
            int n5 = 0;
            while (n5 < attributeArray.length) {
                hashSet.add(attributeArray[n5]);
                ++n5;
            }
            hashSet.retainAll(attributedCharacterIterator.getAllAttributeKeys());
        }
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        block2: while (iterator.hasNext()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator.next();
            attributedCharacterIterator.setIndex(n3);
            while (attributedCharacterIterator.getIndex() < n2) {
                int n6 = attributedCharacterIterator.getRunStart(attribute);
                int n7 = attributedCharacterIterator.getRunLimit(attribute);
                Object object = attributedCharacterIterator.getAttribute(attribute);
                if (object != null) {
                    if (object instanceof Annotation) {
                        if (n6 >= n && n7 <= n2) {
                            this.addAttribute(attribute, object, n6 - n, n7 - n);
                        } else if (n7 > n2) {
                            continue block2;
                        }
                    } else {
                        if (n6 >= n2) continue block2;
                        if (n7 > n) {
                            if (n6 < n) {
                                n6 = n;
                            }
                            if (n7 > n2) {
                                n7 = n2;
                            }
                            if (n6 != n7) {
                                this.addAttribute(attribute, object, n6 - n, n7 - n);
                            }
                        }
                    }
                }
                attributedCharacterIterator.setIndex(n7);
            }
        }
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        int n = this.length();
        if (n == 0) {
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        this.addAttributeImpl(attribute, object, 0, n);
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (attribute == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 > this.length() || n >= n2) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        this.addAttributeImpl(attribute, object, n, n2);
    }

    private synchronized void addAttributeImpl(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n3 = this.ensureRunBreak(n);
        int n4 = this.ensureRunBreak(n2);
        this.addAttributeRunData(attribute, object, n3, n4);
    }

    private void addAttributeRunData(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = -1;
            if (this.runAttributes[n3] == null) {
                Vector vector = new Vector();
                Vector vector2 = new Vector();
                this.runAttributes[n3] = vector;
                this.runAttributeValues[n3] = vector2;
            } else {
                n4 = this.runAttributes[n3].indexOf(attribute);
            }
            if (n4 == -1) {
                int n5 = this.runAttributes[n3].size();
                this.runAttributes[n3].addElement(attribute);
                try {
                    this.runAttributeValues[n3].addElement(object);
                }
                catch (Exception exception) {
                    this.runAttributes[n3].setSize(n5);
                    this.runAttributeValues[n3].setSize(n5);
                }
            } else {
                this.runAttributeValues[n3].set(n4, object);
            }
            ++n3;
        }
    }

    public void addAttributes(Map map, int n, int n2) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 > this.length() || n > n2) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        if (n == n2) {
            if (map.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        if (this.runCount == 0) {
            this.createRunAttributeDataVectors();
        }
        int n3 = this.ensureRunBreak(n);
        int n4 = this.ensureRunBreak(n2);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.addAttributeRunData((AttributedCharacterIterator.Attribute)entry.getKey(), entry.getValue(), n3, n4);
        }
    }

    private boolean attributeValuesMatch(Set set, int n, int n2) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)iterator.next();
            if (AttributedString.valuesMatch(this.getAttribute(attribute, n), this.getAttribute(attribute, n2))) continue;
            return false;
        }
        return true;
    }

    private char charAt(int n) {
        return this.text.charAt(n);
    }

    private final void createRunAttributeDataVectors() {
        int[] nArray = new int[10];
        Vector[] vectorArray = new Vector[10];
        Vector[] vectorArray2 = new Vector[10];
        this.runStarts = nArray;
        this.runAttributes = vectorArray;
        this.runAttributeValues = vectorArray2;
        this.runArraySize = 10;
        this.runCount = 1;
    }

    private final int ensureRunBreak(int n) {
        int n2;
        Object object;
        Object object2;
        Object object3;
        if (n == this.length()) {
            return this.runCount;
        }
        int n3 = 0;
        while (n3 < this.runCount && this.runStarts[n3] < n) {
            ++n3;
        }
        if (n3 < this.runCount && this.runStarts[n3] == n) {
            return n3;
        }
        if (this.runCount == this.runArraySize) {
            int n4 = this.runArraySize + 10;
            object3 = new int[n4];
            object2 = new Vector[n4];
            object = new Vector[n4];
            n2 = 0;
            while (n2 < this.runArraySize) {
                object3[n2] = this.runStarts[n2];
                object2[n2] = this.runAttributes[n2];
                object[n2] = this.runAttributeValues[n2];
                ++n2;
            }
            this.runStarts = object3;
            this.runAttributes = object2;
            this.runAttributeValues = object;
            this.runArraySize = n4;
        }
        Vector vector = null;
        object3 = null;
        object2 = this.runAttributes[n3 - 1];
        object = this.runAttributeValues[n3 - 1];
        if (object2 != null) {
            vector = (Vector)((Vector)object2).clone();
        }
        if (object != null) {
            object3 = (Vector)((Vector)object).clone();
        }
        ++this.runCount;
        n2 = this.runCount - 1;
        while (n2 > n3) {
            this.runStarts[n2] = this.runStarts[n2 - 1];
            this.runAttributes[n2] = this.runAttributes[n2 - 1];
            this.runAttributeValues[n2] = this.runAttributeValues[n2 - 1];
            --n2;
        }
        this.runStarts[n3] = n;
        this.runAttributes[n3] = vector;
        this.runAttributeValues[n3] = object3;
        return n3;
    }

    private synchronized Object getAttribute(AttributedCharacterIterator.Attribute attribute, int n) {
        Vector vector = this.runAttributes[n];
        Vector vector2 = this.runAttributeValues[n];
        if (vector == null) {
            return null;
        }
        int n2 = vector.indexOf(attribute);
        if (n2 != -1) {
            return vector2.elementAt(n2);
        }
        return null;
    }

    private Object getAttributeCheckRange(AttributedCharacterIterator.Attribute attribute, int n, int n2, int n3) {
        Object object = this.getAttribute(attribute, n);
        if (object instanceof Annotation) {
            int n4;
            int n5;
            if (n2 > 0) {
                n5 = n;
                n4 = this.runStarts[n5];
                while (n4 >= n2 && AttributedString.valuesMatch(object, this.getAttribute(attribute, n5 - 1))) {
                    n4 = this.runStarts[--n5];
                }
                if (n4 < n2) {
                    return null;
                }
            }
            if (n3 < (n5 = this.length())) {
                n4 = n;
                int n6 = n4 < this.runCount - 1 ? this.runStarts[n4 + 1] : n5;
                while (n6 <= n3 && AttributedString.valuesMatch(object, this.getAttribute(attribute, n4 + 1))) {
                    int n7 = n6 = ++n4 < this.runCount - 1 ? this.runStarts[n4 + 1] : n5;
                }
                if (n6 > n3) {
                    return null;
                }
            }
        }
        return object;
    }

    public AttributedCharacterIterator getIterator() {
        return this.getIterator(null, 0, this.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getIterator(attributeArray, 0, this.length());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
        return new AttributedStringIterator(attributeArray, n, n2);
    }

    private int length() {
        return this.text.length();
    }

    private static final boolean valuesMatch(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private final class AttributedStringIterator
    implements AttributedCharacterIterator {
        private int beginIndex;
        private int endIndex;
        private AttributedCharacterIterator.Attribute[] relevantAttributes;
        private int currentIndex;
        private int currentRunIndex;
        private int currentRunStart;
        private int currentRunLimit;

        AttributedStringIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
            if (n < 0 || n > n2 || n2 > AttributedString.this.length()) {
                throw new IllegalArgumentException("Invalid substring range");
            }
            this.beginIndex = n;
            this.endIndex = n2;
            this.currentIndex = n;
            this.updateRunInfo();
            if (attributeArray != null) {
                this.relevantAttributes = (AttributedCharacterIterator.Attribute[])attributeArray.clone();
            }
        }

        public Object clone() {
            try {
                AttributedStringIterator attributedStringIterator = (AttributedStringIterator)super.clone();
                return attributedStringIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public char current() {
            if (this.currentIndex == this.endIndex) {
                return '\uffff';
            }
            return AttributedString.this.charAt(this.currentIndex);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AttributedStringIterator)) {
                return false;
            }
            AttributedStringIterator attributedStringIterator = (AttributedStringIterator)object;
            if (AttributedString.this != attributedStringIterator.getString()) {
                return false;
            }
            return this.currentIndex == attributedStringIterator.currentIndex && this.beginIndex == attributedStringIterator.beginIndex && this.endIndex == attributedStringIterator.endIndex;
        }

        public char first() {
            return this.internalSetIndex(this.beginIndex);
        }

        public Set getAllAttributeKeys() {
            if (AttributedString.this.runAttributes == null) {
                return new HashSet();
            }
            AttributedString attributedString = AttributedString.this;
            synchronized (attributedString) {
                HashSet hashSet = new HashSet();
                int n = 0;
                while (n < AttributedString.this.runCount) {
                    Vector vector;
                    if (AttributedString.this.runStarts[n] < this.endIndex && (n == AttributedString.this.runCount - 1 || AttributedString.this.runStarts[n + 1] > this.beginIndex) && (vector = AttributedString.this.runAttributes[n]) != null) {
                        int n2 = vector.size();
                        while (n2-- > 0) {
                            hashSet.add(vector.get(n2));
                        }
                    }
                    ++n;
                }
                HashSet hashSet2 = hashSet;
                Object var3_7 = null;
                return hashSet2;
            }
        }

        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            int n = this.currentRunIndex;
            if (n < 0) {
                return null;
            }
            return AttributedString.this.getAttributeCheckRange(attribute, n, this.beginIndex, this.endIndex);
        }

        public Map getAttributes() {
            if (AttributedString.this.runAttributes == null || this.currentRunIndex == -1 || AttributedString.this.runAttributes[this.currentRunIndex] == null) {
                return new Hashtable();
            }
            return new AttributeMap(this.currentRunIndex, this.beginIndex, this.endIndex);
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public int getRunLimit() {
            return this.currentRunLimit;
        }

        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
                return this.currentRunLimit;
            }
            Object object = this.getAttribute(attribute);
            int n = this.currentRunLimit;
            int n2 = this.currentRunIndex;
            while (n < this.endIndex && AttributedString.valuesMatch(object, AttributedString.this.getAttribute(attribute, n2 + 1))) {
                int n3 = n = ++n2 < AttributedString.this.runCount - 1 ? AttributedString.this.runStarts[n2 + 1] : this.endIndex;
            }
            if (n > this.endIndex) {
                n = this.endIndex;
            }
            return n;
        }

        public int getRunLimit(Set set) {
            if (this.currentRunLimit == this.endIndex || this.currentRunIndex == -1) {
                return this.currentRunLimit;
            }
            int n = this.currentRunLimit;
            int n2 = this.currentRunIndex;
            while (n < this.endIndex && AttributedString.this.attributeValuesMatch(set, this.currentRunIndex, n2 + 1)) {
                int n3 = n = ++n2 < AttributedString.this.runCount - 1 ? AttributedString.this.runStarts[n2 + 1] : this.endIndex;
            }
            if (n > this.endIndex) {
                n = this.endIndex;
            }
            return n;
        }

        public int getRunStart() {
            return this.currentRunStart;
        }

        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
                return this.currentRunStart;
            }
            Object object = this.getAttribute(attribute);
            int n = this.currentRunStart;
            int n2 = this.currentRunIndex;
            while (n > this.beginIndex && AttributedString.valuesMatch(object, AttributedString.this.getAttribute(attribute, n2 - 1))) {
                n = AttributedString.this.runStarts[--n2];
            }
            if (n < this.beginIndex) {
                n = this.beginIndex;
            }
            return n;
        }

        public int getRunStart(Set set) {
            if (this.currentRunStart == this.beginIndex || this.currentRunIndex == -1) {
                return this.currentRunStart;
            }
            int n = this.currentRunStart;
            int n2 = this.currentRunIndex;
            while (n > this.beginIndex && AttributedString.this.attributeValuesMatch(set, this.currentRunIndex, n2 - 1)) {
                n = AttributedString.this.runStarts[--n2];
            }
            if (n < this.beginIndex) {
                n = this.beginIndex;
            }
            return n;
        }

        private AttributedString getString() {
            return AttributedString.this;
        }

        public int hashCode() {
            return AttributedString.this.text.hashCode() ^ this.currentIndex ^ this.beginIndex ^ this.endIndex;
        }

        private char internalSetIndex(int n) {
            this.currentIndex = n;
            if (n < this.currentRunStart || n >= this.currentRunLimit) {
                this.updateRunInfo();
            }
            if (this.currentIndex == this.endIndex) {
                return '\uffff';
            }
            return AttributedString.this.charAt(n);
        }

        public char last() {
            if (this.endIndex == this.beginIndex) {
                return this.internalSetIndex(this.endIndex);
            }
            return this.internalSetIndex(this.endIndex - 1);
        }

        public char next() {
            if (this.currentIndex < this.endIndex) {
                return this.internalSetIndex(this.currentIndex + 1);
            }
            return '\uffff';
        }

        public char previous() {
            if (this.currentIndex > this.beginIndex) {
                return this.internalSetIndex(this.currentIndex - 1);
            }
            return '\uffff';
        }

        public char setIndex(int n) {
            if (n < this.beginIndex || n > this.endIndex) {
                throw new IllegalArgumentException("Invalid index");
            }
            return this.internalSetIndex(n);
        }

        private void updateRunInfo() {
            if (this.currentIndex == this.endIndex) {
                this.currentRunStart = this.currentRunLimit = this.endIndex;
                this.currentRunIndex = -1;
            } else {
                AttributedString attributedString = AttributedString.this;
                synchronized (attributedString) {
                    int n = -1;
                    while (n < AttributedString.this.runCount - 1 && AttributedString.this.runStarts[n + 1] <= this.currentIndex) {
                        ++n;
                    }
                    this.currentRunIndex = n;
                    if (n >= 0) {
                        this.currentRunStart = AttributedString.this.runStarts[n];
                        if (this.currentRunStart < this.beginIndex) {
                            this.currentRunStart = this.beginIndex;
                        }
                    } else {
                        this.currentRunStart = this.beginIndex;
                    }
                    if (n < AttributedString.this.runCount - 1) {
                        this.currentRunLimit = AttributedString.this.runStarts[n + 1];
                        if (this.currentRunLimit > this.endIndex) {
                            this.currentRunLimit = this.endIndex;
                        }
                    } else {
                        this.currentRunLimit = this.endIndex;
                    }
                }
            }
        }
    }

    private final class AttributeMap
    extends AbstractMap {
        int runIndex;
        int beginIndex;
        int endIndex;

        AttributeMap(int n, int n2, int n3) {
            this.runIndex = n;
            this.beginIndex = n2;
            this.endIndex = n3;
        }

        public Set entrySet() {
            HashSet hashSet = new HashSet();
            AttributedString attributedString = AttributedString.this;
            synchronized (attributedString) {
                int n = AttributedString.this.runAttributes[this.runIndex].size();
                int n2 = 0;
                while (n2 < n) {
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)AttributedString.this.runAttributes[this.runIndex].get(n2);
                    Object object = AttributedString.this.runAttributeValues[this.runIndex].get(n2);
                    if (!(object instanceof Annotation) || (object = AttributedString.this.getAttributeCheckRange(attribute, this.runIndex, this.beginIndex, this.endIndex)) != null) {
                        AttributeEntry attributeEntry = new AttributeEntry(attribute, object);
                        hashSet.add(attributeEntry);
                    }
                    ++n2;
                }
            }
            return hashSet;
        }

        public Object get(Object object) {
            return AttributedString.this.getAttributeCheckRange((AttributedCharacterIterator.Attribute)object, this.runIndex, this.beginIndex, this.endIndex);
        }
    }
}

