/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class CompactShortArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    static final int BLOCKSHIFT = 7;
    static final int BLOCKCOUNT = 128;
    static final int INDEXSHIFT = 9;
    static final int INDEXCOUNT = 512;
    static final int BLOCKMASK = 127;
    private short[] values;
    private short[] indices;
    private int[] hashes;
    private boolean isCompact;
    short defaultValue;

    public CompactShortArray() {
        this(0);
    }

    public CompactShortArray(short s) {
        this.values = new short[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        int n = 0;
        while (n < 65536) {
            this.values[n] = s;
            ++n;
        }
        n = 0;
        while (n < 512) {
            this.indices[n] = (short)(n << 7);
            this.hashes[n] = 0;
            ++n;
        }
        this.isCompact = false;
        this.defaultValue = s;
    }

    public CompactShortArray(short[] sArray, short[] sArray2, short s) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n = 0;
        while (n < 512) {
            short s2 = sArray[n];
            if (s2 < 0 || s2 >= sArray2.length + 128) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n;
        }
        this.indices = sArray;
        this.values = sArray2;
        this.isCompact = true;
        this.defaultValue = s;
    }

    static /* synthetic */ short[] access$0(CompactShortArray compactShortArray) {
        return compactShortArray.indices;
    }

    static final boolean arrayRegionMatches(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        int n6 = n;
        while (n6 < n4) {
            if (sArray[n6] != sArray2[n6 + n5]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public Object clone() {
        try {
            CompactShortArray compactShortArray = (CompactShortArray)super.clone();
            compactShortArray.values = (short[])this.values.clone();
            compactShortArray.indices = (short[])this.indices.clone();
            return compactShortArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = -1;
                n = this.blockTouched(n5) ? 1 : 0;
                if (n == 0 && n4 != -1) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && CompactShortArray.arrayRegionMatches(this.values, n3, this.values, n6, 128)) {
                            this.indices[n5] = (short)n6;
                        }
                        ++n7;
                        n6 += 128;
                    }
                    if (this.indices[n5] == -1) {
                        System.arraycopy(this.values, n3, this.values, n6, 128);
                        this.indices[n5] = (short)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (n == 0) {
                            n4 = (short)n6;
                        }
                    }
                }
                ++n5;
                n3 += 128;
            }
            n = n2 * 128;
            short[] sArray = new short[n];
            System.arraycopy(this.values, 0, sArray, 0, n);
            this.values = sArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    public short elementAt(char c) {
        return this.values[(this.indices[c >> 7] & 0xFFFF) + (c & 0x7F)];
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactShortArray compactShortArray = (CompactShortArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactShortArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void expand() {
        if (this.isCompact) {
            short[] sArray = new short[65536];
            int n = 0;
            while (n < 65536) {
                sArray[n] = this.elementAt((char)n);
                ++n;
            }
            n = 0;
            while (n < 512) {
                this.indices[n] = (short)(n << 7);
                ++n;
            }
            this.values = null;
            this.values = sArray;
            this.isCompact = false;
        }
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    public short[] getStringArray() {
        return this.values;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    public void setElementAt(char n, char c, short s) {
        if (this.isCompact) {
            this.expand();
        }
        int n2 = n;
        while (n2 <= c) {
            this.values[n2] = s;
            this.touchBlock(n2 >> 7, s);
            ++n2;
        }
    }

    public void setElementAt(char c, short s) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = s;
        this.touchBlock(c >> 7, s);
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    public class Iterator {
        int nextIndex = -1;
        int index = -1;
        short nextValue;
        short value;
        short iUntouched = (short)-1;
        boolean touched = true;
        short defValue;

        Iterator() {
            this.defValue = CompactShortArray.this.defaultValue;
            CompactShortArray.this.compact();
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            this.nextIndex = this.index;
            var1_1 = true;
            if (this.index == this.nextIndex) ** GOTO lbl18
            return true;
lbl-1000:
            // 1 sources

            {
                if ((this.nextIndex & 127) == 0) {
                    var2_2 = this.nextIndex >> 7;
                    if (CompactShortArray.access$0(CompactShortArray.this)[var2_2] == this.iUntouched) {
                        this.nextIndex += 127;
                        continue;
                    }
                    if (this.iUntouched == -1 && !this.touched) {
                        this.iUntouched = CompactShortArray.access$0(CompactShortArray.this)[var2_2 - 1];
                    } else {
                        this.touched = false;
                    }
                }
                this.nextValue = CompactShortArray.this.elementAt((char)this.nextIndex);
                if (this.nextValue == this.defValue) continue;
                this.touched = true;
                break;
lbl18:
                // 3 sources

                ** while (++this.nextIndex < 65535)
            }
lbl19:
            // 2 sources

            return this.nextIndex < 65535;
        }

        public char next() {
            if (this.index == this.nextIndex && !this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.index = this.nextIndex;
            this.value = this.nextValue;
            return (char)this.index;
        }

        public short shortValue() {
            return this.value;
        }
    }
}

