/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import javax.swing.DebugGraphicsFilter;
import javax.swing.DebugGraphicsInfo;
import javax.swing.DebugGraphicsObserver;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DebugGraphics
extends Graphics {
    Graphics graphics;
    Image buffer = null;
    int debugOptions;
    int graphicsID = graphicsCount++;
    int xOffset = 0;
    int yOffset = 0;
    private static int graphicsCount = 0;
    public static final int LOG_OPTION = 1;
    public static final int FLASH_OPTION = 2;
    public static final int BUFFERED_OPTION = 4;
    public static final int NONE_OPTION = -1;
    private static final Class debugGraphicsInfoKey;
    static /* synthetic */ Class class$javax$swing$DebugGraphicsInfo;

    static {
        Class clazz = debugGraphicsInfoKey = class$javax$swing$DebugGraphicsInfo != null ? class$javax$swing$DebugGraphicsInfo : (class$javax$swing$DebugGraphicsInfo = DebugGraphics.class$("javax.swing.DebugGraphicsInfo"));
        if (!SwingUtilities.is1dot2) {
            System.err.println("warning: running 1.2 version of DebugGraphics");
        }
    }

    public DebugGraphics() {
    }

    public DebugGraphics(Graphics graphics) {
        this();
        this.graphics = graphics;
    }

    public DebugGraphics(Graphics graphics, JComponent jComponent) {
        this(graphics);
        this.setDebugOptions(jComponent.shouldDebugGraphics());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Clearing rect: " + new Rectangle(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.clearRect(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.clearRect(n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.clearRect(n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.graphics.clipRect(n, n2, n3, n4);
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting clipRect: " + new Rectangle(n, n2, n3, n4) + " New clipRect: " + this.graphics.getClip());
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Copying area from: " + new Rectangle(n, n2, n3, n4) + " to: " + new Point(n5, n6));
        }
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        DebugGraphics debugGraphics = new DebugGraphics();
        debugGraphics.graphics = this.graphics.create();
        debugGraphics.debugOptions = this.debugOptions;
        debugGraphics.buffer = this.buffer;
        return debugGraphics;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        DebugGraphics debugGraphics = new DebugGraphics();
        debugGraphics.graphics = this.graphics.create(n, n2, n3, n4);
        debugGraphics.debugOptions = this.debugOptions;
        debugGraphics.buffer = this.buffer;
        debugGraphics.xOffset = this.xOffset + n;
        debugGraphics.yOffset = this.yOffset + n2;
        return debugGraphics;
    }

    boolean debugBuffered() {
        return (this.debugOptions & 4) == 4;
    }

    static int debugComponentCount() {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo != null && debugGraphicsInfo.componentToDebug != null) {
            return debugGraphicsInfo.componentToDebug.size();
        }
        return 0;
    }

    boolean debugFlash() {
        return (this.debugOptions & 2) == 2;
    }

    private Graphics debugGraphics() {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo.debugFrame == null) {
            debugGraphicsInfo.debugFrame = new JFrame();
            debugGraphicsInfo.debugFrame.setSize(500, 500);
        }
        JFrame jFrame = debugGraphicsInfo.debugFrame;
        jFrame.show();
        DebugGraphics debugGraphics = new DebugGraphics(jFrame.getGraphics());
        debugGraphics.setFont(this.getFont());
        debugGraphics.setColor(this.getColor());
        debugGraphics.translate(this.xOffset, this.yOffset);
        debugGraphics.setClip(this.getClipBounds());
        if (this.debugFlash()) {
            debugGraphics.setDebugOptions(2);
        }
        return debugGraphics;
    }

    boolean debugLog() {
        return (this.debugOptions & 1) == 1;
    }

    public void dispose() {
        this.graphics.dispose();
        this.graphics = null;
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing 3D rect: " + new Rectangle(n, n2, n3, n4) + " Raised bezel: " + bl);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.draw3DRect(n, n2, n3, n4, bl);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.draw3DRect(n, n2, n3, n4, bl);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.draw3DRect(n, n2, n3, n4, bl);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing arc: " + new Rectangle(n, n2, n3, n4) + " startAngle: " + n5 + " arcAngle: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawArc(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                this.graphics.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawArc(n, n2, n3, n4, n5, n6);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        Font font = this.graphics.getFont();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing bytes at: " + new Point(n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawBytes(byArray, n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawBytes(byArray, n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawBytes(byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        Font font = this.graphics.getFont();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing chars at " + new Point(n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawChars(cArray, n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawChars(cArray, n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawChars(cArray, n, n2, n3, n4);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(String.valueOf(this.toShortString()) + " Drawing image: " + image + " destination: " + new Rectangle(n, n2, n3, n4) + " source: " + new Rectangle(n5, n6, n7, n8) + ", bgcolor: " + color);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n9 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            int n10 = 0;
            while (n10 < n9) {
                this.graphics.drawImage(n10 % 2 == 0 ? image2 : image, n, n2, n3, n4, n5, n6, n7, n8, color, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
                ++n10;
            }
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(String.valueOf(this.toShortString()) + " Drawing image: " + image + " destination: " + new Rectangle(n, n2, n3, n4) + " source: " + new Rectangle(n5, n6, n7, n8));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n9 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            int n10 = 0;
            while (n10 < n9) {
                this.graphics.drawImage(n10 % 2 == 0 ? image2 : image, n, n2, n3, n4, n5, n6, n7, n8, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
                ++n10;
            }
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(String.valueOf(this.toShortString()) + " Drawing image: " + image + " at: " + new Rectangle(n, n2, n3, n4) + ", bgcolor: " + color);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.drawImage(n6 % 2 == 0 ? image2 : image, n, n2, n3, n4, color, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(String.valueOf(this.toShortString()) + " Drawing image: " + image + " at: " + new Rectangle(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n, n2, n3, n4, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.drawImage(n6 % 2 == 0 ? image2 : image, n, n2, n3, n4, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
        }
        return this.graphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(String.valueOf(this.toShortString()) + " Drawing image: " + image + " at: " + new Point(n, n2) + ", bgcolor: " + color);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n, n2, color, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            int n4 = 0;
            while (n4 < n3) {
                this.graphics.drawImage(n4 % 2 == 0 ? image2 : image, n, n2, color, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
                ++n4;
            }
        }
        return this.graphics.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            debugGraphicsInfo.log(String.valueOf(this.toShortString()) + " Drawing image: " + image + " at: " + new Point(n, n2));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawImage(image, n, n2, imageObserver);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            ImageProducer imageProducer = image.getSource();
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageProducer, new DebugGraphicsFilter(debugGraphicsInfo.flashColor));
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            DebugGraphicsObserver debugGraphicsObserver = new DebugGraphicsObserver();
            int n4 = 0;
            while (n4 < n3) {
                this.graphics.drawImage(n4 % 2 == 0 ? image2 : image, n, n2, debugGraphicsObserver);
                Toolkit.getDefaultToolkit().sync();
                while (!debugGraphicsObserver.allBitsPresent() && !debugGraphicsObserver.imageHasProblem()) {
                    this.sleep(10);
                }
                this.sleep(debugGraphicsInfo.flashTime);
                ++n4;
            }
        }
        return this.graphics.drawImage(image, n, n2, imageObserver);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing line: from " + this.pointToString(n, n2) + " to " + this.pointToString(n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawLine(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawLine(n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing oval: " + new Rectangle(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawOval(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawOval(n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawOval(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing polygon: " + " nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawPolygon(nArray, nArray2, n);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n2 = debugGraphicsInfo.flashCount * 2 - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.graphics.setColor(n3 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawPolygon(nArray, nArray2, n);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n3;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing polyline: " + " nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawPolyline(nArray, nArray2, n);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n2 = debugGraphicsInfo.flashCount * 2 - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.graphics.setColor(n3 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawPolyline(nArray, nArray2, n);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n3;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawPolyline(nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing rect: " + new Rectangle(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawRect(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawRect(n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing round rect: " + new Rectangle(n, n2, n3, n4) + " arcWidth: " + n5 + " archHeight: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                this.graphics.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, int n, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing string: \"" + string + "\" at: " + new Point(n, n2));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawString(string, n, n2);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            int n4 = 0;
            while (n4 < n3) {
                this.graphics.setColor(n4 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawString(string, n, n2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n4;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Drawing text: \"" + attributedCharacterIterator + "\" at: " + new Point(n, n2));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.drawString(attributedCharacterIterator, n, n2);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n3 = debugGraphicsInfo.flashCount * 2 - 1;
            int n4 = 0;
            while (n4 < n3) {
                this.graphics.setColor(n4 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.drawString(attributedCharacterIterator, n, n2);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n4;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawString(attributedCharacterIterator, n, n2);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling 3D rect: " + new Rectangle(n, n2, n3, n4) + " Raised bezel: " + bl);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fill3DRect(n, n2, n3, n4, bl);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fill3DRect(n, n2, n3, n4, bl);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.fill3DRect(n, n2, n3, n4, bl);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling arc: " + new Rectangle(n, n2, n3, n4) + " startAngle: " + n5 + " arcAngle: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillArc(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                this.graphics.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillArc(n, n2, n3, n4, n5, n6);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling oval: " + new Rectangle(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillOval(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillOval(n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling polygon: " + " nPoints: " + n + " X's: " + nArray + " Y's: " + nArray2);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillPolygon(nArray, nArray2, n);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n2 = debugGraphicsInfo.flashCount * 2 - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.graphics.setColor(n3 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillPolygon(nArray, nArray2, n);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n3;
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling rect: " + new Rectangle(n, n2, n3, n4));
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillRect(n, n2, n3, n4);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n5 = debugGraphicsInfo.flashCount * 2 - 1;
            int n6 = 0;
            while (n6 < n5) {
                this.graphics.setColor(n6 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillRect(n, n2, n3, n4);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n6;
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Filling round rect: " + new Rectangle(n, n2, n3, n4) + " arcWidth: " + n5 + " archHeight: " + n6);
        }
        if (this.isDrawingBuffer()) {
            if (this.debugBuffered()) {
                Graphics graphics = this.debugGraphics();
                graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
                graphics.dispose();
            }
        } else if (this.debugFlash()) {
            Color color = this.getColor();
            int n7 = debugGraphicsInfo.flashCount * 2 - 1;
            int n8 = 0;
            while (n8 < n7) {
                this.graphics.setColor(n8 % 2 == 0 ? debugGraphicsInfo.flashColor : color);
                this.graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
                Toolkit.getDefaultToolkit().sync();
                this.sleep(debugGraphicsInfo.flashTime);
                ++n8;
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public static Color flashColor() {
        return DebugGraphics.info().flashColor;
    }

    public static int flashCount() {
        return DebugGraphics.info().flashCount;
    }

    public static int flashTime() {
        return DebugGraphics.info().flashTime;
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    public Color getColor() {
        return this.graphics.getColor();
    }

    public int getDebugOptions() {
        return this.debugOptions;
    }

    static int getDebugOptions(JComponent jComponent) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo == null) {
            return 0;
        }
        return debugGraphicsInfo.getDebugOptions(jComponent);
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    static DebugGraphicsInfo info() {
        DebugGraphicsInfo debugGraphicsInfo = (DebugGraphicsInfo)SwingUtilities.appContextGet(debugGraphicsInfoKey);
        if (debugGraphicsInfo == null) {
            debugGraphicsInfo = new DebugGraphicsInfo();
            SwingUtilities.appContextPut(debugGraphicsInfoKey, debugGraphicsInfo);
        }
        return debugGraphicsInfo;
    }

    public boolean isDrawingBuffer() {
        return this.buffer != null;
    }

    public static PrintStream logStream() {
        return DebugGraphics.info().stream;
    }

    String pointToString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("(" + n + ", " + n2 + ")");
        return stringBuffer.toString();
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.graphics.setClip(n, n2, n3, n4);
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting new clipRect: " + this.graphics.getClip());
        }
    }

    public void setClip(Shape shape) {
        this.graphics.setClip(shape);
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting new clipRect: " + this.graphics.getClip());
        }
    }

    public void setColor(Color color) {
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting color: " + color);
        }
        this.graphics.setColor(color);
    }

    public void setDebugOptions(int n) {
        if (n != 0) {
            if (n == -1) {
                if (this.debugOptions != 0) {
                    System.err.println(String.valueOf(this.toShortString()) + " Disabling debug");
                    this.debugOptions = 0;
                }
            } else if (this.debugOptions != n) {
                this.debugOptions |= n;
                if (this.debugLog()) {
                    System.err.println(String.valueOf(this.toShortString()) + " Enabling debug");
                }
            }
        }
    }

    static void setDebugOptions(JComponent jComponent, int n) {
        DebugGraphics.info().setDebugOptions(jComponent, n);
    }

    public static void setFlashColor(Color color) {
        DebugGraphics.info().flashColor = color;
    }

    public static void setFlashCount(int n) {
        DebugGraphics.info().flashCount = n;
    }

    public static void setFlashTime(int n) {
        DebugGraphics.info().flashTime = n;
    }

    public void setFont(Font font) {
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting font: " + font);
        }
        this.graphics.setFont(font);
    }

    public static void setLogStream(PrintStream printStream) {
        DebugGraphics.info().stream = printStream;
    }

    public void setPaintMode() {
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting paint mode");
        }
        this.graphics.setPaintMode();
    }

    public void setXORMode(Color color) {
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Setting XOR mode: " + color);
        }
        this.graphics.setXORMode(color);
    }

    static int shouldComponentDebug(JComponent jComponent) {
        DebugGraphicsInfo debugGraphicsInfo = DebugGraphics.info();
        if (debugGraphicsInfo == null) {
            return 0;
        }
        Container container = jComponent;
        int n = 0;
        while (container != null && container instanceof JComponent) {
            n |= debugGraphicsInfo.getDebugOptions((JComponent)container);
            container = container.getParent();
        }
        return n;
    }

    final void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {}
    }

    String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("Graphics" + (this.isDrawingBuffer() ? "<B>" : "") + "(" + this.graphicsID + "-" + this.debugOptions + ")");
        return stringBuffer.toString();
    }

    public void translate(int n, int n2) {
        if (this.debugLog()) {
            DebugGraphics.info().log(String.valueOf(this.toShortString()) + " Translating by: " + new Point(n, n2));
        }
        this.xOffset += n;
        this.yOffset += n2;
        this.graphics.translate(n, n2);
    }
}

