/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.peer.ListPeer;
import sun.awt.SunToolkit;
import sun.awt.windows.WComponentPeer;

class WListPeer
extends WComponentPeer
implements ListPeer {
    private FontMetrics fm;

    WListPeer(List list) {
        super(list);
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public void addItem(String string, int n) {
        this.addItem0(string, n, this.fm.stringWidth(string));
    }

    native void addItem0(String var1, int var2, int var3);

    public void clear() {
        List list = (List)this.target;
        this.delItems(0, list.countItems());
    }

    void clearRectBeforePaint(Graphics graphics, Rectangle rectangle) {
    }

    native void create(WComponentPeer var1);

    public native void delItems(int var1, int var2);

    public native void deselect(int var1);

    public native int getMaxWidth();

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public int[] getSelectedIndexes() {
        List list = (List)this.target;
        int n = list.countItems();
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.isSelected(n3)) {
                nArray[n2++] = n3;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    void handleAction(final int n) {
        final List list = (List)this.target;
        SunToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                list.select(n);
                this.postEvent(new ActionEvent(target, 1001, list.getItem(n)));
            }
        });
    }

    void handleListChanged(final int n) {
        final List list = (List)this.target;
        SunToolkit.executeOnEventHandlerThread(list, new Runnable(){

            public void run() {
                this.postEvent(new ItemEvent(list, 701, new Integer(n), this.isSelected(n) ? 1 : 2));
            }
        });
    }

    void initialize() {
        List list = (List)this.target;
        this.fm = this.getFontMetrics(list.getFont());
        int n = list.countItems();
        int n2 = 0;
        while (n2 < n) {
            this.addItem(list.getItem(n2), -1);
            ++n2;
        }
        this.setMultipleSelections(list.allowsMultipleSelections());
        int n3 = list.getVisibleIndex();
        if (n3 >= 0) {
            this.makeVisible(n3);
        }
        int[] nArray = list.getSelectedIndexes();
        int n4 = 0;
        while (n4 < nArray.length) {
            this.select(nArray[n4]);
            ++n4;
        }
        super.initialize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    native boolean isSelected(int var1);

    public native void makeVisible(int var1);

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension minimumSize(int n) {
        return new Dimension(20 + this.fm.stringWidth("0123456789abcde"), this.fm.getHeight() * n + 4);
    }

    public Dimension preferredSize(int n) {
        Dimension dimension = this.minimumSize(n);
        dimension.width = Math.max(dimension.width, this.getMaxWidth() + 20);
        return dimension;
    }

    public void removeAll() {
        this.clear();
    }

    public native void select(int var1);

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(((List)this.target).getFont());
        this.updateMaxItemWidth();
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public native void setMultipleSelections(boolean var1);

    private native void updateMaxItemWidth();
}

