/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;

public class MarshalOutputStream
extends ObjectOutputStream {
    public MarshalOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.useProtocolVersion(1);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MarshalOutputStream.this.privilegedEnableReplaceObject();
                return null;
            }
        });
    }

    protected void annotateClass(Class clazz) throws IOException {
        this.writeLocation(RMIClassLoader.getClassAnnotation(clazz));
    }

    private void privilegedEnableReplaceObject() {
        this.enableReplaceObject(true);
    }

    protected Object replaceObject(Object object) throws IOException {
        Target target;
        if (object instanceof Remote && !(object instanceof RemoteStub) && (target = ObjectTable.getTarget((Remote)object)) != null) {
            return target.getStub();
        }
        return object;
    }

    protected void writeLocation(String string) throws IOException {
        this.writeObject(string);
    }
}

