/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.X500Name;

final class AVA
implements DerEncoder {
    ObjectIdentifier oid;
    DerValue value;
    private static final String specialChars = ",+=\n<>#;";
    private static final String digits = "0123456789ABCDEF";

    AVA(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) == -1) {
                throw new IOException("Incorrect AVA format");
            }
            if ((char)n2 == '=') break;
            stringBuffer.append((char)n2);
        }
        String string = stringBuffer.toString().toUpperCase().trim();
        if (string.equals("CN")) {
            this.oid = X500Name.commonName_oid;
        } else if (string.equals("C")) {
            this.oid = X500Name.countryName_oid;
        } else if (string.equals("L")) {
            this.oid = X500Name.localityName_oid;
        } else if (string.equals("S") || string.equals("ST")) {
            this.oid = X500Name.stateName_oid;
        } else if (string.equals("O")) {
            this.oid = X500Name.orgName_oid;
        } else if (string.equals("OU")) {
            this.oid = X500Name.orgUnitName_oid;
        } else if (string.equals("T")) {
            this.oid = X500Name.title_oid;
        } else if (string.equals("IP")) {
            this.oid = X500Name.ipAddress_oid;
        } else if (string.equals("STREET")) {
            this.oid = X500Name.streetAddress_oid;
        } else {
            throw new IOException("unsupported keyword " + string);
        }
        stringBuffer = new StringBuffer();
        char c = (char)inputStream.read();
        while (c == ' ' || c == '\n') {
            c = (char)inputStream.read();
        }
        if (c == '\uffffffff') {
            throw new IOException("Incorrect AVA format");
        }
        if (c == '#') {
            throw new IOException("AVA parse, hex values NYI");
        }
        if (c == '\"') {
            throw new IOException("AVA parse, quoted strings NYI");
        }
        do {
            if (c == '\\') {
                c = (char)inputStream.read();
            }
            stringBuffer.append(c);
            n = inputStream.read();
            c = (char)n;
        } while (n != -1 && c != '+' && c != ',' && c != ';' && c != '>');
        this.value = new DerValue(stringBuffer.toString().trim());
    }

    AVA(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        if (derValue.tag != 48) {
            throw new IOException("X500 AVA, not a sequence");
        }
        this.oid = X500Name.intern(derValue.data.getOID());
        this.value = derValue.data.getDerValue();
        if (derValue.data.available() != 0) {
            throw new IOException("AVA, extra bytes = " + derValue.data.available());
        }
    }

    AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.oid = objectIdentifier;
        this.value = derValue;
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.oid);
        this.value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public boolean equals(Object object) {
        if (object instanceof AVA) {
            return this.equals((AVA)object);
        }
        return false;
    }

    boolean equals(AVA aVA) {
        return this.oid.equals(aVA.oid) && this.value.equals(aVA.value);
    }

    public String toString() {
        String string = this.oid.equals(X500Name.commonName_oid) ? "CN" : (this.oid.equals(X500Name.countryName_oid) ? "C" : (this.oid.equals(X500Name.localityName_oid) ? "L" : (this.oid.equals(X500Name.stateName_oid) ? "ST" : (this.oid.equals(X500Name.orgName_oid) ? "O" : (this.oid.equals(X500Name.orgUnitName_oid) ? "OU" : (this.oid.equals(X500Name.title_oid) ? "T" : (this.oid.equals(X500Name.ipAddress_oid) ? "IP" : (this.oid.equals(X500Name.streetAddress_oid) ? "STREET" : (this.oid.equals(PKCS9Attribute.EMAIL_ADDRESS_OID) ? "EmailAddress" : "OID." + this.oid.toString())))))))));
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(string);
        stringBuffer.append("=");
        try {
            String string2 = this.value.getAsString();
            if (string2 == null) {
                byte[] byArray = this.value.toByteArray();
                stringBuffer.append('#');
                int n = 0;
                while (n < byArray.length) {
                    stringBuffer.append(digits.charAt(byArray[n] >> 4 & 0xF));
                    stringBuffer.append(digits.charAt(byArray[n] & 0xF));
                    ++n;
                }
            } else {
                char c;
                boolean bl = false;
                int n = string2.length();
                int n2 = 0;
                while (n2 < specialChars.length()) {
                    if (string2.indexOf(specialChars.charAt(n2)) != -1) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!(n <= 0 || bl || string2.charAt(0) != ' ' && string2.charAt(0) != '\n' && string2.charAt(n - 1) != ' ' && string2.charAt(n - 1) != '\n')) {
                    bl = true;
                }
                if (n > 0 && !bl) {
                    c = '\u0000';
                    n2 = 1;
                    while (n2 < n - 2) {
                        if (string2.charAt(n2) == ' ' || string2.charAt(n2) == '\n') {
                            if (c != '\u0000') {
                                bl = true;
                                break;
                            }
                            c = '\u0001';
                        } else {
                            c = '\u0000';
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    stringBuffer.append('\"');
                }
                n2 = 0;
                while (n2 < n) {
                    c = string2.charAt(n2);
                    if (c == '\"' || c == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    ++n2;
                }
                if (bl) {
                    stringBuffer.append('\"');
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("DER Value conversion");
        }
        return stringBuffer.toString();
    }
}

