/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.X500Name;

public class CertificateSubjectName
implements CertAttrSet {
    public static final String IDENT = "x509.info.subject";
    public static final String NAME = "subject";
    public static final String DN_NAME = "dname";
    private X500Name dnName;

    public CertificateSubjectName(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.dnName = new X500Name(derValue);
    }

    public CertificateSubjectName(DerInputStream derInputStream) throws IOException {
        this.dnName = new X500Name(derInputStream);
    }

    public CertificateSubjectName(X500Name x500Name) {
        this.dnName = x500Name;
    }

    public void decode(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.dnName = new X500Name(derValue);
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = null;
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.dnName.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(DN_NAME)) {
            return this.dnName;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(DN_NAME);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof X500Name)) {
            throw new IOException("Attribute must be of type X500Name.");
        }
        if (!string.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = (X500Name)object;
    }

    public String toString() {
        if (this.dnName == null) {
            return "";
        }
        return this.dnName.toString();
    }
}

