/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralNamesException;
import sun.security.x509.PKIXExtensions;

public class IssuerAlternativeNameExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.IssuerAlternativeName";
    public static final String NAME = "IssuerAlternativeName";
    public static final String ISSUER_NAME = "issuer_name";
    GeneralNames names = null;

    public IssuerAlternativeNameExtension() {
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = false;
        this.names = new GeneralNames();
    }

    public IssuerAlternativeNameExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = Array.getByte(object, n2);
            ++n2;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        try {
            this.names = new GeneralNames(derValue);
        }
        catch (GeneralNamesException generalNamesException) {
            throw new IOException("IssuerAlternativeNameExtension" + generalNamesException.toString());
        }
    }

    public IssuerAlternativeNameExtension(GeneralNames generalNames) throws IOException {
        this.names = generalNames;
        this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
        this.critical = false;
        this.encodeThis();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(ISSUER_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        this.names = null;
        this.encodeThis();
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.IssuerAlternativeName_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    private void encodeThis() throws IOException {
        if (this.names == null || this.names.isEmpty()) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            this.names.encode(derOutputStream);
        }
        catch (GeneralNamesException generalNamesException) {
            throw new IOException(generalNamesException.toString());
        }
        this.extensionValue = derOutputStream.toByteArray();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(ISSUER_NAME)) {
            return this.names;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ISSUER_NAME);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(ISSUER_NAME)) {
            if (!(object instanceof GeneralNames)) {
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:IssuerAlternativeName.");
        }
        this.names = (GeneralNames)object;
        this.encodeThis();
    }

    public String toString() {
        if (this.names == null) {
            return "";
        }
        String string = String.valueOf(super.toString()) + "IssuerAlternativeName [\n" + this.names.toString() + "]\n";
        return string;
    }
}

