/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class MotifPopupMenuUI
extends BasicPopupMenuUI {
    private static Border border = null;
    private Font titleFont = null;

    protected ChangeListener createChangeListener(JPopupMenu jPopupMenu) {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        };
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifPopupMenuUI();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Serializable serializable;
        LayoutManager layoutManager = jComponent.getLayout();
        Dimension dimension = layoutManager.preferredLayoutSize(jComponent);
        String string = ((JPopupMenu)jComponent).getLabel();
        if (this.titleFont == null) {
            serializable = UIManager.getLookAndFeelDefaults();
            this.titleFont = ((UIDefaults)serializable).getFont("PopupMenu.font");
        }
        serializable = jComponent.getFontMetrics(this.titleFont);
        int n = 0;
        if (string != null) {
            n += ((FontMetrics)serializable).stringWidth(string);
        }
        if (dimension.width < n) {
            dimension.width = n + 8;
            Insets insets = jComponent.getInsets();
            if (insets != null) {
                dimension.width += insets.left + insets.right;
            }
            if (border != null) {
                insets = border.getBorderInsets(jComponent);
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }
        return null;
    }

    public void installDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        if (border == null) {
            border = new CompoundUIResourceBorder(new MotifBorders.BevelBorder(true, uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlLtHighlight")), new MotifPopupMenuBorder(uIDefaults.getFont("PopupMenu.font"), uIDefaults.getColor("PopupMenu.background"), uIDefaults.getColor("PopupMenu.foreground"), uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlLtHighlight")));
        }
        uIDefaults.put("PopupMenu.border", border);
        super.installDefaults();
    }

    private static class CompoundUIResourceBorder
    extends CompoundBorder
    implements UIResource {
        public CompoundUIResourceBorder(Border border, Border border2) {
            super(border, border2);
        }
    }

    private static class MotifPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected Font font;
        protected Color background;
        protected Color foreground;
        protected Color shadowColor;
        protected Color highlightColor;
        protected static final int TEXT_SPACING = 2;
        protected static final int GROOVE_HEIGHT = 2;

        public MotifPopupMenuBorder(Font font, Color color, Color color2, Color color3, Color color4) {
            this.font = font;
            this.background = color;
            this.foreground = color2;
            this.shadowColor = color3;
            this.highlightColor = color4;
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            int n = 0;
            int n2 = 16;
            String string = ((JPopupMenu)component).getLabel();
            if (string == null) {
                insets.bottom = 0;
                insets.right = 0;
                insets.top = 0;
                insets.left = 0;
                return insets;
            }
            FontMetrics fontMetrics = component.getFontMetrics(this.font);
            if (fontMetrics != null) {
                n = fontMetrics.getDescent();
                n2 = fontMetrics.getAscent();
            }
            insets.top += n2 + n + 2 + 2;
            return insets;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Font font = graphics.getFont();
            Color color = graphics.getColor();
            String string = ((JPopupMenu)component).getLabel();
            if (string == null) {
                return;
            }
            graphics.setFont(this.font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.getHeight();
            int n6 = fontMetrics.getDescent();
            int n7 = fontMetrics.getAscent();
            Point point = new Point();
            int n8 = fontMetrics.stringWidth(string);
            point.y = n2 + n7 + 2;
            point.x = n + (n3 - n8) / 2;
            graphics.setColor(this.background);
            graphics.fillRect(point.x - 2, point.y - (n5 - n6), n8 + 4, n5 - n6);
            graphics.setColor(this.foreground);
            graphics.drawString(string, point.x, point.y);
            MotifGraphicsUtils.drawGroove(graphics, n, point.y + 2, n3, 2, this.shadowColor, this.highlightColor);
            graphics.setFont(font);
            graphics.setColor(color);
        }
    }
}

