/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import sun.security.action.LoadLibraryAction;

class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private int timeout = 0;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        PlainDatagramSocketImpl.init();
    }

    PlainDatagramSocketImpl() {
    }

    protected synchronized native void bind(int var1, InetAddress var2) throws SocketException;

    protected void close() {
        if (this.fd != null) {
            this.datagramSocketClose();
            this.fd = null;
        }
    }

    protected synchronized void create() throws SocketException {
        this.fd = new FileDescriptor();
        this.datagramSocketCreate();
    }

    private native void datagramSocketClose();

    private native void datagramSocketCreate() throws SocketException;

    protected void finalize() {
        this.close();
    }

    public Object getOption(int n) throws SocketException {
        Integer n2 = null;
        if (n == 4102) {
            n2 = new Integer(this.timeout);
        } else {
            int n3 = this.socketGetOption(n);
            if (n == 15 || n == 16) {
                InetAddress inetAddress = new InetAddress();
                inetAddress.address = n3;
                return inetAddress;
            }
            if (n == 4098 || n == 4097) {
                n2 = new Integer(n3);
            }
        }
        return n2;
    }

    protected native byte getTTL() throws IOException;

    protected native int getTimeToLive() throws IOException;

    private static native void init();

    protected native void join(InetAddress var1) throws IOException;

    protected native void leave(InetAddress var1) throws IOException;

    protected synchronized native int peek(InetAddress var1) throws IOException;

    protected synchronized native void receive(DatagramPacket var1) throws IOException;

    protected native void send(DatagramPacket var1) throws IOException;

    public void setOption(int n, Object object) throws SocketException {
        switch (n) {
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for SO_TIMEOUT");
                }
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n2;
                return;
            }
            case 15: {
                throw new SocketException("Cannot re-bind Socket");
            }
            case 4: {
                if (object != null && object instanceof Integer) break;
                throw new SocketException("bad argument for SO_REUSEADDR");
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object >= 0) break;
                throw new SocketException("bad argument for SO_SNDBUF or SO_RCVBUF");
            }
            case 16: {
                if (object != null && object instanceof InetAddress) break;
                throw new SocketException("bad argument for IP_MULTICAST_IF");
            }
            default: {
                throw new SocketException("invalid option: " + n);
            }
        }
        this.socketSetOption(n, object);
    }

    protected native void setTTL(byte var1) throws IOException;

    protected native void setTimeToLive(int var1) throws IOException;

    private native int socketGetOption(int var1) throws SocketException;

    private native void socketSetOption(int var1, Object var2) throws SocketException;
}

