/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayList
extends AbstractList
implements List,
Cloneable,
Serializable {
    private transient Object[] elementData;
    private int size;

    public ArrayList() {
        this(10);
    }

    public ArrayList(int n) {
        this.elementData = new Object[n];
    }

    public ArrayList(Collection collection) {
        this.size = collection.size();
        this.elementData = new Object[this.size * 110 / 100];
        collection.toArray(this.elementData);
    }

    private void RangeCheck(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    public void add(int n, Object object) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = object;
        ++this.size;
    }

    public boolean add(Object object) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = object;
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        int n2 = collection.size();
        this.ensureCapacity(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        Iterator iterator = collection.iterator();
        int n4 = 0;
        while (n4 < n2) {
            this.elementData[n++] = iterator.next();
            ++n4;
        }
        this.size += n2;
        return n2 != 0;
    }

    public boolean addAll(Collection collection) {
        ++this.modCount;
        int n = collection.size();
        this.ensureCapacity(this.size + n);
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (n2 < n) {
            this.elementData[this.size++] = iterator.next();
            ++n2;
        }
        return n != 0;
    }

    public void clear() {
        ++this.modCount;
        int n = 0;
        while (n < this.size) {
            this.elementData[n] = null;
            ++n;
        }
        this.size = 0;
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.elementData = new Object[this.size];
            System.arraycopy(this.elementData, 0, arrayList.elementData, 0, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            Object[] objectArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new Object[n3];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    public Object get(int n) {
        this.RangeCheck(n);
        return this.elementData[n];
    }

    public int indexOf(Object object) {
        if (object == null) {
            int n = 0;
            while (n < this.size) {
                if (this.elementData[n] == null) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.size) {
                if (object.equals(this.elementData[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            int n = this.size - 1;
            while (n >= 0) {
                if (this.elementData[n] == null) {
                    return n;
                }
                --n;
            }
        } else {
            int n = this.size - 1;
            while (n >= 0) {
                if (object.equals(this.elementData[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = new Object[n];
        int n2 = 0;
        while (n2 < this.size) {
            this.elementData[n2] = objectInputStream.readObject();
            ++n2;
        }
    }

    public Object remove(int n) {
        this.RangeCheck(n);
        ++this.modCount;
        Object object = this.elementData[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return object;
    }

    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = null;
        }
    }

    public Object set(int n, Object object) {
        this.RangeCheck(n);
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.size < n) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        int n = 0;
        while (n < this.size) {
            objectOutputStream.writeObject(this.elementData[n]);
            ++n;
        }
    }
}

