/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = null;
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public boolean contains(Object object) {
        if (this.fileCache != null) {
            return this.fileCache.contains(object);
        }
        return false;
    }

    public void fireContentsChanged() {
        this.files = null;
        this.directories = null;
        this.fireContentsChanged(this, 0, this.fileCache.size() - 1);
    }

    public Vector getDirectories() {
        if (this.directories != null) {
            return this.directories;
        }
        Vector vector = this.getFiles();
        return this.directories;
    }

    public Object getElementAt(int n) {
        if (this.fileCache != null) {
            return this.fileCache.elementAt(n);
        }
        return null;
    }

    public Vector getFiles() {
        if (this.files != null) {
            return this.files;
        }
        this.files = new Vector();
        this.directories = new Vector();
        this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
        int n = 0;
        while (n < this.fileCache.size()) {
            File file = (File)this.fileCache.elementAt(n);
            if (this.filechooser.isTraversable(file)) {
                this.directories.addElement(file);
            } else {
                this.files.addElement(file);
            }
            ++n;
        }
        return this.files;
    }

    public int getSize() {
        if (this.fileCache != null) {
            return this.fileCache.size();
        }
        return 0;
    }

    public int indexOf(Object object) {
        if (this.fileCache != null) {
            return this.fileCache.indexOf(object);
        }
        return 0;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void invalidateFileCache() {
        this.files = null;
        this.directories = null;
        this.fileCache = null;
    }

    protected boolean lt(File file, File file2) {
        return file.getName().compareTo(file2.getName()) < 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.invalidateFileCache();
            this.validateFileCache();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void quickSort(Vector var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = (File)var1_1.elementAt((var2_2 + var3_3) / 2);
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && this.lt((File)var1_1.elementAt(var4_4), var6_6)) continue block0;
                    while (var5_5 > var2_2 && this.lt(var6_6, (File)var1_1.elementAt(var5_5))) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    this.swap(var1_1, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    protected void sort(Vector vector) {
        this.quickSort(vector, 0, vector.size() - 1);
    }

    private void swap(Vector vector, int n, int n2) {
        Object object = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(object, n2);
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            this.invalidateFileCache();
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.invalidateFileCache();
        this.fileCache = new Vector(50);
        this.loadThread = new LoadFilesThread(file, this.fetchID);
        this.loadThread.start();
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory = null;
        int fid;

        public LoadFilesThread(File file, int n) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = file;
            this.fid = n;
        }

        public void cancelRunnables(Vector vector) {
            int n = 0;
            while (n < vector.size()) {
                ((DoChangeContents)vector.elementAt(n)).cancel();
                ++n;
            }
        }

        public void run() {
            Object object;
            Vector vector = new Vector(10);
            FileSystemView fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            File[] fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            Vector vector2 = new Vector();
            int n = 0;
            while (n < fileArray.length) {
                if (BasicDirectoryModel.this.filechooser.accept(fileArray[n])) {
                    vector2.addElement(fileArray[n]);
                }
                ++n;
            }
            BasicDirectoryModel.this.sort(vector2);
            Vector vector3 = new Vector(10);
            Vector vector4 = new Vector();
            int n2 = 0;
            while (n2 < vector2.size()) {
                object = (File)vector2.elementAt(n2);
                boolean bl = BasicDirectoryModel.this.filechooser.isTraversable((File)object);
                if (bl) {
                    vector3.addElement(object);
                } else if (!bl && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector4.addElement(object);
                }
                if (vector3.size() == 10 || n2 == vector2.size() - 1) {
                    DoChangeContents doChangeContents = new DoChangeContents(vector3, this.fid);
                    vector.addElement(doChangeContents);
                    SwingUtilities.invokeLater(doChangeContents);
                    vector3 = new Vector(10);
                }
                if (this.isInterrupted()) {
                    this.cancelRunnables(vector);
                    return;
                }
                ++n2;
            }
            object = new DoChangeContents(vector4, this.fid);
            vector.addElement(object);
            SwingUtilities.invokeLater((Runnable)object);
            if (this.isInterrupted()) {
                this.cancelRunnables(vector);
                return;
            }
        }
    }

    class DoChangeContents
    implements Runnable {
        private Vector files;
        private boolean doFire = true;
        private Object lock = new Object();
        private int fid;

        public DoChangeContents(Vector vector, int n) {
            this.files = vector;
            this.fid = n;
        }

        synchronized void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.doFire = false;
            }
        }

        public void run() {
            if (BasicDirectoryModel.this.fetchID == this.fid) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.doFire) {
                        int n = 0;
                        while (n < this.files.size()) {
                            BasicDirectoryModel.this.fileCache.addElement(this.files.elementAt(n));
                            ++n;
                        }
                    }
                    BasicDirectoryModel.this.fireContentsChanged();
                }
            }
        }
    }
}

