/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.color;

import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.color.CMM;
import sun.awt.color.CMMImageLayout;
import sun.awt.color.ProfileDeferralMgr;
import sun.awt.color.pelArrayInfo;

public class ICC_Transform {
    long ID;
    public static final int Any = -1;
    public static final int In = 1;
    public static final int Out = 2;
    public static final int Gamut = 3;
    public static final int Simulation = 4;

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }

    public ICC_Transform() {
    }

    public ICC_Transform(ICC_Profile iCC_Profile, int n, int n2) {
        if (iCC_Profile == null) {
            CMM.checkStatus(503);
        }
        CMM.checkStatus(CMM.cmmGetTransform(iCC_Profile, n, n2, this));
    }

    public ICC_Transform(ICC_Transform[] iCC_TransformArray) {
        int n = iCC_TransformArray.length;
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = iCC_TransformArray[n2].ID;
            ++n2;
        }
        int n3 = CMM.cmmCombineTransforms(lArray, this);
        if (n3 != 0 || this.ID == 0L) {
            throw new ProfileDataException("Invalid profile sequence");
        }
    }

    public float[] colorConvert(int n, float[] fArray, float[] fArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, n, fArray, fArray2);
        float[] fArray3 = fArray2 != null ? fArray2 : new float[pelArrayInfo2.destSize];
        short[] sArray = new short[pelArrayInfo2.srcSize];
        int n2 = 0;
        while (n2 < pelArrayInfo2.srcSize) {
            sArray[n2] = (short)((int)(fArray[n2] * 65535.0f) & 0xFFFF);
            ++n2;
        }
        short[] sArray2 = this.colorConvert(sArray, null);
        n2 = 0;
        while (n2 < pelArrayInfo2.destSize) {
            fArray3[n2] = (float)(sArray2[n2] & 0xFFFF) / 65535.0f;
            ++n2;
        }
        return fArray3;
    }

    public void colorConvert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 5: {
                bl6 = false;
                bl5 = false;
                bl4 = true;
                break;
            }
            case 6: {
                bl6 = true;
                bl5 = false;
                bl4 = true;
                break;
            }
            case 3: 
            case 7: {
                bl6 = true;
                bl5 = true;
                bl4 = true;
                break;
            }
            default: {
                bl6 = false;
                bl5 = false;
                bl4 = false;
            }
        }
        switch (bufferedImage2.getType()) {
            case 1: 
            case 2: 
            case 5: {
                bl3 = false;
                bl2 = false;
                bl = true;
                break;
            }
            case 6: {
                bl3 = true;
                bl2 = false;
                bl = true;
                break;
            }
            case 3: 
            case 7: {
                bl3 = true;
                bl2 = true;
                bl = true;
                break;
            }
            default: {
                bl3 = false;
                bl2 = false;
                bl = false;
            }
        }
        if (bl4 && bl) {
            ColorModel colorModel = null;
            ColorModel colorModel2 = null;
            if (bl6 && bl5) {
                colorModel = bufferedImage.getColorModel().coerceData(bufferedImage.getRaster(), false);
            }
            if (bl6 && bl2 && bufferedImage != bufferedImage2) {
                colorModel2 = bufferedImage2.getColorModel().coerceData(bufferedImage2.getRaster(), false);
            }
            CMMImageLayout cMMImageLayout = new CMMImageLayout(bufferedImage);
            CMMImageLayout cMMImageLayout2 = new CMMImageLayout(bufferedImage2);
            int n = CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2);
            if (bl6 && bl5) {
                colorModel.coerceData(bufferedImage.getRaster(), true);
            }
            CMM.checkStatus(n);
            if (bl3) {
                this.fixDestAlpha(bufferedImage, bufferedImage2, bl6, bl2, colorModel2);
            }
        } else {
            Object object;
            WritableRaster writableRaster = bufferedImage.getRaster();
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            ColorModel colorModel = bufferedImage.getColorModel();
            ColorModel colorModel3 = bufferedImage2.getColorModel();
            int n = writableRaster.getNumBands();
            int n2 = writableRaster2.getNumBands();
            ColorModel colorModel4 = null;
            ColorModel colorModel5 = null;
            bl6 = colorModel.hasAlpha();
            bl5 = colorModel.isAlphaPremultiplied();
            bl3 = colorModel3.hasAlpha();
            bl2 = colorModel3.isAlphaPremultiplied();
            if (bl6) {
                --n;
            }
            if (bl3) {
                --n2;
            }
            if (n != colorModel.getNumColorComponents() || n2 != colorModel3.getNumColorComponents()) {
                throw new IllegalArgumentException("Source or Destination ColorModel not supported");
            }
            Raster raster = writableRaster;
            if (bl6) {
                object = new int[n];
                int n3 = 0;
                while (n3 < n) {
                    object[n3] = n3;
                    ++n3;
                }
                raster = writableRaster.createChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), (int[])object);
            }
            object = writableRaster2;
            if (bl3) {
                int[] nArray = new int[n2];
                int n4 = 0;
                while (n4 < n2) {
                    nArray[n4] = n4;
                    ++n4;
                }
                object = writableRaster2.createWritableChild(writableRaster2.getMinX(), writableRaster2.getMinY(), writableRaster2.getWidth(), writableRaster2.getHeight(), writableRaster2.getMinX(), writableRaster2.getMinY(), nArray);
            }
            if (bl6 && bl5) {
                colorModel4 = bufferedImage.getColorModel().coerceData(bufferedImage.getRaster(), false);
            }
            if (bl6 && bl2 && bufferedImage != bufferedImage2) {
                colorModel5 = bufferedImage2.getColorModel().coerceData(bufferedImage2.getRaster(), false);
            }
            this.colorConvert(raster, colorModel, (WritableRaster)object, colorModel3);
            if (bl6 && bl5) {
                colorModel4.coerceData(bufferedImage.getRaster(), true);
            }
            if (bl3) {
                this.fixDestAlpha(bufferedImage, bufferedImage2, bl6, bl2, colorModel5);
            }
        }
    }

    private void colorConvert(Raster raster, ColorModel colorModel, WritableRaster writableRaster, ColorModel colorModel2) {
        int n = raster.getNumBands();
        int n2 = writableRaster.getNumBands();
        int n3 = raster.getHeight();
        int n4 = raster.getWidth();
        byte[] byArray = new byte[n4 * n];
        byte[] byArray2 = new byte[n4 * n2];
        int n5 = raster.getMinY();
        int n6 = writableRaster.getMinY();
        int[] nArray = colorModel != null ? colorModel.getComponentSize() : raster.getSampleModel().getSampleSize();
        int[] nArray2 = colorModel2 != null ? colorModel2.getComponentSize() : writableRaster.getSampleModel().getSampleSize();
        int n7 = 0;
        while (n7 < n) {
            int n8 = n7++;
            nArray[n8] = nArray[n8] - 8;
        }
        n7 = 0;
        while (n7 < n2) {
            int n9 = n7++;
            nArray2[n9] = nArray2[n9] - 8;
        }
        n7 = 0;
        while (n7 < n3) {
            int n10;
            int n11;
            int n12;
            int n13 = raster.getMinX();
            int n14 = 0;
            int n15 = 0;
            while (n15 < n4) {
                n12 = 0;
                while (n12 < n) {
                    n11 = raster.getSample(n13, n5, n12);
                    n10 = nArray[n12];
                    if (n10 > 0) {
                        n11 >>>= n10;
                    } else if (n10 < 0) {
                        n11 <<= -n10;
                    }
                    byArray[n14] = (byte)n11;
                    ++n12;
                    ++n14;
                }
                ++n15;
                ++n13;
            }
            this.colorConvert(byArray, byArray2);
            int n16 = writableRaster.getMinX();
            n14 = 0;
            n15 = 0;
            while (n15 < n4) {
                n12 = 0;
                while (n12 < n2) {
                    n11 = byArray2[n14] & 0xFF;
                    n10 = nArray2[n12];
                    if (n10 > 0) {
                        n11 <<= n10;
                    } else if (n10 < 0) {
                        n11 >>>= -n10;
                    }
                    writableRaster.setSample(n16, n6, n12, n11);
                    ++n12;
                    ++n14;
                }
                ++n15;
                ++n16;
            }
            ++n7;
            ++n5;
            ++n6;
        }
    }

    public void colorConvert(Raster raster, WritableRaster writableRaster) {
        this.colorConvert(raster, null, writableRaster, null);
    }

    public byte[] colorConvert(byte[] byArray, byte[] byArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
        byte[] byArray3 = byArray2 != null ? byArray2 : new byte[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(pelArrayInfo2.nPels, pelArrayInfo2.nSrc, 1);
        cMMImageLayout.chanData[0] = byArray;
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(pelArrayInfo2.nPels, pelArrayInfo2.nDest, 1);
        cMMImageLayout2.chanData[0] = byArray3;
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return byArray3;
    }

    public short[] colorConvert(short[] sArray, short[] sArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        short[] sArray3 = sArray2 != null ? sArray2 : new short[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(pelArrayInfo2.nPels, pelArrayInfo2.nSrc, 2);
        cMMImageLayout.chanData[0] = sArray;
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(pelArrayInfo2.nPels, pelArrayInfo2.nDest, 2);
        cMMImageLayout2.chanData[0] = sArray3;
        CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        return sArray3;
    }

    protected void finalize() {
        CMM.checkStatus(CMM.cmmFreeTransform(this.ID));
    }

    private void fixDestAlpha(BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl, boolean bl2, ColorModel colorModel) {
        if (bl && bufferedImage != bufferedImage2) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            WritableRaster writableRaster2 = bufferedImage2.getRaster();
            int n = writableRaster.getNumBands() - 1;
            int n2 = writableRaster2.getNumBands() - 1;
            int n3 = writableRaster2.getMinX();
            int n4 = writableRaster2.getMinY();
            int n5 = writableRaster.getMinX();
            int n6 = writableRaster.getMinY();
            int n7 = n5 + writableRaster.getWidth();
            int n8 = n6 + writableRaster.getHeight();
            int n9 = bufferedImage.getColorModel().getComponentSize(n);
            int n10 = bufferedImage2.getColorModel().getComponentSize(n2);
            int n11 = n10 - n9;
            int n12 = -n11;
            int n13 = n6;
            while (n13 < n8) {
                int n14;
                int n15;
                if (n11 > 0) {
                    n15 = n5;
                    while (n15 < n7) {
                        n14 = writableRaster.getSample(n15, n13, n);
                        writableRaster2.setSample(n3, n4, n2, n14 <<= n11);
                        ++n15;
                        ++n3;
                    }
                } else if (n11 == 0) {
                    n15 = n5;
                    while (n15 < n7) {
                        n14 = writableRaster.getSample(n15, n13, n);
                        writableRaster2.setSample(n3, n4, n2, n14);
                        ++n15;
                        ++n3;
                    }
                } else {
                    n15 = n5;
                    while (n15 < n7) {
                        n14 = writableRaster.getSample(n15, n13, n);
                        writableRaster2.setSample(n3, n4, n2, n14 >>>= n12);
                        ++n15;
                        ++n3;
                    }
                }
                ++n13;
                ++n4;
            }
            if (bl2) {
                colorModel.coerceData(writableRaster2, true);
            }
        } else if (!bl) {
            WritableRaster writableRaster = bufferedImage2.getRaster();
            int n = writableRaster.getNumBands() - 1;
            int n16 = writableRaster.getMinX();
            int n17 = writableRaster.getMinY();
            int n18 = n16 + writableRaster.getWidth();
            int n19 = n17 + writableRaster.getHeight();
            int n20 = (1 << bufferedImage2.getColorModel().getComponentSize(n)) - 1;
            int n21 = n17;
            while (n21 < n19) {
                int n22 = n16;
                while (n22 < n18) {
                    writableRaster.setSample(n22, n21, n, n20);
                    ++n22;
                }
                ++n21;
            }
        }
    }

    long getID() {
        return this.ID;
    }

    public int getNumInComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[0];
    }

    public int getNumOutComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[1];
    }
}

