/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.rmi.MarshalledObject;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import sun.awt.windows.WDropTargetContextPeerFileStream;
import sun.awt.windows.WDropTargetContextPeerIStream;

final class WDropTargetContextPeer
implements DropTargetContextPeer,
Transferable,
Runnable {
    private static final int DISPATCH_NONE = 0;
    private static final int DISPATCH_ENTER = 1;
    private static final int DISPATCH_MOTION = 2;
    private static final int DISPATCH_CHANGED = 3;
    private static final int DISPATCH_EXIT = 4;
    private static final int DISPATCH_DROP = 5;
    private static final Object _globalLock = new Object();
    private static Transferable currentJVMLocalSourceTransferable = null;
    private static AccessControlContext currentJVMLocalSourceACtxt = null;
    static final int STATUS_NONE = 0;
    static final int STATUS_WAIT = 1;
    static final int STATUS_ACCEPT = 2;
    static final int STATUS_REJECT = -1;
    private static WDropTargetContextPeer dropTargetContextPeer;
    private Component currentC;
    private DropTarget currentDT;
    private DropTargetContext currentDTC;
    private String[] currentT;
    private int currentA;
    private int currentDA;
    private int nativeDragContext;
    private Transferable local;
    private int messagePending = 0;
    private Component currentNC;
    private int currentX;
    private int currentY;
    private int currentSA;
    int dropStatus = 0;
    boolean dropComplete = false;
    Object lock = new Object();
    Object syncLock = new Object();
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$lang$String;

    WDropTargetContextPeer() {
    }

    static native void Initialize();

    public void acceptDrag(int n) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new IllegalArgumentException("no drag pending");
            }
            this.currentA = this.mapOperation(this.currentDT, n);
        }
    }

    public void acceptDrop(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("invalid acceptDrop() action");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 1) {
                throw new InvalidDnDOperationException("invalid acceptDrop()");
            }
            this.currentDA = this.currentA = this.mapOperation(this.currentDT, n & this.currentSA);
            this.dropStatus = 2;
            this.dropComplete = false;
            this.dropDispatched();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized boolean doesPlatformImplementAutoscrolling() {
        return false;
    }

    public void dropComplete(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus == 0) {
                throw new InvalidDnDOperationException("No Drop pending");
            }
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
            }
            this.currentC = null;
            this.currentDT = null;
            this.currentDTC = null;
            this.currentT = null;
            this.currentA = 0;
            Object object2 = _globalLock;
            synchronized (object2) {
                currentJVMLocalSourceTransferable = null;
            }
            this.dropStatus = 0;
            this.dropComplete = true;
        }
        this.dropDispatched();
        this.dropDone(this.nativeDragContext, bl ? this.currentDA : 0);
        this.currentDA = 0;
        this.nativeDragContext = 0;
    }

    private void dropDispatched() {
        Object object = this.syncLock;
        synchronized (object) {
            if (this.messagePending == 5) {
                this.messagePending = 0;
                this.syncLock.notifyAll();
            }
        }
    }

    private native void dropDone(int var1, int var2);

    private native Object getData(int var1, String var2);

    int getDropStatus() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.dropStatus;
            Object var3_3 = null;
            return n;
        }
    }

    public DropTarget getDropTarget() {
        Object object = this.lock;
        synchronized (object) {
            DropTarget dropTarget = this.currentDT;
            Object var3_3 = null;
            return dropTarget;
        }
    }

    private static FileInputStream getFileStream(String string, String string2, int n) throws IOException {
        return new WDropTargetContextPeerFileStream(string, string2, n);
    }

    private static Object getIStream(int n, String string) throws IOException {
        return new WDropTargetContextPeerIStream(n, string);
    }

    static Transferable getJVMLocalSourceTransferable() {
        Transferable transferable = null;
        Object object = _globalLock;
        synchronized (object) {
            if (currentJVMLocalSourceTransferable != null && !currentJVMLocalSourceACtxt.equals(AccessController.getContext())) {
                AccessController.checkPermission(new AWTPermission("acceptDropBetweenAccessControllerContexts"));
            }
            transferable = currentJVMLocalSourceTransferable;
        }
        return transferable;
    }

    private static List getList(Object[] objectArray) {
        return Arrays.asList(objectArray);
    }

    private static ByteArrayInputStream getMemoryStream(byte[] byArray, String string) {
        return new ByteArrayInputStream(byArray);
    }

    public int getTargetActions() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.currentA;
            Object var3_3 = null;
            return n;
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException, InvalidDnDOperationException {
        int n;
        Object object;
        if (this.local != null) {
            return this.local.getTransferData(dataFlavor);
        }
        String string = null;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.dropStatus != 2 || this.dropComplete) {
                throw new InvalidDnDOperationException("No drop current");
            }
            object = this.currentDT.getFlavorMap().getNativesForFlavors(new DataFlavor[]{dataFlavor});
            string = (String)object.get(dataFlavor);
            if (string == null) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            n = 0;
            while (n < this.currentT.length) {
                if (this.currentT[n].equals(string)) break;
                ++n;
            }
            if (n == this.currentT.length) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
        object2 = this.getData(this.nativeDragContext, string);
        if (object2 == null) {
            throw new IOException("no native data was transferred");
        }
        if (object2 instanceof List) {
            return object2;
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            Class clazz;
            if ((class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = WDropTargetContextPeer.class$("java.io.InputStream"))).equals(clazz = dataFlavor.getRepresentationClass())) {
                return (InputStream)object2;
            }
            object = null;
            try {
                object = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz.getConstructors();
                    }
                });
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
                throw new IOException(securityException.getMessage());
            }
            Object object3 = null;
            int n2 = 0;
            while (n2 < ((Constructor[])object).length) {
                Class[] classArray;
                if (Modifier.isPublic(object[n2].getModifiers()) && (classArray = object[n2].getParameterTypes()) != null && classArray.length == 1 && (class$java$io$InputStream != null ? class$java$io$InputStream : WDropTargetContextPeer.class$("java.io.InputStream")).equals(classArray[0])) {
                    object3 = object[n2];
                    break;
                }
                ++n2;
            }
            if (object3 == null) {
                throw new InvalidDnDOperationException("cant find <init>(Ljava/io/InputStream;)V for class: " + clazz.getName());
            }
            try {
                return ((Constructor)object3).newInstance(new Object[]{(InputStream)object2});
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        if (dataFlavor.isRepresentationClassRemote()) {
            if (this.currentDA != 0x40000000) {
                throw new InvalidDnDOperationException("only ACTION_LINK is permissable for transfer java.rmi.Remote objects");
            }
            try {
                InputStream inputStream = (InputStream)object2;
                object = ((MarshalledObject)new ObjectInputStream(inputStream).readObject()).get();
                inputStream.close();
                return object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        if (dataFlavor.isRepresentationClassSerializable()) {
            try {
                InputStream inputStream = (InputStream)object2;
                object = new ObjectInputStream(inputStream).readObject();
                inputStream.close();
                return object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        if ((class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WDropTargetContextPeer.class$("java.lang.String"))).equals(dataFlavor.getRepresentationClass())) {
            try {
                InputStream inputStream = (InputStream)object2;
                object = new ByteArrayOutputStream();
                n = 0;
                byte[] byArray = new byte[64];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                }
                return new String(((ByteArrayOutputStream)object).toByteArray());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException(exception.getMessage());
            }
        }
        throw new IOException("getTransferData() failed");
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.local != null) {
            dataFlavorArray = this.local.getTransferDataFlavors();
        } else {
            Object object = this.lock;
            synchronized (object) {
                Object[] objectArray = this.currentDT.getFlavorMap().getFlavorsForNatives(this.currentT).values().toArray();
                dataFlavorArray = new DataFlavor[objectArray.length];
                System.arraycopy(objectArray, 0, dataFlavorArray, 0, objectArray.length);
            }
        }
        return dataFlavorArray;
    }

    public synchronized Transferable getTransferable() {
        return this;
    }

    static WDropTargetContextPeer getWDropTargetContextPeer() {
        Object object = _globalLock;
        synchronized (object) {
            dropTargetContextPeer = new WDropTargetContextPeer();
        }
        return dropTargetContextPeer;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleDropMessage(Component var1_1, int var2_2, int var3_3, int var4_4, int var5_5, String[] var6_6, int var7_7) {
        var8_8 = this.syncLock;
        synchronized (var8_8) {
            while (true) {
                block9: {
                    if (this.messagePending != 0) break block9;
                    this.nativeDragContext = var7_7;
                    this.currentNC = var1_1;
                    this.currentT = var6_6;
                    this.currentX = var2_2;
                    this.currentY = var3_3;
                    this.currentSA = var5_5;
                    this.currentDA = var4_4;
                    this.messagePending = 5;
                    SwingUtilities.invokeLater(this);
                    if (true) ** GOTO lbl29
                }
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException v0) {}
            }
            do {
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException v2) {}
lbl29:
                // 3 sources

            } while (this.messagePending != 0);
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int handleEnterMessage(Component var1_1, int var2_2, int var3_3, int var4_4, int var5_5, String[] var6_6, int var7_7) {
        var9_8 = this.syncLock;
        synchronized (var9_8) {
            while (true) {
                block9: {
                    if (this.messagePending != 0) break block9;
                    this.nativeDragContext = var7_7;
                    this.currentNC = var1_1;
                    this.currentT = var6_6;
                    this.currentX = var2_2;
                    this.currentY = var3_3;
                    this.currentSA = var5_5;
                    this.currentDA = var4_4;
                    this.messagePending = 1;
                    SwingUtilities.invokeLater(this);
                    if (true) ** GOTO lbl29
                }
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException v0) {}
            }
            do {
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException v2) {}
lbl29:
                // 3 sources

            } while (this.messagePending != 0);
            return this.currentA;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleExitMessage(Component var1_1, int var2_2) {
        var3_3 = this.syncLock;
        synchronized (var3_3) {
            while (true) {
                block9: {
                    if (this.messagePending != 0) break block9;
                    this.nativeDragContext = var2_2;
                    this.messagePending = 4;
                    SwingUtilities.invokeLater(this);
                    if (true) ** GOTO lbl23
                }
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException v0) {}
            }
            do {
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException v2) {}
lbl23:
                // 3 sources

            } while (this.messagePending != 0);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized int handleMotionMessage(Component component, int n, int n2, int n3, int n4, String[] stringArray, int n5) {
        Object object = this.syncLock;
        synchronized (object) {
            int n6;
            while (true) {
                if (this.messagePending == 0) {
                    this.nativeDragContext = n5;
                    this.currentNC = component;
                    this.currentT = stringArray;
                    this.currentX = n;
                    this.currentY = n2;
                    this.currentSA = n4;
                    n6 = this.currentDA;
                    this.currentDA = n3;
                }
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.messagePending = n6 == this.currentDA ? 2 : 3;
            SwingUtilities.invokeLater(this);
            while (true) {
                if (this.messagePending == 0) {
                    return this.currentA;
                }
                try {
                    this.syncLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        if (this.local != null) {
            return this.local.isDataFlavorSupported(dataFlavor);
        }
        DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].equals(dataFlavor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isTransferableJVMLocal() {
        return this.local != null || WDropTargetContextPeer.getJVMLocalSourceTransferable() != null;
    }

    private int mapOperation(DropTarget dropTarget, int n) {
        int[] nArray = new int[]{2, 1, 0x40000000};
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if ((n & nArray[n3]) == nArray[n3]) {
                n2 = nArray[n3];
                break;
            }
            ++n3;
        }
        return n2;
    }

    private void processDropMessage() {
        Component component = null;
        Point point = null;
        boolean bl = false;
        DropTarget dropTarget = null;
        Object object = this.currentNC.getTreeLock();
        synchronized (object) {
            try {
                component = ((Container)this.currentNC).findComponentAt(this.currentX, this.currentY);
            }
            catch (ClassCastException classCastException) {
                component = this.currentNC.locate(this.currentX, this.currentY);
            }
            boolean bl2 = bl = component != null && component.isShowing() && (dropTarget = component.getDropTarget()) != null && dropTarget.isActive();
            if (bl) {
                point = this.translate(this.currentNC, this.currentX, this.currentY, component);
            }
        }
        object = this.lock;
        synchronized (object) {
            this.dropStatus = 1;
            this.dropComplete = false;
        }
        if (bl) {
            Object object2;
            boolean bl3 = false;
            Object object3 = this.lock;
            synchronized (object3) {
                this.currentC = component;
                this.currentDT = dropTarget;
                object = dropTarget.getDropTargetContext();
                if (this.currentDTC != null) {
                    this.currentDTC.removeNotify();
                }
                this.currentDTC = object;
                ((DropTargetContext)this.currentDTC).addNotify(this);
            }
            object3 = _globalLock;
            synchronized (object3) {
                this.local = WDropTargetContextPeer.getJVMLocalSourceTransferable();
                if (this.local != null) {
                    WDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                }
            }
            try {
                try {
                    dropTarget.dragExit(new DropTargetEvent((DropTargetContext)object));
                    dropTarget.drop(new DropTargetDropEvent((DropTargetContext)object, point, this.currentDA, this.currentSA, this.local != null));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl3 = true;
                }
                Object var8_12 = null;
                object2 = this.lock;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                Object object4 = this.lock;
                synchronized (object4) {
                    if (this.dropStatus == 1 || bl3) {
                        this.rejectDrop();
                    }
                }
                throw throwable;
            }
            synchronized (object2) {
                if (this.dropStatus == 1 || bl3) {
                    this.rejectDrop();
                }
            }
        }
        this.rejectDrop();
    }

    private void processEnterMessage() {
        boolean bl;
        Component component;
        DropTarget dropTarget = null;
        Point point = null;
        this.local = WDropTargetContextPeer.getJVMLocalSourceTransferable();
        Object object = this.currentNC.getTreeLock();
        synchronized (object) {
            try {
                component = ((Container)this.currentNC).findComponentAt(this.currentX, this.currentY);
            }
            catch (ClassCastException classCastException) {
                component = this.currentNC.locate(this.currentX, this.currentY);
            }
            boolean bl2 = bl = component != null && component.isShowing() && (dropTarget = component.getDropTarget()) != null && dropTarget.isActive();
            if (bl) {
                point = this.translate(this.currentNC, this.currentX, this.currentY, component);
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.currentDTC != null) {
                this.currentDTC.removeNotify();
                this.currentDTC = null;
            }
        }
        if (bl) {
            object = this.lock;
            synchronized (object) {
                this.currentC = component;
                this.currentDT = dropTarget;
                this.currentDTC = this.currentDT.getDropTargetContext();
                this.currentDTC.addNotify(this);
                this.currentA = dropTarget.getDefaultActions();
            }
            try {
                dropTarget.dragEnter(new DropTargetDragEvent(this.currentDTC, point, this.currentDA, this.currentSA));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object object2 = this.lock;
                synchronized (object2) {
                    this.currentA = 0;
                }
            }
        } else {
            object = this.lock;
            synchronized (object) {
                this.currentDT = null;
                this.currentDTC = null;
                this.currentA = 0;
            }
        }
    }

    private void processExitMessage() {
        Object object;
        DropTarget dropTarget = null;
        DropTargetContext dropTargetContext = null;
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.currentC != null) {
                object = this.currentC.getDropTarget();
                if (object == null) {
                    this.currentC = null;
                    this.currentDT = null;
                    this.currentT = null;
                    if (this.currentDTC != null) {
                        this.currentDTC.removeNotify();
                    }
                    this.currentDTC = null;
                    Object var4_7 = null;
                    return;
                }
                if (object != this.currentDT) {
                    if (this.currentDTC != null) {
                        this.currentDTC.removeNotify();
                    }
                    dropTarget = this.currentDT = object;
                    dropTargetContext = this.currentDTC = ((DropTarget)object).getDropTargetContext();
                    this.currentDTC.addNotify(this);
                } else {
                    dropTarget = this.currentDT;
                    dropTargetContext = this.currentDTC;
                }
            }
        }
        if (dropTarget != null && dropTarget.isActive()) {
            try {
                try {
                    dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var4_8 = null;
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                object = this.lock;
                synchronized (object) {
                    this.currentA = 0;
                    this.currentSA = 0;
                    this.currentDA = 0;
                    this.currentC = null;
                    this.currentDT = null;
                    this.currentT = null;
                    this.currentDTC.removeNotify();
                    this.currentDTC = null;
                    this.local = null;
                }
                throw throwable;
            }
            synchronized (object) {
                this.currentA = 0;
                this.currentSA = 0;
                this.currentDA = 0;
                this.currentC = null;
                this.currentDT = null;
                this.currentT = null;
                this.currentDTC.removeNotify();
                this.currentDTC = null;
                this.local = null;
            }
        }
    }

    private void processMotionMessage(int n) {
        Object object;
        Component component = null;
        Point point = null;
        Point point2 = null;
        boolean bl = false;
        boolean bl2 = false;
        DropTarget dropTarget = null;
        DropTargetContext dropTargetContext = null;
        DropTarget dropTarget2 = null;
        if (this.currentC != null) {
            Object object2;
            boolean bl3 = false;
            object = this.currentNC.getTreeLock();
            synchronized (object) {
                try {
                    component = ((Container)this.currentNC).findComponentAt(this.currentX, this.currentY);
                }
                catch (ClassCastException classCastException) {
                    component = this.currentNC.locate(this.currentX, this.currentY);
                }
                point = this.translate(this.currentNC, this.currentX, this.currentY, this.currentC);
                bl3 = this.currentC.equals(component);
                if (!bl3 && component != null) {
                    point2 = this.translate(this.currentNC, this.currentX, this.currentY, component);
                    bl2 = component.isShowing() && (dropTarget2 = component.getDropTarget()) != null && dropTarget2.isActive();
                }
                object2 = this.lock;
                synchronized (object2) {
                    dropTarget = this.currentC.getDropTarget();
                    if (dropTarget == null) {
                        this.currentDTC.removeNotify();
                        this.currentC = null;
                        this.currentDTC = null;
                        this.currentT = null;
                    } else {
                        if (this.currentDT != dropTarget) {
                            if (this.currentDTC != null) {
                                this.currentDTC.removeNotify();
                            }
                            this.currentDT = dropTarget;
                            this.currentDTC = null;
                        }
                        if ((dropTargetContext = this.currentDT.getDropTargetContext()) != this.currentDTC) {
                            if (this.currentDTC != null) {
                                this.currentDTC.removeNotify();
                            }
                            this.currentDTC = dropTargetContext;
                            this.currentDTC.addNotify(this);
                        }
                        bl = this.currentC.isShowing() && dropTarget.isActive();
                    }
                }
            }
            if (bl) {
                if (!bl3) {
                    try {
                        try {
                            dropTarget.dragExit(new DropTargetEvent(dropTargetContext));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        Object var12_20 = null;
                        object2 = this.lock;
                    }
                    catch (Throwable throwable) {
                        Object var12_21 = null;
                        object2 = this.lock;
                        synchronized (object2) {
                            this.currentDTC.removeNotify();
                            this.currentDTC = null;
                            this.currentC = null;
                            this.currentT = null;
                            this.currentA = 0;
                        }
                        throw throwable;
                    }
                    synchronized (object2) {
                        this.currentDTC.removeNotify();
                        this.currentDTC = null;
                        this.currentC = null;
                        this.currentT = null;
                        this.currentA = 0;
                    }
                }
                try {
                    try {
                        if (n == 2) {
                            dropTarget.dragOver(new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA));
                        } else {
                            dropTarget.dropActionChanged(new DropTargetDragEvent(dropTargetContext, point, this.currentDA, this.currentSA));
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object object3 = this.lock;
                        synchronized (object3) {
                            this.currentA = 0;
                        }
                    }
                }
                catch (Throwable throwable) {}
                return;
            }
            object = this.lock;
            synchronized (object) {
                this.currentA = 0;
            }
        }
        if (component == null) {
            Object object4 = this.currentNC.getTreeLock();
            synchronized (object4) {
                try {
                    component = ((Container)this.currentNC).findComponentAt(this.currentX, this.currentY);
                }
                catch (ClassCastException classCastException) {
                    component = this.currentNC.locate(this.currentX, this.currentY);
                }
                boolean bl4 = bl2 = component != null && component.isShowing() && (dropTarget2 = component.getDropTarget()) != null && dropTarget2.isActive();
                if (bl2) {
                    point2 = this.translate(this.currentNC, this.currentX, this.currentY, component);
                }
            }
        }
        if (bl2) {
            Object object5 = this.lock;
            synchronized (object5) {
                this.currentC = component;
                dropTarget = this.currentDT = dropTarget2;
                dropTargetContext = this.currentDTC = dropTarget2.getDropTargetContext();
                this.currentDTC.addNotify(this);
                this.currentA = dropTarget2.getDefaultActions();
            }
            try {
                dropTarget.dragEnter(new DropTargetDragEvent(dropTargetContext, point2, this.currentDA, this.currentSA));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                object = this.lock;
                synchronized (object) {
                    this.currentA = 0;
                }
            }
        } else {
            Object object6 = this.lock;
            synchronized (object6) {
                this.currentC = null;
                this.currentDT = null;
                this.currentDTC = null;
                this.currentA = 0;
            }
        }
    }

    public void rejectDrag() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentDT == null) {
                throw new IllegalArgumentException("no drag pending");
            }
            this.currentA = 0;
        }
    }

    public void rejectDrop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dropStatus != 1) {
                throw new InvalidDnDOperationException("invalid rejectDrop()");
            }
            this.dropStatus = -1;
        }
        this.dropComplete(false);
    }

    public void run() {
        int n;
        Object object = this.syncLock;
        synchronized (object) {
            n = this.messagePending;
        }
        switch (n) {
            case 1: {
                this.processEnterMessage();
                break;
            }
            case 2: 
            case 3: {
                this.processMotionMessage(n);
                break;
            }
            case 4: {
                this.processExitMessage();
                break;
            }
            case 5: {
                this.processDropMessage();
                return;
            }
        }
        object = this.syncLock;
        synchronized (object) {
            if (this.messagePending != 0) {
                this.messagePending = 0;
                this.syncLock.notifyAll();
            }
        }
    }

    public synchronized void setAutoscrollDelay(int n) {
    }

    public synchronized void setAutoscrollInsets(Insets insets) {
    }

    static void setCurrentJVMLocalSourceTransferable(Transferable transferable) throws InvalidDnDOperationException {
        Object object = _globalLock;
        synchronized (object) {
            if (transferable != null && currentJVMLocalSourceTransferable != null) {
                throw new InvalidDnDOperationException();
            }
            currentJVMLocalSourceTransferable = transferable;
            currentJVMLocalSourceACtxt = transferable != null ? AccessController.getContext() : null;
        }
    }

    public void setTargetActions(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.currentA = n & 0x40000003;
        }
    }

    private Point translate(Component component, int n, int n2, Component component2) {
        Component component3 = component2;
        int n3 = 0;
        int n4 = 0;
        while (!component3.equals(component)) {
            Point point = component3.getLocation();
            n3 += point.x;
            n4 += point.y;
            component3 = component3.getParent();
        }
        return new Point(n - n3, n2 - n4);
    }
}

