/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.ScreenUpdater;
import sun.awt.SunToolkit;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

public class WFileDialogPeer
extends WWindowPeer
implements FileDialogPeer {
    private long hwnd = 0L;
    private WComponentPeer parent;

    static {
        WFileDialogPeer.initIDs();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
            String string = resourceBundle.getString("allFiles");
            WFileDialogPeer.setFilterString(string);
        }
        catch (MissingResourceException missingResourceException) {
            WFileDialogPeer.setFilterString("All Files");
        }
    }

    WFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
    }

    private native void _dispose();

    private native void _hide();

    private native void _show();

    void create(WComponentPeer wComponentPeer) {
        this.parent = wComponentPeer;
    }

    public void disable() {
    }

    protected void disposeImpl() {
        ScreenUpdater.updater.removeClient(this);
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public void enable() {
    }

    void handleCancel() {
        final FileDialog fileDialog = (FileDialog)this.target;
        SunToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                fileDialog.setFile(null);
                fileDialog.hide();
            }
        });
    }

    public boolean handleEvent(Event event) {
        return false;
    }

    void handleSelected(final String string) {
        final FileDialog fileDialog = (FileDialog)this.target;
        SunToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            public void run() {
                String string2;
                int n = string.lastIndexOf(File.separatorChar);
                if (n == -1) {
                    string2 = "." + File.separator;
                    fileDialog.setFile(string);
                } else {
                    string2 = string.substring(0, n + 1);
                    fileDialog.setFile(string.substring(n + 1));
                }
                fileDialog.setDirectory(string2);
                fileDialog.hide();
            }
        });
    }

    public void hide() {
        WToolkit.getWToolkit().notifyModalityChange(1301);
        this._hide();
    }

    private static native void initIDs();

    void initialize() {
    }

    void invalidate(int n, int n2, int n3, int n4) {
    }

    public void nextFocus() {
    }

    public void requestFocus() {
    }

    public void reshape(int n, int n2, int n3, int n4) {
    }

    public void setBackground(Color color) {
    }

    public void setCursor(int n) {
    }

    public void setDirectory(String string) {
    }

    public void setFile(String string) {
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        System.err.println("setFilenameFilter not implemented\n");
    }

    private static native void setFilterString(String var0);

    public void setFont(Font font) {
    }

    public void setForeground(Color color) {
    }

    public void setResizable(boolean bl) {
    }

    public void setTitle(String string) {
    }

    public void show() {
        new Thread(new Runnable(){

            public void run() {
                WFileDialogPeer.this._show();
                WToolkit.getWToolkit().notifyModalityChange(1300);
            }
        }).start();
    }

    void start() {
    }

    public void toBack() {
    }

    public void toFront() {
    }
}

