/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TooManyListenersException;

public class BeanContextServicesSupport
extends BeanContextSupport
implements BeanContextServices {
    protected transient HashMap services;
    protected transient int serializable = 0;
    protected transient BCSSProxyServiceProvider proxy;
    protected transient ArrayList bcsListeners;

    public BeanContextServicesSupport() {
        this(null, null, false, true);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices) {
        this(beanContextServices, null, false, true);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale) {
        this(beanContextServices, locale, false, true);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale, boolean bl) {
        this(beanContextServices, locale, bl, true);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale, boolean bl, boolean bl2) {
        super(beanContextServices, locale, bl, bl2);
    }

    public void addBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        if (beanContextServicesListener == null) {
            throw new NullPointerException("bcsl");
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (this.bcsListeners.contains(beanContextServicesListener)) {
                Object var3_3 = null;
                return;
            }
            this.bcsListeners.add(beanContextServicesListener);
        }
    }

    public boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        return this.addService(clazz, beanContextServiceProvider, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        if (beanContextServiceProvider == null) {
            throw new NullPointerException("bcsp");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(clazz)) {
                return false;
            }
            this.services.put(clazz, this.createBCSSServiceProvider(clazz, beanContextServiceProvider));
            if (beanContextServiceProvider instanceof Serializable) {
                ++this.serializable;
            }
            if (!bl) {
                return true;
            }
            BeanContextServiceAvailableEvent beanContextServiceAvailableEvent = new BeanContextServiceAvailableEvent(this.getBeanContextServicesPeer(), clazz);
            this.fireServiceAdded(beanContextServiceAvailableEvent);
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                Iterator iterator = this.children.keySet().iterator();
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    if (!(object2 instanceof BeanContextServices)) continue;
                    ((BeanContextServicesListener)object2).serviceAvailable(beanContextServiceAvailableEvent);
                }
                return true;
            }
        }
    }

    protected synchronized void bcsPreDeserializationHook(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = this.serializable = objectInputStream.readInt();
        while (n > 0) {
            this.services.put(objectInputStream.readObject(), objectInputStream.readObject());
            --n;
        }
    }

    protected synchronized void bcsPreSerializationHook(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.serializable);
        if (this.serializable <= 0) {
            return;
        }
        int n = 0;
        Iterator iterator = this.services.entrySet().iterator();
        while (iterator.hasNext() && n < this.serializable) {
            Map.Entry entry = (Map.Entry)iterator.next();
            BCSSServiceProvider bCSSServiceProvider = null;
            try {
                bCSSServiceProvider = (BCSSServiceProvider)entry.getValue();
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (!(bCSSServiceProvider.getServiceProvider() instanceof Serializable)) continue;
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(bCSSServiceProvider);
            ++n;
        }
        if (n != this.serializable) {
            throw new IOException("wrote different number of service providers than expected");
        }
    }

    protected void childJustRemovedHook(Object object, BeanContextSupport.BCSChild bCSChild) {
        BCSSChild bCSSChild = (BCSSChild)bCSChild;
        bCSSChild.cleanupReferences();
    }

    protected BeanContextSupport.BCSChild createBCSChild(Object object, Object object2) {
        return new BCSSChild(object, object2);
    }

    protected BCSSServiceProvider createBCSSServiceProvider(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        return new BCSSServiceProvider(clazz, beanContextServiceProvider);
    }

    protected final void fireServiceAdded(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        Object[] objectArray;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            objectArray = this.bcsListeners.toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BeanContextServicesListener)objectArray[n]).serviceAvailable(beanContextServiceAvailableEvent);
            ++n;
        }
    }

    protected final void fireServiceAdded(Class clazz) {
        BeanContextServiceAvailableEvent beanContextServiceAvailableEvent = new BeanContextServiceAvailableEvent(this.getBeanContextServicesPeer(), clazz);
        this.fireServiceAdded(beanContextServiceAvailableEvent);
    }

    protected final void fireServiceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        Object[] objectArray;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            objectArray = this.bcsListeners.toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BeanContextServiceRevokedListener)objectArray[n]).serviceRevoked(beanContextServiceRevokedEvent);
            ++n;
        }
    }

    protected final void fireServiceRevoked(Class clazz, boolean bl) {
        Object[] objectArray;
        BeanContextServiceRevokedEvent beanContextServiceRevokedEvent = new BeanContextServiceRevokedEvent(this.getBeanContextServicesPeer(), clazz, bl);
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            objectArray = this.bcsListeners.toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BeanContextServicesListener)objectArray[n]).serviceRevoked(beanContextServiceRevokedEvent);
            ++n;
        }
    }

    public BeanContextServices getBeanContextServicesPeer() {
        return (BeanContextServices)this.getBeanContextChildPeer();
    }

    protected static final BeanContextServicesListener getChildBeanContextServicesListener(Object object) {
        try {
            return (BeanContextServicesListener)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Iterator getCurrentServiceClasses() {
        return new BeanContextSupport.BCSIterator(this.services.keySet().iterator());
    }

    public Iterator getCurrentServiceSelectors(Class clazz) {
        BCSSServiceProvider bCSSServiceProvider = (BCSSServiceProvider)this.services.get(clazz);
        return bCSSServiceProvider != null ? new BeanContextSupport.BCSIterator(bCSSServiceProvider.getServiceProvider().getCurrentServiceSelectors(this.getBeanContextServicesPeer(), clazz)) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getService(BeanContextChild beanContextChild, Object object, Class clazz, Object object2, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
        if (beanContextChild == null) {
            throw new NullPointerException("child");
        }
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        if (object == null) {
            throw new NullPointerException("requestor");
        }
        if (beanContextServiceRevokedListener == null) {
            throw new NullPointerException("bcsrl");
        }
        Object object3 = null;
        BeanContextServices beanContextServices = this.getBeanContextServicesPeer();
        Object object4 = BeanContext.globalHierarchyLock;
        synchronized (object4) {
            BeanContextServiceProvider beanContextServiceProvider;
            BCSSChild bCSSChild;
            Serializable serializable = this.children;
            synchronized (serializable) {
                bCSSChild = (BCSSChild)this.children.get(beanContextChild);
            }
            if (bCSSChild == null) {
                throw new IllegalArgumentException("not a child of this context");
            }
            serializable = (BCSSServiceProvider)this.services.get(clazz);
            if (serializable != null && (object3 = (beanContextServiceProvider = ((BCSSServiceProvider)serializable).getServiceProvider()).getService(beanContextServices, object, clazz, object2)) != null) {
                try {
                    bCSSChild.usingService(object, object3, clazz, beanContextServiceProvider, false, beanContextServiceRevokedListener);
                    return object3;
                }
                catch (TooManyListenersException tooManyListenersException) {
                    beanContextServiceProvider.releaseService(beanContextServices, object, object3);
                    throw tooManyListenersException;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    beanContextServiceProvider.releaseService(beanContextServices, object, object3);
                    throw unsupportedOperationException;
                }
            }
            if (this.proxy == null) return null;
            object3 = this.proxy.getService(beanContextServices, object, clazz, object2);
            if (object3 == null) return null;
            try {
                bCSSChild.usingService(object, object3, clazz, this.proxy, true, beanContextServiceRevokedListener);
                return object3;
            }
            catch (TooManyListenersException tooManyListenersException) {
                this.proxy.releaseService(beanContextServices, object, object3);
                throw tooManyListenersException;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.proxy.releaseService(beanContextServices, object, object3);
                throw unsupportedOperationException;
            }
        }
    }

    public synchronized boolean hasService(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(clazz)) {
                boolean bl = true;
                Object var4_6 = null;
                return bl;
            }
            BeanContextServices beanContextServices = null;
            try {
                beanContextServices = (BeanContextServices)this.getBeanContext();
            }
            catch (ClassCastException classCastException) {
                boolean bl = false;
                Object var4_7 = null;
                return bl;
            }
            boolean bl = beanContextServices == null ? false : beanContextServices.hasService(clazz);
            Object var4_8 = null;
            return bl;
        }
    }

    public void initialize() {
        super.initialize();
        this.services = new HashMap(this.serializable + 1);
        this.bcsListeners = new ArrayList(1);
    }

    protected synchronized void initializeBeanContextResources() {
        super.initializeBeanContextResources();
        BeanContext beanContext = this.getBeanContext();
        if (beanContext == null) {
            return;
        }
        try {
            BeanContextServices beanContextServices = (BeanContextServices)beanContext;
            this.proxy = new BCSSProxyServiceProvider(beanContextServices);
        }
        catch (ClassCastException classCastException) {}
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.deserialize(objectInputStream, this.bcsListeners);
    }

    protected synchronized void releaseBeanContextResources() {
        Object[] objectArray;
        super.releaseBeanContextResources();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.isEmpty()) {
                Object var3_3 = null;
                return;
            }
            objectArray = this.children.values().toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            ((BCSSChild)objectArray[n]).revokeAllDelegatedServicesNow();
            ++n;
        }
        this.proxy = null;
    }

    public void releaseService(BeanContextChild beanContextChild, Object object, Object object2) {
        if (beanContextChild == null) {
            throw new NullPointerException("child");
        }
        if (object == null) {
            throw new NullPointerException("requestor");
        }
        if (object2 == null) {
            throw new NullPointerException("service");
        }
        Object object3 = BeanContext.globalHierarchyLock;
        synchronized (object3) {
            BCSSChild bCSSChild;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                bCSSChild = (BCSSChild)this.children.get(beanContextChild);
            }
            if (bCSSChild == null) {
                throw new IllegalArgumentException("child actual is not a child of this BeanContext");
            }
            bCSSChild.releaseService(object, object2);
        }
    }

    public void removeBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        if (beanContextServicesListener == null) {
            throw new NullPointerException("bcsl");
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(beanContextServicesListener)) {
                Object var3_3 = null;
                return;
            }
            this.bcsListeners.remove(beanContextServicesListener);
        }
    }

    public void revokeService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        if (beanContextServiceProvider == null) {
            throw new NullPointerException("bcsp");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (!this.services.containsKey(clazz)) {
                Object var5_5 = null;
                return;
            }
            BCSSServiceProvider bCSSServiceProvider = (BCSSServiceProvider)this.services.get(clazz);
            if (!bCSSServiceProvider.getServiceProvider().equals(beanContextServiceProvider)) {
                throw new IllegalArgumentException("service provider mismatch");
            }
            this.services.remove(clazz);
            if (beanContextServiceProvider instanceof Serializable) {
                --this.serializable;
            }
            Iterator iterator = this.bcsChildren();
            while (iterator.hasNext()) {
                ((BCSSChild)iterator.next()).revokeService(clazz, false, bl);
            }
            this.fireServiceRevoked(clazz, bl);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void serviceAvailable(BeanContextServiceAvailableEvent var1_1) {
        var2_2 = BeanContext.globalHierarchyLock;
        synchronized (var2_2) {
            if (this.services.containsKey(var1_1.getServiceClass())) {
                var3_3 = null;
                return;
            }
            this.fireServiceAdded(var1_1);
            var5_4 = this.children;
            synchronized (var5_4) {
                var4_5 = this.children.keySet().iterator();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var5_4
                if (true) ** GOTO lbl20
            }
            do {
                if (!((var5_4 = var4_5.next()) instanceof BeanContextServices)) continue;
                ((BeanContextServicesListener)var5_4).serviceAvailable(var1_1);
lbl20:
                // 3 sources

            } while (var4_5.hasNext());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void serviceRevoked(BeanContextServiceRevokedEvent var1_1) {
        var2_2 = BeanContext.globalHierarchyLock;
        synchronized (var2_2) {
            if (this.services.containsKey(var1_1.getServiceClass())) {
                var3_3 = null;
                return;
            }
            this.fireServiceRevoked(var1_1);
            var5_4 = this.children;
            synchronized (var5_4) {
                var4_5 = this.children.keySet().iterator();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl14 : MonitorExitStatement: MONITOREXIT : var5_4
                if (true) ** GOTO lbl20
            }
            do {
                if (!((var5_4 = var4_5.next()) instanceof BeanContextServices)) continue;
                ((BeanContextServicesListener)var5_4).serviceRevoked(var1_1);
lbl20:
                // 3 sources

            } while (var4_5.hasNext());
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.serialize(objectOutputStream, this.bcsListeners);
    }

    protected class BCSSChild
    extends BeanContextSupport.BCSChild {
        private transient HashMap serviceClasses;
        private transient HashMap serviceRequestors;

        BCSSChild(Object object, Object object2) {
            super(object, object2);
        }

        void cleanupReferences() {
            if (this.serviceRequestors == null) {
                return;
            }
            Iterator iterator = this.serviceRequestors.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object object = entry.getKey();
                Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
                iterator.remove();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iterator2.next();
                    Object object2 = entry2.getKey();
                    BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)entry2.getValue();
                    BCSSCServiceClassRef bCSSCServiceClassRef = bCSSCServiceRef.getServiceClassRef();
                    BeanContextServiceProvider beanContextServiceProvider = bCSSCServiceRef.isDelegated() ? bCSSCServiceClassRef.getDelegateProvider() : bCSSCServiceClassRef.getServiceProvider();
                    bCSSCServiceClassRef.removeRequestor(object);
                    iterator2.remove();
                    while (bCSSCServiceRef.release() >= 0) {
                        beanContextServiceProvider.releaseService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), object, object2);
                    }
                }
            }
            this.serviceRequestors = null;
            this.serviceClasses = null;
        }

        synchronized void releaseService(Object object, Object object2) {
            if (this.serviceRequestors == null) {
                return;
            }
            Map map = (Map)this.serviceRequestors.get(object);
            if (map == null) {
                return;
            }
            BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)map.get(object2);
            if (bCSSCServiceRef == null) {
                return;
            }
            BCSSCServiceClassRef bCSSCServiceClassRef = bCSSCServiceRef.getServiceClassRef();
            boolean bl = bCSSCServiceRef.isDelegated();
            BeanContextServiceProvider beanContextServiceProvider = bl ? bCSSCServiceClassRef.getDelegateProvider() : bCSSCServiceClassRef.getServiceProvider();
            beanContextServiceProvider.releaseService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), object, object2);
            bCSSCServiceClassRef.releaseRef(bl);
            if (bCSSCServiceRef.release() == 0) {
                map.remove(object2);
                if (map.isEmpty()) {
                    this.serviceRequestors.remove(object);
                    bCSSCServiceClassRef.removeRequestor(object);
                }
                if (this.serviceRequestors.isEmpty()) {
                    this.serviceRequestors = null;
                }
                if (bCSSCServiceClassRef.isEmpty()) {
                    this.serviceClasses.remove(bCSSCServiceClassRef.getServiceClass());
                }
                if (this.serviceClasses.isEmpty()) {
                    this.serviceClasses = null;
                }
            }
        }

        void revokeAllDelegatedServicesNow() {
            if (this.serviceClasses == null) {
                return;
            }
            Iterator iterator = this.serviceClasses.values().iterator();
            while (iterator.hasNext()) {
                BCSSCServiceClassRef bCSSCServiceClassRef = (BCSSCServiceClassRef)iterator.next();
                if (!bCSSCServiceClassRef.isDelegated()) continue;
                Iterator iterator2 = bCSSCServiceClassRef.entries();
                BeanContextServiceRevokedEvent beanContextServiceRevokedEvent = new BeanContextServiceRevokedEvent(BeanContextServicesSupport.this.getBeanContextServicesPeer(), bCSSCServiceClassRef.getServiceClass(), true);
                boolean bl = false;
                while (iterator2.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator2.next();
                    BeanContextServiceRevokedListener beanContextServiceRevokedListener = (BeanContextServiceRevokedListener)entry.getValue();
                    Object object = entry.getKey();
                    Map map = (Map)this.serviceRequestors.get(object);
                    if (map != null) {
                        Iterator iterator3 = map.entrySet().iterator();
                        while (iterator3.hasNext()) {
                            Map.Entry entry2 = (Map.Entry)iterator3.next();
                            BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)entry2.getValue();
                            if (!bCSSCServiceRef.getServiceClassRef().equals(bCSSCServiceClassRef) || !bCSSCServiceRef.isDelegated()) continue;
                            iterator3.remove();
                        }
                        bl = map.isEmpty();
                        if (bl) {
                            this.serviceRequestors.remove(object);
                        }
                    }
                    if (bl) {
                        bCSSCServiceClassRef.removeRequestor(object);
                    }
                    beanContextServiceRevokedListener.serviceRevoked(beanContextServiceRevokedEvent);
                    if (!bCSSCServiceClassRef.isEmpty()) continue;
                    this.serviceClasses.remove(bCSSCServiceClassRef.getServiceClass());
                }
            }
            if (this.serviceClasses.isEmpty()) {
                this.serviceClasses = null;
            }
            if (this.serviceRequestors != null && this.serviceRequestors.isEmpty()) {
                this.serviceRequestors = null;
            }
        }

        synchronized void revokeService(Class clazz, boolean bl, boolean bl2) {
            if (this.serviceClasses == null) {
                return;
            }
            BCSSCServiceClassRef bCSSCServiceClassRef = (BCSSCServiceClassRef)this.serviceClasses.get(clazz);
            if (bCSSCServiceClassRef == null) {
                return;
            }
            Iterator iterator = bCSSCServiceClassRef.entries();
            BeanContextServiceRevokedEvent beanContextServiceRevokedEvent = new BeanContextServiceRevokedEvent(BeanContextServicesSupport.this.getBeanContextServicesPeer(), clazz, bl2);
            boolean bl3 = false;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                BeanContextServiceRevokedListener beanContextServiceRevokedListener = (BeanContextServiceRevokedListener)entry.getValue();
                if (bl2) {
                    Object object = entry.getKey();
                    Map map = (Map)this.serviceRequestors.get(object);
                    if (map != null) {
                        Iterator iterator2 = map.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry entry2 = (Map.Entry)iterator2.next();
                            BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)entry2.getValue();
                            if (!bCSSCServiceRef.getServiceClassRef().equals(bCSSCServiceClassRef) || bl != bCSSCServiceRef.isDelegated()) continue;
                            iterator2.remove();
                        }
                        bl3 = map.isEmpty();
                        if (bl3) {
                            this.serviceRequestors.remove(object);
                        }
                    }
                    if (bl3) {
                        bCSSCServiceClassRef.removeRequestor(object);
                    }
                }
                beanContextServiceRevokedListener.serviceRevoked(beanContextServiceRevokedEvent);
            }
            if (bl2 && this.serviceClasses != null) {
                if (bCSSCServiceClassRef.isEmpty()) {
                    this.serviceClasses.remove(clazz);
                }
                if (this.serviceClasses.isEmpty()) {
                    this.serviceClasses = null;
                }
            }
            if (this.serviceRequestors != null && this.serviceRequestors.isEmpty()) {
                this.serviceRequestors = null;
            }
        }

        synchronized void usingService(Object object, Object object2, Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException, UnsupportedOperationException {
            BCSSCServiceClassRef bCSSCServiceClassRef = null;
            if (this.serviceClasses == null) {
                this.serviceClasses = new HashMap(1);
            } else {
                bCSSCServiceClassRef = (BCSSCServiceClassRef)this.serviceClasses.get(clazz);
            }
            if (bCSSCServiceClassRef == null) {
                bCSSCServiceClassRef = new BCSSCServiceClassRef(clazz, beanContextServiceProvider, bl);
                this.serviceClasses.put(clazz, bCSSCServiceClassRef);
                bCSSCServiceClassRef.addRequestor(object, beanContextServiceRevokedListener);
            } else {
                bCSSCServiceClassRef.verifyAndMaybeSetProvider(beanContextServiceProvider, bl);
                bCSSCServiceClassRef.verifyRequestor(object, beanContextServiceRevokedListener);
            }
            bCSSCServiceClassRef.addRef(bl);
            BCSSCServiceRef bCSSCServiceRef = null;
            Map map = null;
            if (this.serviceRequestors == null) {
                this.serviceRequestors = new HashMap(1);
            } else {
                map = (Map)this.serviceRequestors.get(object);
            }
            if (map == null) {
                map = new HashMap(1);
                this.serviceRequestors.put(object, map);
            } else {
                bCSSCServiceRef = (BCSSCServiceRef)map.get(object2);
            }
            if (bCSSCServiceRef == null) {
                bCSSCServiceRef = new BCSSCServiceRef(bCSSCServiceClassRef, bl);
                map.put(object2, bCSSCServiceRef);
            } else {
                bCSSCServiceRef.addRef();
            }
        }

        class BCSSCServiceClassRef {
            Class serviceClass;
            BeanContextServiceProvider serviceProvider;
            int serviceRefs;
            BeanContextServiceProvider delegateProvider;
            int delegateRefs;
            HashMap requestors = new HashMap(1);

            BCSSCServiceClassRef(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
                this.serviceClass = clazz;
                if (bl) {
                    this.delegateProvider = beanContextServiceProvider;
                } else {
                    this.serviceProvider = beanContextServiceProvider;
                }
            }

            void addRef(boolean bl) {
                if (bl) {
                    ++this.delegateRefs;
                } else {
                    ++this.serviceRefs;
                }
            }

            void addRequestor(Object object, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
                BeanContextServiceRevokedListener beanContextServiceRevokedListener2 = (BeanContextServiceRevokedListener)this.requestors.get(object);
                if (beanContextServiceRevokedListener2 != null && !beanContextServiceRevokedListener2.equals(beanContextServiceRevokedListener)) {
                    throw new TooManyListenersException();
                }
                this.requestors.put(object, beanContextServiceRevokedListener);
            }

            Iterator entries() {
                return this.requestors.entrySet().iterator();
            }

            BeanContextServiceProvider getDelegateProvider() {
                return this.delegateProvider;
            }

            int getDelegateRefs() {
                return this.delegateRefs;
            }

            int getRefs() {
                return this.serviceRefs + this.delegateRefs;
            }

            Class getServiceClass() {
                return this.serviceClass;
            }

            BeanContextServiceProvider getServiceProvider() {
                return this.serviceProvider;
            }

            int getServiceRefs() {
                return this.serviceRefs;
            }

            boolean isDelegated() {
                return this.delegateProvider != null;
            }

            boolean isEmpty() {
                return this.requestors.isEmpty();
            }

            void releaseRef(boolean bl) {
                if (bl) {
                    if (--this.delegateRefs == 0) {
                        this.delegateProvider = null;
                    } else if (--this.serviceRefs <= 0) {
                        this.serviceProvider = null;
                    }
                }
            }

            void removeRequestor(Object object) {
                this.requestors.remove(object);
            }

            void verifyAndMaybeSetProvider(BeanContextServiceProvider beanContextServiceProvider, boolean bl) {
                BeanContextServiceProvider beanContextServiceProvider2;
                if (bl) {
                    beanContextServiceProvider2 = this.delegateProvider;
                    if (beanContextServiceProvider2 == null || beanContextServiceProvider == null) {
                        this.delegateProvider = beanContextServiceProvider;
                        return;
                    }
                } else {
                    beanContextServiceProvider2 = this.serviceProvider;
                    if (beanContextServiceProvider2 == null || beanContextServiceProvider == null) {
                        this.serviceProvider = beanContextServiceProvider;
                        return;
                    }
                }
                if (!beanContextServiceProvider2.equals(beanContextServiceProvider)) {
                    throw new UnsupportedOperationException("existing service reference obtained from different BeanContextServiceProvider not supported");
                }
            }

            void verifyRequestor(Object object, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
                BeanContextServiceRevokedListener beanContextServiceRevokedListener2 = (BeanContextServiceRevokedListener)this.requestors.get(object);
                if (beanContextServiceRevokedListener2 != null && !beanContextServiceRevokedListener2.equals(beanContextServiceRevokedListener)) {
                    throw new TooManyListenersException();
                }
            }
        }

        class BCSSCServiceRef {
            BCSSCServiceClassRef serviceClassRef;
            int refCnt = 1;
            boolean delegated = false;

            BCSSCServiceRef(BCSSCServiceClassRef bCSSCServiceClassRef, boolean bl) {
                this.serviceClassRef = bCSSCServiceClassRef;
                this.delegated = bl;
            }

            void addRef() {
                ++this.refCnt;
            }

            BCSSCServiceClassRef getServiceClassRef() {
                return this.serviceClassRef;
            }

            boolean isDelegated() {
                return this.delegated;
            }

            int release() {
                return --this.refCnt;
            }
        }
    }

    protected static class BCSSServiceProvider
    implements Serializable {
        protected BeanContextServiceProvider serviceProvider;

        BCSSServiceProvider(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
            this.serviceProvider = beanContextServiceProvider;
        }

        protected BeanContextServiceProvider getServiceProvider() {
            return this.serviceProvider;
        }
    }

    protected class BCSSProxyServiceProvider
    implements BeanContextServiceProvider,
    BeanContextServiceRevokedListener {
        private BeanContextServices nestingCtxt;

        BCSSProxyServiceProvider(BeanContextServices beanContextServices) {
            this.nestingCtxt = beanContextServices;
        }

        public Iterator getCurrentServiceSelectors(BeanContextServices beanContextServices, Class clazz) {
            return this.nestingCtxt.getCurrentServiceSelectors(clazz);
        }

        public Object getService(BeanContextServices beanContextServices, Object object, Class clazz, Object object2) {
            Object object3 = null;
            try {
                object3 = this.nestingCtxt.getService(beanContextServices, object, clazz, object2, this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                return null;
            }
            return object3;
        }

        public void releaseService(BeanContextServices beanContextServices, Object object, Object object2) {
            this.nestingCtxt.releaseService(beanContextServices, object, object2);
        }

        public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
            Iterator iterator = BeanContextServicesSupport.this.bcsChildren();
            while (iterator.hasNext()) {
                ((BCSSChild)iterator.next()).revokeService(beanContextServiceRevokedEvent.getServiceClass(), true, beanContextServiceRevokedEvent.isCurrentServiceInvalidNow());
            }
        }
    }
}

