/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.color;

import sun.awt.color.ICC_Transform;

class pelArrayInfo {
    int nPels;
    int nSrc;
    int srcSize;
    int nDest;
    int destSize;

    pelArrayInfo(ICC_Transform iCC_Transform, int n, float[] fArray, float[] fArray2) {
        this.nSrc = iCC_Transform.getNumInComponents();
        this.nDest = iCC_Transform.getNumOutComponents();
        this.nPels = n;
        this.srcSize = this.nPels * this.nSrc;
        this.destSize = this.nPels * this.nDest;
        if (this.srcSize > fArray.length) {
            throw new IllegalArgumentException("Inconsistent pel structure");
        }
        if (fArray2 != null) {
            this.checkDest(fArray2.length);
        }
    }

    pelArrayInfo(ICC_Transform iCC_Transform, byte[] byArray, byte[] byArray2) {
        this.srcSize = byArray.length;
        this.initInfo(iCC_Transform);
        this.destSize = this.nPels * this.nDest;
        if (byArray2 != null) {
            this.checkDest(byArray2.length);
        }
    }

    pelArrayInfo(ICC_Transform iCC_Transform, short[] sArray, short[] sArray2) {
        this.srcSize = sArray.length;
        this.initInfo(iCC_Transform);
        this.destSize = this.nPels * this.nDest;
        if (sArray2 != null) {
            this.checkDest(sArray2.length);
        }
    }

    void checkDest(int n) {
        if (this.destSize > n) {
            throw new IllegalArgumentException("Inconsistent pel structure");
        }
    }

    void initInfo(ICC_Transform iCC_Transform) {
        this.nSrc = iCC_Transform.getNumInComponents();
        this.nDest = iCC_Transform.getNumOutComponents();
        this.nPels = this.srcSize / this.nSrc;
        if (this.nPels * this.nSrc != this.srcSize) {
            throw new IllegalArgumentException("Inconsistent pel structure");
        }
    }
}

