/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import sun.awt.im.InputMethodContext;
import sun.awt.im.InputMethodManager;

class CompositionArea
extends Canvas
implements InputMethodListener,
InputMethodRequests {
    private AttributedCharacterIterator composedText;
    private TextLayout composedTextLayout;
    private TextHitInfo caret = null;
    private Frame compositionWindow = new Frame();
    private Component target = null;
    private InputMethodContext inputMethodContext;
    private static final int TEXT_ORIGIN_X = 5;
    private static final int TEXT_ORIGIN_Y = 15;
    private static final AttributedCharacterIterator.Attribute[] IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};
    private static final AttributedCharacterIterator EMPTY_TEXT = new AttributedString("").getIterator();

    CompositionArea(InputMethodContext inputMethodContext) {
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getLocalizedString("CompositionArea.inputWindowTitle");
        if (string == null) {
            string = "Input Window";
        }
        this.compositionWindow.setTitle(string);
        this.setSize(480, 18);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.enableInputMethods(true);
        this.enableEvents(8L);
        this.compositionWindow.add(this);
        this.compositionWindow.addWindowListener(new FrameWindowAdapter());
        this.addInputMethodListener(this);
        this.inputMethodContext = inputMethodContext;
        this.compositionWindow.enableInputMethods(false);
        this.compositionWindow.pack();
        Dimension dimension = this.compositionWindow.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.compositionWindow.setLocation(dimension2.width - dimension.width - 20, dimension2.height - dimension.height - 100);
        this.compositionWindow.setVisible(false);
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
        this.caret = inputMethodEvent.getCaret();
        if (this.compositionWindow.isVisible()) {
            this.paint(this.getGraphics());
        }
        inputMethodEvent.consume();
    }

    private Rectangle getCaretRectangle(TextHitInfo textHitInfo) {
        int n = 0;
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout != null) {
            n = Math.round(textLayout.getCaretInfo(textHitInfo)[0]);
        }
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        return new Rectangle(5 + n, 15 - fontMetrics.getAscent(), 0, fontMetrics.getAscent() + fontMetrics.getDescent());
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        return EMPTY_TEXT;
    }

    public int getCommittedTextLength() {
        return 0;
    }

    public InputContext getInputContext() {
        return this.inputMethodContext;
    }

    public InputMethodRequests getInputMethodRequests() {
        return this;
    }

    public int getInsertPositionOffset() {
        return 0;
    }

    public TextHitInfo getLocationOffset(int n, int n2) {
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout == null) {
            return null;
        }
        Point point = this.getLocationOnScreen();
        if (textLayout.getBounds().contains(n -= point.x + 5, n2 -= point.y + 15)) {
            return textLayout.hitTestChar(n, n2);
        }
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return EMPTY_TEXT;
    }

    public Rectangle getTextLocation(TextHitInfo textHitInfo) {
        Rectangle rectangle = this.getCaretRectangle(textHitInfo);
        Point point = this.getLocationOnScreen();
        rectangle.translate(point.x, point.y);
        return rectangle;
    }

    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        int n = inputMethodEvent.getCommittedCharacterCount();
        this.composedText = null;
        this.composedTextLayout = null;
        if (attributedCharacterIterator == null || n == attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex()) {
            this.compositionWindow.setVisible(false);
            this.caret = null;
        } else {
            AttributedString attributedString = new AttributedString(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex() + n, attributedCharacterIterator.getEndIndex(), IM_ATTRIBUTES);
            attributedString.addAttribute(TextAttribute.FONT, this.getFont());
            this.composedText = attributedString.getIterator();
            FontRenderContext fontRenderContext = ((Graphics2D)this.getGraphics()).getFontRenderContext();
            this.composedTextLayout = new TextLayout(this.composedText, fontRenderContext);
            this.caret = inputMethodEvent.getCaret();
            this.compositionWindow.setVisible(true);
            this.paint(this.getGraphics());
        }
        if (n > 0) {
            this.inputMethodContext.dispatchCommittedText((Component)inputMethodEvent.getSource(), attributedCharacterIterator, n);
        }
        inputMethodEvent.consume();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(this.getForeground());
        TextLayout textLayout = this.composedTextLayout;
        if (textLayout != null) {
            textLayout.draw((Graphics2D)graphics, 5.0f, 15.0f);
        }
        if (this.caret != null) {
            Rectangle rectangle = this.getCaretRectangle(this.caret);
            graphics.setXORMode(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, 1, rectangle.height);
            graphics.setPaintMode();
        }
    }

    void setTarget(Component component) {
        this.target = component;
    }

    class FrameWindowAdapter
    extends WindowAdapter {
        FrameWindowAdapter() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            CompositionArea.this.requestFocus();
        }
    }
}

