/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.font.NativeFontWrapper;
import sun.awt.image.BufferedImageGraphics2D;
import sun.io.CharacterEncoding;

public abstract class SunGraphicsEnvironment
extends GraphicsEnvironment {
    private static final boolean debugMapping = false;
    private Properties fprops;
    private TreeMap terminalNames;
    private boolean loadedAllFonts = false;
    protected String fontPath;
    protected TreeMap registeredFonts = new TreeMap();
    protected String osVersion = this.getOsVersion();
    private Hashtable mapFamilyCache;
    protected boolean loadNativeFonts = false;
    GraphicsDevice[] screens;
    private Font[] allFonts;

    public SunGraphicsEnvironment() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SunGraphicsEnvironment.this.fontPath = System.getProperty("java.awt.fonts");
                if (SunGraphicsEnvironment.this.fontPath.length() == 0) {
                    SunGraphicsEnvironment.this.fontPath = NativeFontWrapper.getFontPath();
                    SunGraphicsEnvironment.this.appendJavaDefaultFontPath();
                    SunGraphicsEnvironment.this.loadNativeFonts = true;
                }
                SunGraphicsEnvironment.this.initializeProps();
                SunGraphicsEnvironment.this.initCompositeFonts();
                return null;
            }
        });
    }

    static /* synthetic */ boolean access$3(SunGraphicsEnvironment sunGraphicsEnvironment) {
        return sunGraphicsEnvironment.loadedAllFonts;
    }

    private boolean addPathFonts(String string, FilenameFilter filenameFilter, int n) {
        boolean bl = false;
        Vector vector = new Vector(20, 10);
        Vector vector2 = new Vector(20, 10);
        File file = new File(string);
        String[] stringArray = file.list(filenameFilter);
        if (stringArray == null) {
            return bl;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2 = new File(file, stringArray[n2]);
            if (!this.registeredFonts.containsKey(stringArray[n2])) {
                String string2 = file2.getAbsolutePath();
                this.registeredFonts.put(stringArray[n2], string2);
                vector.addElement(string2);
                vector2.addElement(this.getPropString(string2));
                bl = true;
            }
            ++n2;
        }
        NativeFontWrapper.registerFonts(vector, vector.size(), vector2, n);
        return bl;
    }

    private int[] appendExclusions(String string, int n, int[] nArray) {
        String string2;
        int n2;
        String string3 = "exclusion." + string + "." + n;
        if (this.fprops.containsKey(string3) && (n2 = ((string2 = this.fprops.getProperty(string3)).length() + 1) / 10) > 0) {
            Object object;
            int[] nArray2 = new int[n2 * 2];
            int n3 = 0;
            while (n3 < n2) {
                String string4 = string2.substring(n3 * 10, n3 * 10 + 4);
                object = string2.substring(n3 * 10 + 5, n3 * 10 + 9);
                nArray2[n3 * 2] = Integer.parseInt(string4, 16);
                nArray2[n3 * 2 + 1] = Integer.parseInt((String)object, 16);
                ++n3;
            }
            int n4 = nArray.length + nArray2.length;
            object = new int[n4];
            System.arraycopy(nArray, 0, object, 0, nArray.length);
            System.arraycopy(nArray2, 0, object, nArray.length, nArray2.length);
            nArray = object;
        }
        return nArray;
    }

    private void appendJavaDefaultFontPath() {
        String string = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "fonts";
        if (string != null) {
            this.fontPath = String.valueOf(this.fontPath) + File.pathSeparator + string;
        }
    }

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        return new BufferedImageGraphics2D(bufferedImage, null);
    }

    public Font[] getAllFonts() {
        if (this.allFonts != null) {
            return this.allFonts;
        }
        this.loadFonts();
        Font[] fontArray = null;
        String[] stringArray = null;
        int n = NativeFontWrapper.getNumFonts();
        if (n > 0) {
            Object[] objectArray;
            TreeMap treeMap = new TreeMap();
            int n2 = 0;
            while (n2 < n) {
                objectArray = NativeFontWrapper.getFullNameByIndex(n2);
                treeMap.put(objectArray, null);
                ++n2;
            }
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                objectArray = treeMap.keySet().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    stringArray[n3] = (String)objectArray[n3];
                    ++n3;
                }
            }
        }
        if (stringArray != null) {
            fontArray = new Font[stringArray.length];
            int n4 = 0;
            while (n4 < stringArray.length) {
                fontArray[n4] = new Font(stringArray[n4], 0, 1);
                ++n4;
            }
        }
        this.allFonts = fontArray;
        return this.allFonts;
    }

    public String[] getAvailableFontFamilyNames() {
        this.loadFonts();
        String[] stringArray = null;
        int n = NativeFontWrapper.getNumFonts();
        if (n > 0) {
            String string;
            TreeMap treeMap = new TreeMap();
            int n2 = 0;
            while (n2 < n) {
                string = NativeFontWrapper.getFamilyNameByIndex(n2);
                treeMap.put(string.toLowerCase(), string);
                ++n2;
            }
            string = "Serif";
            treeMap.put(string.toLowerCase(), string);
            string = "SansSerif";
            treeMap.put(string.toLowerCase(), string);
            string = "Monospaced";
            treeMap.put(string.toLowerCase(), string);
            string = "Dialog";
            treeMap.put(string.toLowerCase(), string);
            string = "DialogInput";
            treeMap.put(string.toLowerCase(), string);
            string = "Default";
            treeMap.put(string.toLowerCase(), string);
            if (treeMap.size() > 0) {
                stringArray = new String[treeMap.size()];
                Object[] objectArray = treeMap.keySet().toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    stringArray[n3] = (String)treeMap.get(objectArray[n3]);
                    ++n3;
                }
            }
        }
        return stringArray;
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        return this.getAvailableFontFamilyNames();
    }

    public static Font getBestFontFor(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        char c = attributedCharacterIterator.setIndex(n);
        Map map = attributedCharacterIterator.getAttributes();
        Font font = Font.getFont(map);
        while (!font.canDisplay(c) && attributedCharacterIterator.getRunLimit() < n2) {
            attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
            font = Font.getFont(attributedCharacterIterator.getAttributes());
        }
        if (!font.canDisplay(c)) {
            attributedCharacterIterator.setIndex(n);
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int n3 = 0;
            while (n3 < stringArray.length) {
                Hashtable hashtable = new Hashtable();
                hashtable.putAll(map);
                hashtable.put(TextAttribute.FAMILY, stringArray[n3]);
                font = Font.getFont(hashtable);
                if (font.canDisplay(c)) break;
                ++n3;
            }
            if (!font.canDisplay(c)) {
                font = Font.getFont(map);
            }
        }
        return font;
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[0];
    }

    protected String getFileNameFromPlatformName(String string) {
        if (this.fprops == null) {
            return null;
        }
        string = string.replace(' ', '_');
        return this.fprops.getProperty("filename." + string);
    }

    protected String getFontPropertyFD(String string) {
        return this.parseFamilyNameProperty(string);
    }

    protected abstract int getNumScreens();

    protected String getOsVersion() {
        return System.getProperty("os.version");
    }

    public PrinterJob getPrinterJob() {
        new Exception().printStackTrace();
        return null;
    }

    protected String getPropString(String string) {
        return string;
    }

    public synchronized GraphicsDevice[] getScreenDevices() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        if (graphicsDeviceArray == null) {
            int n = this.getNumScreens();
            graphicsDeviceArray = new GraphicsDevice[n];
            int n2 = 0;
            while (n2 < n) {
                graphicsDeviceArray[n2] = this.makeScreenDevice(n2);
                ++n2;
            }
            this.screens = graphicsDeviceArray;
        }
        return graphicsDeviceArray;
    }

    protected void initCompositeFonts() {
        if (!this.platformReady()) {
            return;
        }
        this.initTerminalNames();
        Object[] objectArray = this.terminalNames.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            Integer n2 = (Integer)this.terminalNames.get(objectArray[n]);
            int n3 = n2;
            String[] stringArray = new String[n3];
            int[] nArray = new int[n3];
            int[] nArray2 = new int[]{};
            int n4 = 0;
            while (n4 < n3) {
                stringArray[n4] = this.parseFamilyNameProperty(this.fprops.getProperty(String.valueOf(string) + "." + n4));
                nArray2 = this.appendExclusions(string, n4, nArray2);
                nArray[n4] = nArray2.length;
                ++n4;
            }
            NativeFontWrapper.registerCompositeFont(string, stringArray, nArray2, nArray);
            ++n;
        }
        this.terminalNames.put("default", new Integer(0));
    }

    private void initTerminalNames() {
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        this.terminalNames = new TreeMap();
        String string = "Serif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "SansSerif";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Monospaced";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "Dialog";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        string = "DialogInput";
        treeMap.put(string.toLowerCase(Locale.ENGLISH), string);
        Object[] objectArray = this.fprops.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            String string2;
            String string3;
            String string4 = (String)objectArray[n];
            int n2 = string4.indexOf(".");
            if (n2 == -1) {
                n2 = string4.length();
            }
            if (treeMap.containsKey(string3 = string4.substring(0, n2)) && (n2 = string4.lastIndexOf(".")) != -1 && !this.terminalNames.containsKey(string2 = string4.substring(0, n2)) && this.fprops.containsKey(String.valueOf(string2) + ".0")) {
                int n3 = 0;
                while (this.fprops.containsKey(String.valueOf(string2) + "." + n3)) {
                    ++n3;
                }
                if (n3 != 0) {
                    this.terminalNames.put(string2, new Integer(n3));
                    int n4 = 0;
                    while (n4 < n3) {
                        String string5 = this.getFontPropertyFD(this.fprops.getProperty(String.valueOf(string2) + "." + n4));
                        String string6 = this.getFileNameFromPlatformName(string5);
                        if (string6 == null) {
                            System.err.println("Font specified in font.properties not found [" + string5 + "]");
                            this.loadFonts();
                            break;
                        }
                        if (!treeMap2.containsKey(string6)) {
                            treeMap2.put(string6, null);
                            this.registerFontFile(string6, string5);
                        }
                        ++n4;
                    }
                }
            }
            ++n;
        }
    }

    private void initializeProps() {
        if (!this.platformReady()) {
            return;
        }
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        if (string2 == null) {
            throw new Error("java.home property not set");
        }
        String string3 = System.getProperty("user.language", "en");
        String string4 = System.getProperty("user.region");
        String string5 = System.getProperty("file.encoding");
        String string6 = CharacterEncoding.aliasName(string5);
        if (string6 == null) {
            string6 = string5;
        }
        try {
            File file = null;
            if (string4 != null) {
                file = this.tryOpeningFontProp(file, string, string3, String.valueOf(string4) + "_" + string6);
                file = this.tryOpeningFontProp(file, string2, string3, String.valueOf(string4) + "_" + string6);
                file = this.tryOpeningFontProp(file, string, string3, string4);
                file = this.tryOpeningFontProp(file, string2, string3, string4);
            }
            file = this.tryOpeningFontProp(file, string, string3, string6);
            file = this.tryOpeningFontProp(file, string2, string3, string6);
            file = this.tryOpeningFontProp(file, string, string3, null);
            file = this.tryOpeningFontProp(file, string2, string3, null);
            file = this.tryOpeningFontProp(file, string, string6, null);
            file = this.tryOpeningFontProp(file, string2, string6, null);
            file = this.tryOpeningFontProp(file, string, null, null);
            if ((file = this.tryOpeningFontProp(file, string2, null, null)) != null) {
                Properties properties = new Properties();
                properties.put("serif.0", "unknown");
                properties.put("sansserif.0", "unknown");
                properties.put("monospaced.0", "unknown");
                properties.put("dialog.0", "unknown");
                properties.put("dialoginput.0", "unknown");
                properties.put("default.0", "sansserif");
                properties.put("timesroman.0", "serif");
                properties.put("helvetica.0", "sansserif");
                properties.put("courier.0", "monospaced");
                properties.put("zapfdingbats.0", "unknown");
                this.fprops = new Properties(properties);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
                this.fprops.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
        }
        catch (Exception exception) {}
    }

    protected synchronized void loadFonts() {
        if (this.loadedAllFonts) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (SunGraphicsEnvironment.this.fontPath == null) {
                    SunGraphicsEnvironment.this.fontPath = System.getProperty("java.awt.fonts");
                    if (SunGraphicsEnvironment.this.fontPath.length() == 0) {
                        SunGraphicsEnvironment.this.fontPath = NativeFontWrapper.getFontPath();
                        SunGraphicsEnvironment.this.appendJavaDefaultFontPath();
                        SunGraphicsEnvironment.this.loadNativeFonts = true;
                    }
                }
                boolean bl = SunGraphicsEnvironment.this.registerFonts(SunGraphicsEnvironment.this.fontPath);
                boolean bl2 = false;
                if (SunGraphicsEnvironment.this.loadNativeFonts) {
                    bl2 = SunGraphicsEnvironment.this.registerNativeFonts();
                }
                if (!bl && !bl2) {
                    System.out.println("\nNo fonts were found in '" + SunGraphicsEnvironment.this.fontPath + "'.\n");
                    System.exit(2);
                }
                SunGraphicsEnvironment.this.loadedAllFonts = true;
                return null;
            }
        });
    }

    protected abstract GraphicsDevice makeScreenDevice(int var1);

    public String mapFamilyName(String string, int n) {
        String string2;
        String string3 = string.toLowerCase();
        if (this.mapFamilyCache != null && (string2 = (String)this.mapFamilyCache.get(String.valueOf(string3) + SunGraphicsEnvironment.styleStr(n))) != null) {
            return string2;
        }
        if (this.fprops == null) {
            return string;
        }
        string2 = this.fprops.getProperty("alias." + string3);
        if (string2 == null) {
            string2 = string;
        }
        Object[] objectArray = this.fprops.keySet().toArray();
        int n2 = objectArray.length;
        int n3 = 0;
        do {
            String string4;
            if (this.terminalNames.containsKey(String.valueOf(string4 = string2.toLowerCase()) + "." + SunGraphicsEnvironment.styleStr(n))) {
                string2 = String.valueOf(string4) + "." + SunGraphicsEnvironment.styleStr(n);
                break;
            }
            if (n == 0 && this.terminalNames.containsKey(string4)) break;
            String string5 = String.valueOf(string4) + "." + SunGraphicsEnvironment.styleStr(n) + ".0";
            String string6 = this.fprops.getProperty(string5);
            if (string6 == null) {
                string5 = String.valueOf(string4) + ".0";
                string6 = this.fprops.getProperty(string5);
            }
            if (string6 == null) break;
            string2 = this.parseFamilyNameProperty(string6);
        } while (++n3 < n2);
        if (this.mapFamilyCache == null) {
            this.mapFamilyCache = new Hashtable(5, 0.9f);
        }
        if (this.mapFamilyCache != null) {
            this.mapFamilyCache.put(String.valueOf(string3) + SunGraphicsEnvironment.styleStr(n), string2);
        }
        return string2;
    }

    protected String parseFamilyNameProperty(String string) {
        int n = string.indexOf(",");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    protected boolean platformReady() {
        return true;
    }

    private void registerFontFile(String string, String string2) {
        int n;
        if (this.registeredFonts.containsKey(string)) {
            return;
        }
        if (new TTFilter().accept(null, string)) {
            n = 0;
        } else if (new T1Filter().accept(null, string)) {
            n = 1;
        } else if (new T2KFilter().accept(null, string)) {
            n = 2;
        } else {
            this.registerNative(string);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fontPath, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                File file = new File(string3, string);
                if (!file.canRead()) continue;
                Vector vector = new Vector(20, 10);
                Vector vector2 = new Vector(20, 10);
                vector2.addElement(string2);
                vector.addElement(file.getAbsolutePath());
                this.registeredFonts.put(string, file.getAbsolutePath());
                NativeFontWrapper.registerFonts(vector, vector.size(), vector2, n);
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
    }

    protected void registerFontPath(String string) {
    }

    private boolean registerFonts(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.registerFontPath(string2);
                bl |= this.addPathFonts(string2, new TTFilter(), 0);
                bl |= this.addPathFonts(string2, new T1Filter(), 1);
                bl |= this.addPathFonts(string2, new T2KFilter(), 2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        return bl;
    }

    protected void registerNative(String string) {
    }

    protected boolean registerNativeFonts() {
        return false;
    }

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    private File tryOpeningFontProp(File file, String string, String string2, String string3) {
        File file2;
        if (file != null) {
            return file;
        }
        String string4 = String.valueOf(string) + File.separator + "lib" + File.separator + "font.properties";
        if (string2 != null) {
            string4 = String.valueOf(string4) + "." + string2;
            if (string3 != null) {
                string4 = String.valueOf(string4) + "_" + string3;
            }
        }
        if ((file2 = new File(String.valueOf(string4) + "." + this.osVersion)) != null && file2.canRead()) {
            return file2;
        }
        file2 = new File(string4);
        if (file2 != null && file2.canRead()) {
            return file2;
        }
        return null;
    }

    protected class TTFilter
    implements FilenameFilter {
        protected TTFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".ttf") || string.endsWith(".TTF") || string.endsWith(".ttc") || string.endsWith(".TTC");
        }
    }

    protected class T2KFilter
    implements FilenameFilter {
        protected T2KFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".t2k") || string.endsWith(".T2K");
        }
    }

    protected class T1Filter
    implements FilenameFilter {
        protected T1Filter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith(".ps") || string.endsWith(".PS") || string.endsWith(".pfb") || string.endsWith(".PFB") || string.endsWith(".pfa") || string.endsWith(".PFA");
        }
    }
}

