/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

public class JPEGQTable {
    private int[] quantval;
    private static final byte QTABLESIZE = 64;
    public static final JPEGQTable StdLuminance = new JPEGQTable();
    public static final JPEGQTable StdChrominance;

    static {
        int[] nArray = new int[]{16, 11, 12, 14, 12, 10, 16, 14, 13, 14, 18, 17, 16, 19, 24, 40, 26, 24, 22, 22, 24, 49, 35, 37, 29, 40, 58, 51, 61, 60, 57, 51, 56, 55, 64, 72, 92, 78, 64, 68, 87, 69, 55, 56, 80, 109, 81, 87, 95, 98, 103, 104, 103, 62, 77, 113, 121, 112, 100, 120, 92, 101, 103, 99};
        JPEGQTable.StdLuminance.quantval = nArray;
        StdChrominance = new JPEGQTable();
        nArray = new int[]{17, 18, 18, 24, 21, 24, 47, 26, 26, 47, 99, 66, 56, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};
        JPEGQTable.StdChrominance.quantval = nArray;
    }

    private JPEGQTable() {
        this.quantval = new int[64];
    }

    public JPEGQTable(int[] nArray) {
        if (nArray.length != 64) {
            throw new IllegalArgumentException("Quantization table is the wrong size.");
        }
        this.quantval = new int[64];
        System.arraycopy(nArray, 0, this.quantval, 0, 64);
    }

    public JPEGQTable getScaledInstance(float f, boolean bl) {
        long l = bl ? 255L : 32767L;
        int[] nArray = new int[64];
        int n = 0;
        while (n < 64) {
            long l2 = (long)((double)((float)this.quantval[n] * f) + 0.5);
            if (l2 <= 0L) {
                l2 = 1L;
            }
            if (l2 > l) {
                l2 = l;
            }
            nArray[n] = (int)l2;
            ++n;
        }
        return new JPEGQTable(nArray);
    }

    public int[] getTable() {
        int[] nArray = new int[64];
        System.arraycopy(this.quantval, 0, nArray, 0, 64);
        return nArray;
    }
}

