/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class JarURLConnection
extends URLConnection {
    private URL jarFileURL;
    private String entryName;
    protected URLConnection jarFileURLConnection;

    protected JarURLConnection(URL uRL) throws MalformedURLException {
        super(uRL);
        this.parseSpecs(uRL);
    }

    public Attributes getAttributes() throws IOException {
        JarEntry jarEntry = this.getJarEntry();
        return jarEntry != null ? jarEntry.getAttributes() : null;
    }

    public Certificate[] getCertificates() throws IOException {
        JarEntry jarEntry = this.getJarEntry();
        return jarEntry != null ? jarEntry.getCertificates() : null;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public JarEntry getJarEntry() throws IOException {
        return this.getJarFile().getJarEntry(this.entryName);
    }

    public abstract JarFile getJarFile() throws IOException;

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        return manifest != null ? manifest.getMainAttributes() : null;
    }

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    private void parseSpecs(URL uRL) throws MalformedURLException {
        String string = uRL.getFile();
        int n = string.indexOf(33);
        if (n == -1) {
            throw new MalformedURLException("no ! found in url spec:" + string);
        }
        this.jarFileURL = new URL(string.substring(0, n++));
        this.entryName = null;
        if (++n != string.length()) {
            this.entryName = string.substring(n, string.length());
        }
    }
}

