/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketPermissionCollection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import sun.security.action.GetBooleanAction;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final int CONNECT = 1;
    private static final int LISTEN = 2;
    private static final int ACCEPT = 4;
    private static final int RESOLVE = 8;
    private static final int NONE = 0;
    private static final int ALL = 15;
    private static final int PORT_MIN = 0;
    private static final int PORT_MAX = 65535;
    private static final int PRIV_PORT_MAX = 1023;
    private transient int mask;
    private String actions;
    private transient String cname;
    private transient InetAddress[] addresses;
    private transient boolean wildcard;
    private transient boolean init_with_ip;
    private transient boolean invalid;
    private transient int[] portrange;
    private static boolean trustProxy;

    static {
        Boolean bl = (Boolean)AccessController.doPrivileged(new GetBooleanAction("trustProxy"));
        trustProxy = bl;
    }

    SocketPermission(String string, int n) {
        super(SocketPermission.getHost(string));
        this.init(string, n);
    }

    public SocketPermission(String string, String string2) {
        super(SocketPermission.getHost(string));
        this.init(string, SocketPermission.getMask(string2));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)object;
        if (this.mask != socketPermission.mask) {
            return false;
        }
        if (this.portrange[0] != socketPermission.portrange[0] || this.portrange[1] != socketPermission.portrange[1]) {
            return false;
        }
        if (this.getName().equalsIgnoreCase(socketPermission.getName())) {
            return true;
        }
        try {
            this.getCanonName();
            socketPermission.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.invalid || socketPermission.invalid) {
            return false;
        }
        if (this.cname != null) {
            return this.cname.equalsIgnoreCase(socketPermission.cname);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = SocketPermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuffer.append("connect");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("listen");
        }
        if ((n & 4) == 4) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("accept");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("resolve");
        }
        return stringBuffer.toString();
    }

    void getCanonName() throws UnknownHostException {
        if (this.cname != null || this.invalid) {
            return;
        }
        try {
            if (this.addresses == null) {
                this.getIP();
            }
            this.cname = this.init_with_ip ? this.addresses[0].getHostName(false).toLowerCase() : InetAddress.getByName(this.addresses[0].getHostAddress()).getHostName(false).toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
    }

    private static String getHost(String string) {
        if (string.equals("")) {
            return "localhost";
        }
        return string;
    }

    void getIP() throws UnknownHostException {
        if (this.addresses != null || this.wildcard || this.invalid) {
            return;
        }
        try {
            int n = this.getName().indexOf(":");
            String string = n == -1 ? this.getName() : this.getName().substring(0, n);
            this.addresses = new InetAddress[]{InetAddress.getAllByName0(string, false)[0]};
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
    }

    int getMask() {
        return this.mask;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        if (var0 == null) {
            throw new NullPointerException("action can't be null");
        }
        if (var0.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        var1_1 = 0;
        if (var0 == null) {
            return var1_1;
        }
        var2_2 = var0.toCharArray();
        var3_3 = var2_2.length - 1;
        if (var3_3 >= 0) ** GOTO lbl44
        return var1_1;
        {
            --var3_3;
            do {
                if (var3_3 != -1 && ((var4_4 = var2_2[var3_3]) == ' ' || var4_4 == '\r' || var4_4 == '\n' || var4_4 == '\f' || var4_4 == '\t')) continue block4;
                if (!(var3_3 < 6 || var2_2[var3_3 - 6] != 'c' && var2_2[var3_3 - 6] != 'C' || var2_2[var3_3 - 5] != 'o' && var2_2[var3_3 - 5] != 'O' || var2_2[var3_3 - 4] != 'n' && var2_2[var3_3 - 4] != 'N' || var2_2[var3_3 - 3] != 'n' && var2_2[var3_3 - 3] != 'N' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'c' && var2_2[var3_3 - 1] != 'C' || var2_2[var3_3] != 't' && var2_2[var3_3] != 'T')) {
                    var5_5 = 7;
                    var1_1 |= 1;
                } else if (!(var3_3 < 6 || var2_2[var3_3 - 6] != 'r' && var2_2[var3_3 - 6] != 'R' || var2_2[var3_3 - 5] != 'e' && var2_2[var3_3 - 5] != 'E' || var2_2[var3_3 - 4] != 's' && var2_2[var3_3 - 4] != 'S' || var2_2[var3_3 - 3] != 'o' && var2_2[var3_3 - 3] != 'O' || var2_2[var3_3 - 2] != 'l' && var2_2[var3_3 - 2] != 'L' || var2_2[var3_3 - 1] != 'v' && var2_2[var3_3 - 1] != 'V' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 7;
                    var1_1 |= 8;
                } else if (!(var3_3 < 5 || var2_2[var3_3 - 5] != 'l' && var2_2[var3_3 - 5] != 'L' || var2_2[var3_3 - 4] != 'i' && var2_2[var3_3 - 4] != 'I' || var2_2[var3_3 - 3] != 's' && var2_2[var3_3 - 3] != 'S' || var2_2[var3_3 - 2] != 't' && var2_2[var3_3 - 2] != 'T' || var2_2[var3_3 - 1] != 'e' && var2_2[var3_3 - 1] != 'E' || var2_2[var3_3] != 'n' && var2_2[var3_3] != 'N')) {
                    var5_5 = 6;
                    var1_1 |= 2;
                } else if (!(var3_3 < 5 || var2_2[var3_3 - 5] != 'a' && var2_2[var3_3 - 5] != 'A' || var2_2[var3_3 - 4] != 'c' && var2_2[var3_3 - 4] != 'C' || var2_2[var3_3 - 3] != 'c' && var2_2[var3_3 - 3] != 'C' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'p' && var2_2[var3_3 - 1] != 'P' || var2_2[var3_3] != 't' && var2_2[var3_3] != 'T')) {
                    var5_5 = 6;
                    var1_1 |= 4;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var6_6 = false;
                while (var3_3 >= var5_5 && !var6_6) {
                    switch (var2_2[var3_3 - var5_5]) {
                        case ',': {
                            var6_6 = true;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                    }
                    --var3_3;
                }
                var3_3 -= var5_5;
lbl44:
                // 2 sources

            } while (var3_3 != -1);
        }
        return var1_1;
    }

    public int hashCode() {
        if (this.init_with_ip || this.wildcard) {
            return this.getName().hashCode();
        }
        try {
            this.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (this.invalid || this.cname == null) {
            return this.getName().hashCode();
        }
        return this.cname.hashCode();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        return (this.mask & socketPermission.mask) == socketPermission.mask && this.impliesIgnoreMask(socketPermission);
    }

    boolean impliesIgnoreMask(SocketPermission socketPermission) {
        if ((socketPermission.mask & 8) != socketPermission.mask && (socketPermission.portrange[0] < this.portrange[0] || socketPermission.portrange[1] > this.portrange[1])) {
            return false;
        }
        if (this.wildcard && this.getName().equals("*")) {
            return true;
        }
        if (this.invalid || socketPermission.invalid) {
            if (!trustProxy) {
                return false;
            }
            String string = this.getName();
            String string2 = socketPermission.getName();
            int n = string.indexOf(58);
            if (n != -1) {
                string = string.substring(0, n);
            }
            if ((n = string2.indexOf(58)) != -1) {
                string2 = string2.substring(0, n);
            }
            if (string == null) {
                return false;
            }
            return string.equalsIgnoreCase(string2);
        }
        try {
            if (this.init_with_ip) {
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.init_with_ip) {
                    return this.addresses[0].equals(socketPermission.addresses[0]);
                }
                if (socketPermission.addresses == null) {
                    socketPermission.getIP();
                }
                int n = 0;
                while (n < socketPermission.addresses.length) {
                    if (this.addresses[0].equals(socketPermission.addresses[n])) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            if (this.wildcard || socketPermission.wildcard) {
                if (this.wildcard && socketPermission.wildcard) {
                    return socketPermission.cname.endsWith(this.cname);
                }
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.cname == null) {
                    socketPermission.getCanonName();
                }
                return socketPermission.cname.endsWith(this.cname);
            }
            if (this.addresses == null) {
                this.getIP();
            }
            if (socketPermission.addresses == null) {
                socketPermission.getIP();
            }
            int n = 0;
            while (n < this.addresses.length) {
                int n2 = 0;
                while (n2 < socketPermission.addresses.length) {
                    if (this.addresses[n].equals(socketPermission.addresses[n2])) {
                        return true;
                    }
                    ++n2;
                }
                ++n;
            }
            if (this.cname == null) {
                this.getCanonName();
            }
            if (socketPermission.cname == null) {
                socketPermission.getCanonName();
            }
            return this.cname.equalsIgnoreCase(socketPermission.cname);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    private void init(String string, int n) {
        block13: {
            if ((string = SocketPermission.getHost(string)) == null) {
                throw new NullPointerException("host can't be null");
            }
            if ((n & 0xF) != n) {
                throw new IllegalArgumentException("invalid actions mask");
            }
            this.mask = n | 8;
            int n2 = string.indexOf(58);
            if (n2 != -1) {
                String string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                try {
                    this.portrange = this.parsePort(string2);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid port range: " + string2);
                }
            } else {
                int[] nArray = new int[2];
                nArray[1] = 65535;
                this.portrange = nArray;
            }
            if (string.startsWith("*")) {
                this.wildcard = true;
                if (string.equals("*")) {
                    this.cname = "";
                } else if (string.startsWith("*.")) {
                    this.cname = string.substring(1).toLowerCase();
                } else {
                    throw new IllegalArgumentException("invalid host wildcard specification");
                }
                return;
            }
            if (!this.isDottedIP(string)) break block13;
            try {
                this.addresses = new InetAddress[]{InetAddress.getByName(string)};
                this.init_with_ip = true;
            }
            catch (UnknownHostException unknownHostException) {
                this.invalid = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isDottedIP(String var1_1) {
        var2_2 = var1_1.toCharArray();
        var3_3 = var2_2.length - 1;
        var4_4 = 0;
        if (var3_3 <= -1 || var2_2[0] != '.') ** GOTO lbl30
        return false;
lbl-1000:
        // 1 sources

        {
            var5_5 = var2_2[var3_3];
            if (var3_3 < 2) {
                var7_7 = 46;
                var6_6 = var3_3 == 1 ? var2_2[0] : 46;
                var3_3 = -1;
            } else {
                var6_6 = var2_2[var3_3 - 1];
                if (var6_6 == 46) {
                    var7_7 = 46;
                    var3_3 -= 2;
                } else {
                    var7_7 = var2_2[var3_3 - 2];
                    if (var7_7 == 46) {
                        var3_3 -= 3;
                    } else if (var3_3 - 3 != -1) {
                        if (var2_2[var3_3 - 3] != '.') {
                            return false;
                        }
                        var3_3 -= 4;
                    } else {
                        var3_3 -= 3;
                    }
                }
            }
            if (var5_5 < '0' || var5_5 > '9' || var6_6 < 48 && var6_6 != 46 || var6_6 > 57 || var7_7 < 48 && var7_7 != 46 || var7_7 > 50 || var7_7 == 50 && (var6_6 > 53 || var6_6 == 53 && var5_5 > '5')) {
                return false;
            }
            ++var4_4;
lbl30:
            // 2 sources

            ** while (var3_3 != -1)
        }
lbl31:
        // 1 sources

        return var4_4 == 4;
    }

    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }

    private int[] parsePort(String string) throws Exception {
        if (string == null || string.equals("") || string.equals("*")) {
            int[] nArray = new int[2];
            nArray[1] = 65535;
            return nArray;
        }
        int n = string.indexOf(45);
        if (n == -1) {
            int n2 = Integer.parseInt(string);
            return new int[]{n2, n2};
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n3 = string2.equals("") ? 0 : Integer.parseInt(string2);
        int n4 = string3.equals("") ? 65535 : Integer.parseInt(string3);
        if (n4 < n3) {
            throw new IllegalArgumentException("invalid port range");
        }
        return new int[]{n3, n4};
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), SocketPermission.getMask(this.actions));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }
}

