/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;

public final class MarshalledObject
implements Serializable {
    private byte[] objBytes = null;
    private byte[] locBytes = null;
    private int hash;
    private static final long serialVersionUID = 8988374069173025854L;

    public MarshalledObject(Object object) throws IOException {
        if (object == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        MarshalledObjectOutputStream marshalledObjectOutputStream = new MarshalledObjectOutputStream(byteArrayOutputStream, byteArrayOutputStream2);
        marshalledObjectOutputStream.writeObject(object);
        marshalledObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        this.locBytes = marshalledObjectOutputStream.hadAnnotations() ? byteArrayOutputStream2.toByteArray() : null;
        int n = 0;
        int n2 = 0;
        while (n2 < this.objBytes.length) {
            n = 31 * n + this.objBytes[n2];
            ++n2;
        }
        this.hash = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof MarshalledObject) {
            MarshalledObject marshalledObject = (MarshalledObject)object;
            if (this.objBytes == null || marshalledObject.objBytes == null) {
                return this.objBytes == marshalledObject.objBytes;
            }
            if (this.objBytes.length != marshalledObject.objBytes.length) {
                return false;
            }
            int n = 0;
            while (n < this.objBytes.length) {
                if (this.objBytes[n] != marshalledObject.objBytes[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objBytes);
        ByteArrayInputStream byteArrayInputStream2 = this.locBytes == null ? null : new ByteArrayInputStream(this.locBytes);
        MarshalledObjectInputStream marshalledObjectInputStream = new MarshalledObjectInputStream(byteArrayInputStream, byteArrayInputStream2);
        return marshalledObjectInputStream.readObject();
    }

    public int hashCode() {
        return this.hash;
    }

    private static class MarshalledObjectOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        public MarshalledObjectOutputStream(OutputStream outputStream, OutputStream outputStream2) throws IOException {
            super(outputStream);
            this.useProtocolVersion(2);
            this.locOut = new ObjectOutputStream(outputStream2);
            this.hadAnnotations = false;
        }

        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }

        public boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        protected void writeLocation(String string) throws IOException {
            this.hadAnnotations |= string != null;
            this.locOut.writeObject(string);
        }
    }

    private static class MarshalledObjectInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledObjectInputStream(InputStream inputStream, InputStream inputStream2) throws IOException {
            super(inputStream);
            this.locIn = inputStream2 == null ? null : new ObjectInputStream(inputStream2);
        }

        protected Object readLocation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : this.locIn.readObject();
        }
    }
}

