/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuItemUI";
    private KeyStroke accelerator;
    static /* synthetic */ Class class$javax$swing$event$MenuDragMouseListener;
    static /* synthetic */ Class class$javax$swing$event$MenuKeyListener;

    public JMenuItem() {
        this(null, null);
        this.setRequestFocusEnabled(false);
    }

    public JMenuItem(String string) {
        this(string, null);
    }

    public JMenuItem(String string, int n) {
        this.setModel(new DefaultButtonModel());
        this.init(string, null);
        this.setMnemonic(n);
    }

    public JMenuItem(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
    }

    public JMenuItem(Icon icon) {
        this(null, icon);
        this.setRequestFocusEnabled(false);
    }

    public void addMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.add(class$javax$swing$event$MenuDragMouseListener != null ? class$javax$swing$event$MenuDragMouseListener : (class$javax$swing$event$MenuDragMouseListener = JMenuItem.class$("javax.swing.event.MenuDragMouseListener")), menuDragMouseListener);
    }

    public void addMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.add(class$javax$swing$event$MenuKeyListener != null ? class$javax$swing$event$MenuKeyListener : (class$javax$swing$event$MenuKeyListener = JMenuItem.class$("javax.swing.event.MenuKeyListener")), menuKeyListener);
    }

    boolean alwaysOnTop() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireMenuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener != null ? class$javax$swing$event$MenuDragMouseListener : JMenuItem.class$("javax.swing.event.MenuDragMouseListener"))) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseDragged(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener != null ? class$javax$swing$event$MenuDragMouseListener : JMenuItem.class$("javax.swing.event.MenuDragMouseListener"))) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseEntered(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener != null ? class$javax$swing$event$MenuDragMouseListener : JMenuItem.class$("javax.swing.event.MenuDragMouseListener"))) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseExited(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuDragMouseListener != null ? class$javax$swing$event$MenuDragMouseListener : JMenuItem.class$("javax.swing.event.MenuDragMouseListener"))) {
                ((MenuDragMouseListener)objectArray[n + 1]).menuDragMouseReleased(menuDragMouseEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuKeyPressed(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuKeyListener != null ? class$javax$swing$event$MenuKeyListener : JMenuItem.class$("javax.swing.event.MenuKeyListener"))) {
                ((MenuKeyListener)objectArray[n + 1]).menuKeyPressed(menuKeyEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuKeyReleased(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuKeyListener != null ? class$javax$swing$event$MenuKeyListener : JMenuItem.class$("javax.swing.event.MenuKeyListener"))) {
                ((MenuKeyListener)objectArray[n + 1]).menuKeyReleased(menuKeyEvent);
            }
            n -= 2;
        }
    }

    protected void fireMenuKeyTyped(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$MenuKeyListener != null ? class$javax$swing$event$MenuKeyListener : JMenuItem.class$("javax.swing.event.MenuKeyListener"))) {
                ((MenuKeyListener)objectArray[n + 1]).menuKeyTyped(menuKeyEvent);
            }
            n -= 2;
        }
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuItem();
        }
        return this.accessibleContext;
    }

    public Component getComponent() {
        return this;
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void init(String string, Icon icon) {
        if (string != null) {
            this.setText(string);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.addFocusListener(new MenuItemFocusListener());
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setHorizontalTextPosition(11);
        this.setHorizontalAlignment(10);
        this.updateUI();
    }

    public boolean isArmed() {
        ButtonModel buttonModel = this.getModel();
        return buttonModel.isArmed();
    }

    public void menuSelectionChanged(boolean bl) {
        this.setArmed(bl);
    }

    protected String paramString() {
        return super.paramString();
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        this.processMenuKeyEvent(new MenuKeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), menuElementArray, menuSelectionManager));
    }

    public void processMenuDragMouseEvent(MenuDragMouseEvent menuDragMouseEvent) {
        switch (menuDragMouseEvent.getID()) {
            case 504: {
                this.fireMenuDragMouseEntered(menuDragMouseEvent);
                break;
            }
            case 505: {
                this.fireMenuDragMouseExited(menuDragMouseEvent);
                break;
            }
            case 506: {
                this.fireMenuDragMouseDragged(menuDragMouseEvent);
                break;
            }
            case 502: {
                this.fireMenuDragMouseReleased(menuDragMouseEvent);
                break;
            }
        }
    }

    public void processMenuKeyEvent(MenuKeyEvent menuKeyEvent) {
        switch (menuKeyEvent.getID()) {
            case 401: {
                this.fireMenuKeyPressed(menuKeyEvent);
                break;
            }
            case 402: {
                this.fireMenuKeyReleased(menuKeyEvent);
                break;
            }
            case 400: {
                this.fireMenuKeyTyped(menuKeyEvent);
                break;
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        this.processMenuDragMouseEvent(new MenuDragMouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), menuElementArray, menuSelectionManager));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getUIClassID().equals(uiClassID)) {
            this.updateUI();
        }
    }

    public void removeMenuDragMouseListener(MenuDragMouseListener menuDragMouseListener) {
        this.listenerList.remove(class$javax$swing$event$MenuDragMouseListener != null ? class$javax$swing$event$MenuDragMouseListener : (class$javax$swing$event$MenuDragMouseListener = JMenuItem.class$("javax.swing.event.MenuDragMouseListener")), menuDragMouseListener);
    }

    public void removeMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.remove(class$javax$swing$event$MenuKeyListener != null ? class$javax$swing$event$MenuKeyListener : (class$javax$swing$event$MenuKeyListener = JMenuItem.class$("javax.swing.event.MenuKeyListener")), menuKeyListener);
    }

    public void setAccelerator(KeyStroke keyStroke) {
        KeyStroke keyStroke2 = this.accelerator;
        if (keyStroke2 != null) {
            this.unregisterKeyboardAction(keyStroke2);
        }
        if (keyStroke != null) {
            this.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    JMenuItem.this.doClick();
                }
            }, keyStroke, 2);
        }
        this.accelerator = keyStroke;
        this.firePropertyChange("accelerator", keyStroke2, this.accelerator);
    }

    public void setArmed(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isArmed();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ARMED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ARMED, null);
            }
        }
        if (buttonModel.isArmed() != bl) {
            buttonModel.setArmed(bl);
        }
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.setArmed(false);
        }
        super.setEnabled(bl);
    }

    public void setUI(MenuItemUI menuItemUI) {
        super.setUI(menuItemUI);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private static class MenuItemFocusListener
    implements FocusListener,
    Serializable {
        MenuItemFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            JMenuItem jMenuItem = (JMenuItem)focusEvent.getSource();
            if (jMenuItem.isFocusPainted()) {
                jMenuItem.repaint();
            }
        }
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        AccessibleJMenuItem() {
            super(JMenuItem.this);
            JMenuItem.this.addChangeListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }
    }
}

