/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.peer.FramePeer;
import sun.awt.im.InputMethodManager;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WImage;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

class WFramePeer
extends WWindowPeer
implements FramePeer {
    WFramePeer(Frame frame) {
        super(frame);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    native void create(WComponentPeer var1);

    public native int getState();

    private static native int getSysIconHeight();

    private static native int getSysIconWidth();

    void initialize() {
        super.initialize();
        Frame frame = (Frame)this.target;
        if (frame.getTitle() != null) {
            this.setTitle(frame.getTitle());
        }
        this.setResizable(frame.isResizable());
        Image image = frame.getIconImage();
        if (image != null) {
            this.setIconImage(image);
        }
    }

    public Dimension minimumSize() {
        int n = ((Frame)this.target).getMenuBar() != null ? 45 : 30;
        return new Dimension(30, n);
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }

    native void pSetIMMOption(String var1);

    public synchronized native void reshape(int var1, int var2, int var3, int var4);

    public void setIconImage(Image image) {
        Object object;
        int n = WFramePeer.getSysIconWidth();
        int n2 = WFramePeer.getSysIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        if (image instanceof WImage) {
            object = ((WImage)image).getImageRep();
            ((ImageRepresentation)object).reconstruct(32);
        }
        graphics.drawImage(image, 0, 0, n, n2, null);
        object = bufferedImage.getRaster();
        DataBuffer dataBuffer = ((Raster)object).getDataBuffer();
        int[] nArray = ((DataBufferInt)dataBuffer).getData();
        int n3 = ((Raster)object).getWidth();
        if (object instanceof IntegerComponentRaster) {
            n3 = ((IntegerComponentRaster)object).getScanlineStride();
        }
        this.setIconImageFromIntRasterData(((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), n3, ((Raster)object).getWidth(), ((Raster)object).getHeight());
    }

    private native void setIconImageFromIntRasterData(int[] var1, int var2, int var3, int var4);

    public void setMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = (WMenuBarPeer)WToolkit.targetToPeer(menuBar);
        this.setMenuBar0(wMenuBarPeer);
        this.updateInsets(this.insets_);
    }

    private native void setMenuBar0(WMenuBarPeer var1);

    public native void setState(int var1);
}

