/*
 * Decompiled with CFR 0.152.
 */
package sun.beanbox;

import java.beans.BeanInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.beanbox.DoOnBean;
import sun.beanbox.JarInfo;
import sun.beanbox.Manifest;
import sun.beanbox.MessageHeader;
import sun.beanbox.SimpleClassLoader;

public class JarLoader {
    private static boolean debug;
    private InputStream jarStream;
    private String jarName;
    private SimpleClassLoader loader;
    private static boolean warnedAboutNoBeans;

    public JarLoader(String string) throws FileNotFoundException {
        JarLoader.debug("(" + string + ")");
        this.jarName = string;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.jarStream = new BufferedInputStream(fileInputStream);
        this.loader = SimpleClassLoader.ourLoader;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    private String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        String string = URLConnection.guessContentTypeFromStream(inputStream);
        if (string == null) {
            inputStream.mark(10);
            int n = inputStream.read();
            int n2 = inputStream.read();
            inputStream.read();
            inputStream.read();
            inputStream.read();
            inputStream.read();
            inputStream.reset();
            if (n == 172 && n2 == 237) {
                string = "application/java-serialized-object";
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JarInfo loadJar() throws IOException {
        boolean bl;
        Vector<Object> vector;
        Vector<Object> vector2;
        Manifest manifest;
        block16: {
            ZipInputStream zipInputStream = null;
            manifest = null;
            vector2 = new Vector<Object>();
            vector = new Vector<Object>();
            byte[] byArray = new byte[1024];
            bl = true;
            try {
                try {
                    zipInputStream = new ZipInputStream(this.jarStream);
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        Object object;
                        int n;
                        bl = false;
                        String string = zipEntry.getName();
                        String string2 = null;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        while ((n = zipInputStream.read(byArray)) >= 0) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        if (Manifest.isManifestName(string)) {
                            string2 = "manifest/manifest";
                        }
                        if (string2 == null) {
                            object = new ByteArrayInputStream(byArray2);
                            string2 = this.guessContentTypeFromStream((InputStream)object);
                            ((InputStream)object).close();
                        }
                        if (string2 == null) {
                            string2 = "input-stream/input-stream";
                        }
                        if (string2.startsWith("application/java-serialized-object") || string2.startsWith("application/x-java-serialized-object")) {
                            this.loader.putLocalResource(string, byArray2, string2);
                            object = string.substring(0, string.length() - 4);
                            object = ((String)object).replace('/', '.');
                            vector.addElement(object);
                            continue;
                        }
                        if (string2.startsWith("application/java-vm") || string2.startsWith("application/x-java-vm")) {
                            this.loader.putClassResource(string, string2);
                            object = string.substring(0, string.length() - 6);
                            object = ((String)object).replace('/', '.');
                            this.loader.defineClassFromBytes((String)object, byArray2);
                            vector2.addElement(object);
                            continue;
                        }
                        if (string2.equals("manifest/manifest")) {
                            manifest = new Manifest(byArray2);
                            continue;
                        }
                        this.loader.putLocalResource(string, byArray2, string2);
                    }
                }
                catch (IOException iOException) {
                    JarLoader.debug("IOException loading archive: " + iOException);
                    throw iOException;
                }
                catch (Throwable throwable) {
                    JarLoader.debug("Caught " + throwable + " in loadit()");
                    throwable.printStackTrace();
                    throw new IOException("loadJar caught: " + throwable);
                }
                Object var8_16 = null;
                if (zipInputStream == null) break block16;
            }
            catch (Throwable throwable) {
                Object var8_17 = null;
                if (zipInputStream == null) throw throwable;
                try {
                    zipInputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            zipInputStream.close();
        }
        if (!bl) return this.createJarInfo(vector2, vector, manifest);
        throw new IOException("JAR file is corrupt or empty");
    }

    public static void loadJarDoOnBean(String string, DoOnBean doOnBean) throws IOException {
        JarLoader jarLoader = new JarLoader(string);
        JarInfo jarInfo = jarLoader.loadJar();
        if (jarInfo == null) {
            System.err.println("JAR file " + string + " did not load properly!");
            System.err.println("Check for error messages possibly regarding");
            System.err.println("problems defining classes");
            return;
        }
        if (jarInfo.getCount() == 0) {
            System.err.println("Jar file " + string + " didn't have any beans!");
            if (!warnedAboutNoBeans) {
                warnedAboutNoBeans = true;
                System.err.println("");
                System.err.println("Each jar file needs to contain a manifest file describing which entries are");
                System.err.println("beans.  You can should provide a suitable manifest when you create the jar.");
                System.err.println("");
            }
        }
        int n = 0;
        while (n < jarInfo.getCount()) {
            String string2 = jarInfo.getName(n);
            BeanInfo beanInfo = jarInfo.getBeanInfo(n);
            if (beanInfo != null) {
                doOnBean.action(jarInfo, beanInfo, string2);
            }
            ++n;
        }
    }

    private JarInfo createJarInfo(Vector vector, Vector vector2, Manifest manifest) {
        Object object;
        MessageHeader[] messageHeaderArray;
        Object object2;
        String[] stringArray;
        Hashtable<Object, Boolean> hashtable;
        Hashtable<MessageHeader[], Object> hashtable2 = new Hashtable<MessageHeader[], Object>();
        if (manifest == null) {
            hashtable = new Hashtable<Object, Boolean>();
            stringArray = vector.elements();
            while (stringArray.hasMoreElements()) {
                object2 = (String)stringArray.nextElement();
                hashtable.put(object2, new Boolean(false));
            }
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                messageHeaderArray = (String)object2.nextElement();
                hashtable.put(messageHeaderArray, new Boolean(true));
            }
        } else {
            hashtable = new Hashtable();
            stringArray = manifest.entries();
            while (stringArray.hasMoreElements()) {
                Object object3;
                object2 = (MessageHeader)stringArray.nextElement();
                messageHeaderArray = ((MessageHeader)object2).findValue("Name");
                object = ((MessageHeader)object2).findValue("Java-Bean");
                if (object == null || !((String)object).equalsIgnoreCase("True")) continue;
                boolean bl = true;
                if (messageHeaderArray.endsWith(".class")) {
                    bl = false;
                    object3 = messageHeaderArray.substring(0, messageHeaderArray.length() - 6);
                } else {
                    object3 = messageHeaderArray.endsWith(".ser") ? messageHeaderArray.substring(0, messageHeaderArray.length() - 4) : messageHeaderArray;
                }
                object3 = object3.replace('/', '.');
                hashtable.put(object3, new Boolean(bl));
                hashtable2.put((MessageHeader[])object3, object2);
            }
        }
        stringArray = new String[hashtable.size()];
        object2 = new boolean[hashtable.size()];
        messageHeaderArray = new MessageHeader[hashtable.size()];
        object = hashtable.keys();
        int n = 0;
        while (object.hasMoreElements()) {
            String string;
            stringArray[n] = string = (String)object.nextElement();
            object2[n] = (Boolean)hashtable.get(string);
            messageHeaderArray[n] = (MessageHeader)hashtable2.get(string);
            ++n;
        }
        return new JarInfo(this.jarName, this.loader, stringArray, (boolean[])object2, messageHeaderArray);
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("JarLoader:: " + string);
        }
    }
}

