/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.ole.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;

public class EncapsulatedEvent
extends EventObject {
    protected EventObject event;
    protected Method listenerMethod;
    protected Class listenerInterface;
    protected Object[] eventArgs;

    protected EncapsulatedEvent(Object object, EventObject eventObject, Method method, Object[] objectArray) {
        super(object);
        if (method == null || eventObject == null && objectArray == null) {
            throw new NullPointerException("Encapsulated Event constructor args");
        }
        if (eventObject == null && objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof EventObject) {
                    eventObject = (EventObject)objectArray[n];
                    break;
                }
                ++n;
            }
        }
        if (eventObject != null && eventObject instanceof EncapsulatedEvent) {
            EncapsulatedEvent encapsulatedEvent = (EncapsulatedEvent)eventObject;
            this.event = encapsulatedEvent.getEvent();
            method = encapsulatedEvent.getListenerMethod();
        } else {
            this.event = eventObject;
        }
        this.listenerMethod = method;
        this.listenerInterface = method.getDeclaringClass();
        if (eventObject != null) {
            if (objectArray == null) {
                objectArray = new Object[]{this.event};
            } else {
                int n = 0;
                while (n < objectArray.length && !eventObject.equals(objectArray[n])) {
                    ++n;
                }
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 1];
                    objectArray2[0] = this.event;
                    n = 0;
                    while (n < objectArray.length) {
                        objectArray2[n + 1] = objectArray[n];
                        ++n;
                    }
                }
            }
        }
        this.eventArgs = objectArray;
    }

    public EncapsulatedEvent(Object object, EventObject eventObject, Method method) {
        this(object, eventObject, method, null);
    }

    public EncapsulatedEvent(EventObject eventObject, Method method) {
        this(eventObject.getSource(), eventObject, method);
    }

    public EncapsulatedEvent(Object object, Method method, Object[] objectArray) {
        this(object, null, method, objectArray);
    }

    public EventObject getEvent() {
        return this.event;
    }

    public Class getEventClass() {
        if (this.event != null) {
            return this.event.getClass();
        }
        return null;
    }

    public String getEventClassName() {
        if (this.event != null) {
            return this.event.getClass().getName();
        }
        return null;
    }

    public Object getEventSource() {
        if (this.event != null) {
            return this.event.getSource();
        }
        return this.getSource();
    }

    public Method getListenerMethod() {
        return this.listenerMethod;
    }

    public String getListenerMethodName() {
        return this.listenerMethod.getName();
    }

    public Class getListenerInterface() {
        return this.listenerInterface;
    }

    public String getListenerInterfaceName() {
        return this.listenerInterface.getName();
    }

    public Object[] getEventArguments() {
        return this.eventArgs;
    }

    public void deliverEvent(EventListener eventListener) throws InvocationTargetException, IllegalAccessException {
        this.listenerMethod.invoke((Object)eventListener, this.eventArgs);
    }
}

