/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.plugin.AppletViewer;
import sun.plugin.panel.MessageHandler;

public class ConfigurationInfo {
    private static File theUserPropertiesFile;
    private Properties props;
    private boolean debugMode;
    private boolean javapluginEnabled;
    private boolean showConsole;
    private int jarCacheSize;
    private boolean useJIT = false;
    private String JITPath;
    private int networkMode;
    private String debugPort;
    private String[] installedJavaVersion;
    private String jdk;
    private boolean useDefaultProxy;
    private boolean useSameProxy;
    private String proxySettings;
    private String javaParms;
    private Vector activeCertsVector = new Vector();
    private Vector inactiveCertsVector = new Vector();
    private static final String networkKey = "appletviewer.security.mode";
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_HOST = 1;
    public static final int NETWORK_UNRESTRICTED = 2;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private MessageHandler mh = new MessageHandler("config");

    public ConfigurationInfo() {
        if (theUserPropertiesFile == null) {
            String string = File.separator;
            theUserPropertiesFile = new File(String.valueOf(System.getProperty("user.home")) + string + ".java" + string + "properties");
            new File(theUserPropertiesFile.getParent()).mkdirs();
        }
        this.reset();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void applyChanges() throws IOException {
        ((Hashtable)this.props).put("javaplugin.version", AppletViewer.theVersion);
        ((Hashtable)this.props).put("javaplugin.console", this.showConsole ? "true" : "false");
        ((Hashtable)this.props).put("javaplugin.jar.cache.size", String.valueOf(this.jarCacheSize));
        ((Hashtable)this.props).put("javaplugin.enabled", this.javapluginEnabled ? "true" : "false");
        if (this.networkMode == 0) {
            ((Hashtable)this.props).put(networkKey, "none");
        } else if (this.networkMode == 2) {
            ((Hashtable)this.props).put(networkKey, "unrestricted");
        } else {
            ((Hashtable)this.props).put(networkKey, "host");
        }
        if (this.debugMode) {
            ((Hashtable)this.props).put("javaplugin.debug.mode", "true");
            ((Hashtable)this.props).put("javaplugin.debug.port", this.debugPort);
        } else {
            ((Hashtable)this.props).put("javaplugin.debug.mode", "false");
        }
        if (this.useDefaultProxy) {
            ((Hashtable)this.props).put("javaplugin.proxy.usebrowsersettings", "true");
        } else {
            ((Hashtable)this.props).put("javaplugin.proxy.usebrowsersettings", "false");
        }
        if (this.proxySettings != null) {
            ((Hashtable)this.props).put("javaplugin.proxy.settings", this.proxySettings);
        } else {
            ((Hashtable)this.props).remove("javaplugin.proxy.settings");
        }
        if (this.useSameProxy) {
            ((Hashtable)this.props).put("javaplugin.proxy.forallprotocols", "true");
        } else {
            ((Hashtable)this.props).put("javaplugin.proxy.forallprotocols", "false");
        }
        if (this.jdk != null && this.jdk.length() > 0) {
            ((Hashtable)this.props).put("javaplugin.jre.path", this.jdk);
        } else {
            ((Hashtable)this.props).remove("javaplugin.jre.path");
        }
        if (this.javaParms != null && this.javaParms.length() > 0) {
            ((Hashtable)this.props).put("javaplugin.jre.params", this.javaParms);
        } else {
            ((Hashtable)this.props).remove("javaplugin.jre.params");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(theUserPropertiesFile);
        PrintWriter printWriter = new PrintWriter(fileOutputStream);
        printWriter.println(this.mh.getMessage("property_file_header"));
        printWriter.flush();
        this.props.save(fileOutputStream, "");
        fileOutputStream.close();
    }

    public void changeCertificatesToInactive(int n) {
        Object e = this.activeCertsVector.remove(n);
        this.inactiveCertsVector.addElement(e);
        this.firePropertyChange();
    }

    public void cleanInactiveCertificatesSet() {
        this.inactiveCertsVector.clear();
    }

    protected void firePropertyChange() {
        this.pcs.firePropertyChange(null, null, null);
    }

    public X509Certificate[] getActiveCertificatesSet() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.activeCertsVector.size()];
        return this.activeCertsVector.toArray(x509CertificateArray);
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public byte[][] getInactiveCertificatesSet() {
        byte[][] byArray = new byte[this.inactiveCertsVector.size()][];
        int n = 0;
        while (n < byArray.length) {
            X509Certificate x509Certificate = (X509Certificate)this.inactiveCertsVector.get(n);
            try {
                byArray[n] = x509Certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                certificateEncodingException.printStackTrace();
                byArray[n] = null;
            }
            ++n;
        }
        return byArray;
    }

    public String[] getInstalledJavaList() {
        return this.installedJavaVersion;
    }

    public String getJDK() {
        return this.jdk;
    }

    public String getJITPath() {
        return this.JITPath;
    }

    public String getJavaParms() {
        return this.javaParms;
    }

    public int getNetworkAccessLevel() {
        return this.networkMode;
    }

    public String getProxySettingsString() {
        return this.proxySettings;
    }

    public String[] getSupportedVersionList() {
        String[] stringArray = new String[]{"1.1", "1.2"};
        return stringArray;
    }

    public boolean isConsoleEnabled() {
        return this.showConsole;
    }

    public boolean isDebugEnabled() {
        return this.debugMode;
    }

    public boolean isJITEnabled() {
        return this.useJIT;
    }

    public boolean isJarCacheEnabled() {
        return this.jarCacheSize > 0;
    }

    public boolean isJavaEnabled() {
        return this.javapluginEnabled;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void reset() {
        Object object;
        this.firePropertyChange();
        this.props = new Properties();
        try {
            object = new FileInputStream(theUserPropertiesFile);
            this.props.load(new BufferedInputStream((InputStream)object));
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {}
        object = this.props.getProperty("javaplugin.console");
        this.showConsole = object != null && ((String)object).equals("true");
        this.jarCacheSize = 100;
        try {
            object = this.props.getProperty("javaplugin.jar.cache.size");
            this.jarCacheSize = Integer.parseInt((String)object);
        }
        catch (Exception exception) {}
        object = this.props.getProperty("javaplugin.enabled");
        this.javapluginEnabled = object == null || ((String)object).equals("true");
        object = this.props.getProperty(networkKey);
        if (object == null) {
            this.setNetworkAccessLevel(1);
        } else if (((String)object).equals("none")) {
            this.setNetworkAccessLevel(0);
        } else if (((String)object).equals("unrestricted")) {
            this.setNetworkAccessLevel(2);
        } else {
            this.setNetworkAccessLevel(1);
        }
        object = this.props.getProperty("javaplugin.debug.mode");
        this.debugMode = object != null && ((String)object).equals("true");
        this.debugPort = this.props.getProperty("javaplugin.debug.port");
        if (this.debugPort == null) {
            this.debugPort = "2502";
        }
        this.useDefaultProxy = (object = this.props.getProperty("javaplugin.proxy.usebrowsersettings")) == null || ((String)object).equals("true");
        this.proxySettings = this.props.getProperty("javaplugin.proxy.settings");
        object = this.props.getProperty("javaplugin.proxy.forallprotocols");
        this.useSameProxy = "true".equals(object);
        this.jdk = this.props.getProperty("javaplugin.jre.path");
        this.javaParms = this.props.getProperty("javaplugin.jre.params");
        this.activeCertsVector.addAll(this.inactiveCertsVector);
        this.inactiveCertsVector.clear();
    }

    public void setActiveCertificatesSet(byte[][] byArray) {
        block4: {
            this.activeCertsVector.clear();
            if (byArray.length <= 0) break block4;
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                int n = 0;
                while (n < byArray.length) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[n]);
                    while (byteArrayInputStream.available() > 0) {
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                        this.activeCertsVector.addElement(x509Certificate);
                    }
                    byteArrayInputStream.close();
                    ++n;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setConsoleEnabled(boolean bl) {
        this.showConsole = bl;
        this.firePropertyChange();
    }

    public void setDebugEnabled(boolean bl) {
        this.debugMode = bl;
        this.firePropertyChange();
    }

    public void setDebugPort(String string) {
        this.debugPort = string;
        this.firePropertyChange();
    }

    public void setDefaultProxySettings(boolean bl) {
        this.useDefaultProxy = bl;
        this.firePropertyChange();
    }

    public void setInstalledJavaList(String[] stringArray) {
        this.installedJavaVersion = stringArray;
    }

    public void setJDK(String string) {
        this.jdk = string;
        this.firePropertyChange();
    }

    public void setJITEnabled(boolean bl) {
        this.useJIT = bl;
        this.firePropertyChange();
    }

    public void setJITPath(String string) {
        this.JITPath = string;
        this.firePropertyChange();
    }

    public void setJarCacheEnabled(boolean bl) {
        this.jarCacheSize = bl ? 100 : 0;
        this.firePropertyChange();
    }

    public void setJavaEnabled(boolean bl) {
        this.javapluginEnabled = bl;
        this.firePropertyChange();
    }

    public void setJavaParms(String string) {
        this.javaParms = string;
        this.firePropertyChange();
    }

    public void setNetworkAccessLevel(int n) {
        this.networkMode = n;
        this.firePropertyChange();
    }

    public void setProxySettingsString(String string) {
        this.proxySettings = string;
        this.firePropertyChange();
    }

    public void setUseSameProxy(boolean bl) {
        this.useSameProxy = bl;
        this.firePropertyChange();
    }

    public boolean useDefaultProxy() {
        return this.useDefaultProxy;
    }

    public boolean useSameProxy() {
        return this.useSameProxy;
    }
}

