/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

public class Container
extends Component {
    int ncomponents;
    Component[] component = new Component[4];
    LayoutManager layoutMgr;
    private LightweightDispatcher dispatcher;
    private Dimension maxSize;
    transient ContainerListener containerListener;
    private static final long serialVersionUID = 4613797578919906343L;
    private int containerSerializedDataVersion = 1;

    static {
        Toolkit.loadLibraries();
        Container.initIDs();
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public Component add(Component component, int n) {
        this.addImpl(component, null, n);
        return component;
    }

    public void add(Component component, Object object) {
        this.addImpl(component, object, -1);
    }

    public void add(Component component, Object object, int n) {
        this.addImpl(component, object, n);
    }

    public Component add(String string, Component component) {
        this.addImpl(component, string, -1);
        return component;
    }

    public synchronized void addContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.add(this.containerListener, containerListener);
        this.newEventsOnly = true;
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object object3;
            if (n > this.ncomponents || n < 0 && n != -1) {
                throw new IllegalArgumentException("illegal component position");
            }
            if (component instanceof Container) {
                object3 = this;
                while (object3 != null) {
                    if (object3 == component) {
                        throw new IllegalArgumentException("adding container's parent to itself");
                    }
                    object3 = object3.parent;
                }
            }
            if (component instanceof Window) {
                throw new IllegalArgumentException("adding a window to a container");
            }
            if (component.parent != null) {
                component.parent.remove(component);
            }
            if (this.ncomponents == this.component.length) {
                object3 = new Component[this.ncomponents * 2];
                System.arraycopy(this.component, 0, object3, 0, this.ncomponents);
                this.component = object3;
            }
            if (n == -1 || n == this.ncomponents) {
                this.component[this.ncomponents++] = component;
            } else {
                System.arraycopy(this.component, n, this.component, n + 1, this.ncomponents - n);
                this.component[n] = component;
                ++this.ncomponents;
            }
            component.parent = this;
            if (this.valid) {
                this.invalidate();
            }
            if (this.peer != null) {
                component.addNotify();
            }
            if (this.layoutMgr != null) {
                if (this.layoutMgr instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutMgr).addLayoutComponent(component, object);
                } else if (object instanceof String) {
                    this.layoutMgr.addLayoutComponent((String)object, component);
                }
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                object3 = new ContainerEvent((Component)this, 300, component);
                this.processEvent((AWTEvent)object3);
            }
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.addNotify();
            if (!(this.peer instanceof LightweightPeer)) {
                this.dispatcher = new LightweightDispatcher(this);
            }
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            int n2 = 0;
            while (n2 < n) {
                componentArray[n2].addNotify();
                ++n2;
            }
        }
    }

    void applyOrientation(ComponentOrientation componentOrientation) {
        this.setComponentOrientation(componentOrientation);
        int n = 0;
        while (n < this.ncomponents) {
            Component component = this.component[n];
            if (component instanceof Container) {
                ((Container)component).applyOrientation(componentOrientation);
            } else {
                component.setComponentOrientation(componentOrientation);
            }
            ++n;
        }
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public void deliverEvent(Event event) {
        Component component = this.getComponentAt(event.x, event.y);
        if (component != null && component != this) {
            event.translate(-component.x, -component.y);
            component.deliverEvent(event);
        } else {
            this.postEvent(event);
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (this.dispatcher != null && this.dispatcher.dispatchEvent(aWTEvent)) {
            aWTEvent.consume();
            if (this.peer != null) {
                this.peer.handleEvent(aWTEvent);
            }
            return;
        }
        super.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventToSelf(AWTEvent aWTEvent) {
        super.dispatchEventImpl(aWTEvent);
    }

    public void doLayout() {
        this.layout();
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (n == 300 || n == 301) {
            return (this.eventMask & 2L) != 0L || this.containerListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public Component findComponentAt(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null && (component = component instanceof Container ? ((Container)component).findComponentAt(n - component.x, n2 - component.y) : component.locate(n - component.x, n2 - component.y)) != null && component.isVisible()) {
                return component;
            }
            ++n4;
        }
        return this;
    }

    public Component findComponentAt(Point point) {
        return this.findComponentAt(point.x, point.y);
    }

    public float getAlignmentX() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentX(this);
            }
        } else {
            f = super.getAlignmentX();
        }
        return f;
    }

    public float getAlignmentY() {
        float f;
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                f = layoutManager2.getLayoutAlignmentY(this);
            }
        } else {
            f = super.getAlignmentY();
        }
        return f;
    }

    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (n < 0 || n >= this.ncomponents) {
                throw new ArrayIndexOutOfBoundsException("No such child: " + n);
            }
            Component component = this.component[n];
            Object var4_4 = null;
            return component;
        }
    }

    public Component getComponentAt(int n, int n2) {
        return this.locate(n, n2);
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public int getComponentCount() {
        return this.countComponents();
    }

    public Component[] getComponents() {
        return this.getComponents_NoClientCode();
    }

    final Component[] getComponents_NoClientCode() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = new Component[this.ncomponents];
            System.arraycopy(this.component, 0, componentArray, 0, this.ncomponents);
            Component[] componentArray2 = componentArray;
            Object var3_4 = null;
            return componentArray2;
        }
    }

    Component getCursorTarget(int n, int n2) {
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null && component.contains(n - component.x, n2 - component.y) && component.visible) {
                if (component instanceof Container) {
                    Container container = (Container)component;
                    Component component2 = container.getCursorTarget(n - container.x, n2 - container.y);
                    if (component2 != null) {
                        return component2;
                    }
                } else {
                    return component;
                }
            }
            ++n4;
        }
        if (this.contains(n, n2) && this.peer instanceof LightweightPeer) {
            return this;
        }
        return null;
    }

    public Insets getInsets() {
        return this.insets();
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.maxSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        if (this.layoutMgr instanceof LayoutManager2) {
            Object object = this.getTreeLock();
            synchronized (object) {
                LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
                this.maxSize = layoutManager2.maximumLayoutSize(this);
            }
        } else {
            this.maxSize = super.getMaximumSize();
        }
        return this.maxSize;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    Component getMouseEventTarget(int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null && component.contains(n - component.x, n2 - component.y) && component.peer instanceof LightweightPeer && component.visible) {
                if (component instanceof Container) {
                    Container container = (Container)component;
                    Component component2 = container.getMouseEventTarget(n - container.x, n2 - container.y, bl);
                    if (component2 != null) {
                        return component2;
                    }
                } else if (component.mouseListener != null || (component.eventMask & 0x10L) != 0L || component.mouseMotionListener != null || (component.eventMask & 0x20L) != 0L) {
                    return component;
                }
            }
            ++n4;
        }
        boolean bl3 = this.peer instanceof LightweightPeer || bl;
        boolean bl4 = this.contains(n, n2);
        boolean bl5 = this.mouseListener != null || (this.eventMask & 0x10L) != 0L;
        boolean bl6 = bl2 = this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L;
        if (bl4 && bl3 && (bl5 || bl2)) {
            return this;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    Window getWindow() {
        Container container = this;
        while (!(container instanceof Window)) {
            container = container.getParent();
        }
        return (Window)container;
    }

    private static native void initIDs();

    public Insets insets() {
        if (this.peer != null && this.peer instanceof ContainerPeer) {
            ContainerPeer containerPeer = (ContainerPeer)this.peer;
            return (Insets)containerPeer.insets().clone();
        }
        return new Insets(0, 0, 0, 0);
    }

    public void invalidate() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 layoutManager2 = (LayoutManager2)this.layoutMgr;
            layoutManager2.invalidateLayout(this);
        }
        super.invalidate();
    }

    void invalidateTree() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            while (n < this.ncomponents) {
                Component component = this.component[n];
                if (component instanceof Container) {
                    ((Container)component).invalidateTree();
                } else if (component.valid) {
                    component.invalidate();
                }
                ++n;
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAncestorOf(Component var1_1) {
        if (var1_1 != null && (var2_2 = var1_1.getParent()) != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (var2_2 == this) {
                return true;
            }
            var2_2 = var2_2.getParent();
lbl6:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    public void layout() {
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            layoutManager.layoutContainer(this);
        }
    }

    void lightweightPrint(Graphics graphics) {
        super.lightweightPrint(graphics);
        this.printComponents(graphics);
    }

    public void list(PrintStream printStream, int n) {
        super.list(printStream, n);
        int n2 = this.ncomponents;
        Component[] componentArray = this.component;
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray[n3];
            if (component != null) {
                component.list(printStream, n + 1);
            }
            ++n3;
        }
    }

    public void list(PrintWriter printWriter, int n) {
        super.list(printWriter, n);
        int n2 = this.ncomponents;
        Component[] componentArray = this.component;
        int n3 = 0;
        while (n3 < n2) {
            Component component = componentArray[n3];
            if (component != null) {
                component.list(printWriter, n + 1);
            }
            ++n3;
        }
    }

    public Component locate(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        int n3 = this.ncomponents;
        Component[] componentArray = this.component;
        int n4 = 0;
        while (n4 < n3) {
            Component component = componentArray[n4];
            if (component != null && component.contains(n - component.x, n2 - component.y)) {
                return component;
            }
            ++n4;
        }
        return this;
    }

    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.minSize = this.layoutMgr != null ? this.layoutMgr.minimumLayoutSize(this) : super.minimumSize();
            Object var4_4 = null;
            return dimension2;
        }
    }

    void nextFocus(Component component) {
        Container container = this.parent;
        if (container != null) {
            container.transferFocus(component);
        }
    }

    public void paint(Graphics graphics) {
        if (this.isShowing()) {
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            Rectangle rectangle = graphics.getClipRect();
            int n2 = n - 1;
            while (n2 >= 0) {
                Component component = componentArray[n2];
                if (component != null && component.peer instanceof LightweightPeer && component.visible) {
                    Rectangle rectangle2 = component.getBounds();
                    if (rectangle == null || rectangle2.intersects(rectangle)) {
                        Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        graphics2.setFont(component.getFont());
                        try {
                            component.paint(graphics2);
                        }
                        finally {
                            Object var10_9 = null;
                            graphics2.dispose();
                        }
                    }
                }
                --n2;
            }
        }
    }

    public void paintComponents(Graphics graphics) {
        int n = this.ncomponents;
        Component[] componentArray = this.component;
        int n2 = n - 1;
        while (n2 >= 0) {
            block6: {
                Rectangle rectangle;
                Graphics graphics2;
                Component component;
                block7: {
                    component = componentArray[n2];
                    if (component == null || (graphics2 = component.getGraphics()) == null) break block6;
                    Rectangle rectangle2 = graphics.getClipRect();
                    if (rectangle2 == null) break block7;
                    Rectangle rectangle3 = component.getBounds();
                    if (!rectangle3.intersects(rectangle2)) break block6;
                    rectangle = rectangle3.intersection(rectangle2);
                    rectangle.translate(-rectangle3.x, -rectangle3.y);
                    graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                try {
                    component.paintAll(graphics2);
                }
                finally {
                    rectangle = null;
                    graphics2.dispose();
                }
            }
            --n2;
        }
    }

    protected String paramString() {
        String string = super.paramString();
        LayoutManager layoutManager = this.layoutMgr;
        if (layoutManager != null) {
            string = String.valueOf(string) + ",layout=" + layoutManager.getClass().getName();
        }
        return string;
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.postProcessKeyEvent(keyEvent);
        }
    }

    boolean postsOldMouseEvents() {
        return true;
    }

    void preProcessKeyEvent(KeyEvent keyEvent) {
        Container container = this.parent;
        if (container != null) {
            container.preProcessKeyEvent(keyEvent);
        }
    }

    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension != null && this.isValid()) {
            return dimension;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension2 = this.prefSize = this.layoutMgr != null ? this.layoutMgr.preferredLayoutSize(this) : super.preferredSize();
            Object var4_4 = null;
            return dimension2;
        }
    }

    public void print(Graphics graphics) {
        super.print(graphics);
        int n = this.ncomponents;
        Component[] componentArray = this.component;
        Rectangle rectangle = graphics.getClipRect();
        int n2 = n - 1;
        while (n2 >= 0) {
            Component component = componentArray[n2];
            if (component != null && component.peer instanceof LightweightPeer) {
                Rectangle rectangle2 = component.getBounds();
                if (rectangle == null || rectangle2.intersects(rectangle)) {
                    Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    try {
                        component.print(graphics2);
                    }
                    finally {
                        Object var10_9 = null;
                        graphics2.dispose();
                    }
                }
            }
            --n2;
        }
    }

    public void printComponents(Graphics graphics) {
        int n = this.ncomponents;
        Component[] componentArray = this.component;
        int n2 = n - 1;
        while (n2 >= 0) {
            Component component = componentArray[n2];
            if (component != null && component.peer instanceof LightweightPeer) {
                this.printOneComponent(graphics, component);
            }
            --n2;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            Component component = componentArray[n3];
            if (component != null && !(component.peer instanceof LightweightPeer)) {
                this.printOneComponent(graphics, component);
            }
            --n3;
        }
    }

    private void printOneComponent(Graphics graphics, Component component) {
        Graphics graphics2 = graphics.create(component.x, component.y, component.width, component.height);
        graphics2.setFont(component.getFont());
        try {
            component.printAll(graphics2);
        }
        finally {
            Object var5_4 = null;
            graphics2.dispose();
        }
    }

    protected void processContainerEvent(ContainerEvent containerEvent) {
        if (this.containerListener != null) {
            switch (containerEvent.getID()) {
                case 300: {
                    this.containerListener.componentAdded(containerEvent);
                    break;
                }
                case 301: {
                    this.containerListener.componentRemoved(containerEvent);
                    break;
                }
            }
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    void proxyEnableEvents(long l) {
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(l);
        } else if (this.dispatcher != null) {
            this.dispatcher.enableEvents(l);
        }
    }

    void proxyRequestFocus(Component component) {
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyRequestFocus(component);
        } else if (this.dispatcher.setFocusRequest(component)) {
            Container container = this;
            while (!(container instanceof Window)) {
                container = container.getParent();
            }
            if (((Window)container).isActive()) {
                this.peer.requestFocus();
            }
            Toolkit.getEventQueue().changeKeyEventFocus(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        Component[] componentArray = this.component;
        int n = 0;
        while (n < this.ncomponents) {
            componentArray[n].parent = this;
            ++n;
        }
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "containerL") {
                this.addContainerListener((ContainerListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public void remove(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.component[n];
            if (this.peer != null) {
                component.removeNotify();
            }
            if (this.layoutMgr != null) {
                this.layoutMgr.removeLayoutComponent(component);
            }
            component.parent = null;
            System.arraycopy(this.component, n + 1, this.component, n, this.ncomponents - n - 1);
            this.component[--this.ncomponents] = null;
            if (this.valid) {
                this.invalidate();
            }
            if (this.containerListener != null || (this.eventMask & 2L) != 0L) {
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.processEvent(containerEvent);
            }
            Object var3_5 = null;
            return;
        }
    }

    public void remove(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent == this) {
                Component[] componentArray = this.component;
                int n = this.ncomponents;
                while (--n >= 0) {
                    if (componentArray[n] != component) continue;
                    this.remove(n);
                }
            }
        }
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            while (this.ncomponents > 0) {
                Component component = this.component[--this.ncomponents];
                this.component[this.ncomponents] = null;
                if (this.peer != null) {
                    component.removeNotify();
                }
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(component);
                }
                component.parent = null;
                if (this.containerListener == null && (this.eventMask & 2L) == 0L) continue;
                ContainerEvent containerEvent = new ContainerEvent(this, 301, component);
                this.processEvent(containerEvent);
            }
            if (this.valid) {
                this.invalidate();
            }
        }
    }

    public synchronized void removeContainerListener(ContainerListener containerListener) {
        if (containerListener == null) {
            return;
        }
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, containerListener);
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.ncomponents;
            Component[] componentArray = this.component;
            int n2 = 0;
            while (n2 < n) {
                componentArray[n2].removeNotify();
                ++n2;
            }
            if (this.dispatcher != null) {
                this.dispatcher.dispose();
            }
            super.removeNotify();
        }
    }

    public synchronized void setCursor(Cursor cursor) {
        Component component;
        if (this.dispatcher != null && (component = this.dispatcher.getCursorOn()) != null) {
            this.cursor = cursor;
            this.dispatcher.updateCursor(component);
            return;
        }
        super.setCursor(cursor);
    }

    void setFocusOwner(Component component) {
        Container container = this.parent;
        if (container != null) {
            container.setFocusOwner(component);
        }
    }

    public void setFont(Font font) {
        boolean bl = false;
        Container container = this;
        synchronized (container) {
            Font font2 = this.getFont();
            super.setFont(font);
            Font font3 = this.getFont();
            if (!(font3 == font2 || font2 != null && font2.equals(font3))) {
                bl = true;
            }
        }
        if (bl) {
            this.invalidateTree();
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        this.layoutMgr = layoutManager;
        if (this.valid) {
            this.invalidate();
        }
    }

    void transferFocus(Component component) {
        this.nextFocus(component);
    }

    public void update(Graphics graphics) {
        if (this.isShowing()) {
            if (!(this.peer instanceof LightweightPeer)) {
                graphics.clearRect(0, 0, this.width, this.height);
            }
            this.paint(graphics);
        }
    }

    void updateCursor(Component component) {
        if (this.dispatcher != null) {
            this.dispatcher.updateCursor(component);
        }
    }

    public void validate() {
        if (!this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                if (!this.valid && this.peer != null) {
                    ContainerPeer containerPeer = null;
                    if (this.peer instanceof ContainerPeer) {
                        containerPeer = (ContainerPeer)this.peer;
                    }
                    if (containerPeer != null) {
                        containerPeer.beginValidate();
                    }
                    this.validateTree();
                    this.valid = true;
                    if (containerPeer != null) {
                        containerPeer.endValidate();
                    }
                }
            }
        }
    }

    protected void validateTree() {
        if (!this.valid) {
            this.doLayout();
            Component[] componentArray = this.component;
            int n = 0;
            while (n < this.ncomponents) {
                Component component = componentArray[n];
                if (component instanceof Container && !(component instanceof Window) && !component.valid) {
                    ((Container)component).validateTree();
                } else {
                    component.validate();
                }
                ++n;
            }
        }
        this.valid = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "containerL", this.containerListener);
        objectOutputStream.writeObject(null);
    }
}

