/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTML;

public class CSS {
    private static final Hashtable attributeMap = new Hashtable();
    private static final Hashtable valueMap = new Hashtable();
    static int[] sizeMap = new int[]{8, 10, 12, 14, 18, 24, 36};
    private static final Hashtable htmlAttrToCssAttrMap = new Hashtable(20);
    private static final Hashtable styleConstantToCssMap = new Hashtable(17);
    private static final Hashtable htmlValueToCssValueMap = new Hashtable(8);
    private static final Hashtable cssValueToInternalValueMap = new Hashtable(8);
    private transient Hashtable valueConvertor = new Hashtable();
    private int baseFontSize = 3;

    static {
        int n = 0;
        while (n < Attribute.allAttributes.length) {
            attributeMap.put(Attribute.allAttributes[n].toString(), Attribute.allAttributes[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < Value.allValues.length) {
            valueMap.put(Value.allValues[n2].toString(), Value.allValues[n2]);
            ++n2;
        }
        htmlAttrToCssAttrMap.put(HTML.Attribute.COLOR, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TEXT, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CLEAR, new Attribute[]{Attribute.CLEAR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BACKGROUND, new Attribute[]{Attribute.BACKGROUND_IMAGE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BGCOLOR, new Attribute[]{Attribute.BACKGROUND_COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.WIDTH, new Attribute[]{Attribute.WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HEIGHT, new Attribute[]{Attribute.HEIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BORDER, new Attribute[]{Attribute.BORDER_WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLPADDING, new Attribute[]{Attribute.PADDING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLSPACING, new Attribute[]{Attribute.MARGIN});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINWIDTH, new Attribute[]{Attribute.MARGIN_LEFT, Attribute.MARGIN_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINHEIGHT, new Attribute[]{Attribute.MARGIN_TOP, Attribute.MARGIN_BOTTOM});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HSPACE, new Attribute[]{Attribute.PADDING_LEFT, Attribute.PADDING_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VSPACE, new Attribute[]{Attribute.PADDING_BOTTOM, Attribute.PADDING_TOP});
        htmlAttrToCssAttrMap.put(HTML.Attribute.FACE, new Attribute[]{Attribute.FONT_FAMILY});
        htmlAttrToCssAttrMap.put(HTML.Attribute.SIZE, new Attribute[]{Attribute.FONT_SIZE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN});
        htmlAttrToCssAttrMap.put(HTML.Attribute.ALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN, Attribute.TEXT_ALIGN, Attribute.FLOAT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TYPE, new Attribute[]{Attribute.LIST_STYLE_TYPE});
        styleConstantToCssMap.put(StyleConstants.FontFamily, Attribute.FONT_FAMILY);
        styleConstantToCssMap.put(StyleConstants.FontSize, Attribute.FONT_SIZE);
        styleConstantToCssMap.put(StyleConstants.Bold, Attribute.FONT_WEIGHT);
        styleConstantToCssMap.put(StyleConstants.Italic, Attribute.FONT_STYLE);
        styleConstantToCssMap.put(StyleConstants.Underline, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.StrikeThrough, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.Superscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Subscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Foreground, Attribute.COLOR);
        styleConstantToCssMap.put(StyleConstants.Background, Attribute.BACKGROUND_COLOR);
        styleConstantToCssMap.put(StyleConstants.FirstLineIndent, Attribute.TEXT_INDENT);
        styleConstantToCssMap.put(StyleConstants.LeftIndent, Attribute.MARGIN_LEFT);
        styleConstantToCssMap.put(StyleConstants.RightIndent, Attribute.MARGIN_RIGHT);
        styleConstantToCssMap.put(StyleConstants.SpaceAbove, Attribute.MARGIN_TOP);
        styleConstantToCssMap.put(StyleConstants.SpaceBelow, Attribute.MARGIN_BOTTOM);
        styleConstantToCssMap.put(StyleConstants.Alignment, Attribute.TEXT_ALIGN);
        htmlValueToCssValueMap.put("disc", Value.DISC);
        htmlValueToCssValueMap.put("square", Value.SQUARE);
        htmlValueToCssValueMap.put("circle", Value.CIRCLE);
        htmlValueToCssValueMap.put("1", Value.DECIMAL);
        htmlValueToCssValueMap.put("a", Value.LOWER_ALPHA);
        htmlValueToCssValueMap.put("A", Value.UPPER_ALPHA);
        htmlValueToCssValueMap.put("i", Value.LOWER_ROMAN);
        htmlValueToCssValueMap.put("I", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("disc", Value.DISC);
        cssValueToInternalValueMap.put("square", Value.SQUARE);
        cssValueToInternalValueMap.put("circle", Value.CIRCLE);
        cssValueToInternalValueMap.put("decimal", Value.DECIMAL);
        cssValueToInternalValueMap.put("lower-roman", Value.LOWER_ROMAN);
        cssValueToInternalValueMap.put("upper-roman", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("lower-alpha", Value.LOWER_ALPHA);
        cssValueToInternalValueMap.put("upper-alpha", Value.UPPER_ALPHA);
        Attribute[] attributeArray = Attribute.allAttributes;
        try {
            int n3 = 0;
            while (n3 < attributeArray.length) {
                StyleContext.registerStaticAttributeKey(attributeArray[n3]);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public CSS() {
        this.valueConvertor.put(Attribute.FONT_SIZE, new FontSize());
        this.valueConvertor.put(Attribute.FONT_FAMILY, new FontFamily());
        this.valueConvertor.put(Attribute.FONT_WEIGHT, new FontWeight());
        this.valueConvertor.put(Attribute.BORDER_STYLE, new BorderStyle());
        ColorValue colorValue = new ColorValue();
        this.valueConvertor.put(Attribute.COLOR, colorValue);
        this.valueConvertor.put(Attribute.BACKGROUND_COLOR, colorValue);
        this.valueConvertor.put(Attribute.BORDER_COLOR, colorValue);
        LengthValue lengthValue = new LengthValue();
        this.valueConvertor.put(Attribute.MARGIN_TOP, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_RIGHT, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_TOP, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_RIGHT, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_TOP_WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_BOTTOM_WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_LEFT_WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_RIGHT_WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.TEXT_INDENT, lengthValue);
        this.valueConvertor.put(Attribute.WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.HEIGHT, lengthValue);
        StringValue stringValue = new StringValue();
        this.valueConvertor.put(Attribute.FONT_STYLE, stringValue);
        this.valueConvertor.put(Attribute.TEXT_DECORATION, stringValue);
        this.valueConvertor.put(Attribute.TEXT_ALIGN, stringValue);
        this.valueConvertor.put(Attribute.VERTICAL_ALIGN, stringValue);
        this.valueConvertor.put(Attribute.LIST_STYLE_TYPE, new ListType());
        CssValue cssValue = new CssValue();
        int n = Attribute.allAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = Attribute.allAttributes[n2];
            if (this.valueConvertor.get(attribute) == null) {
                this.valueConvertor.put(attribute, cssValue);
            }
            ++n2;
        }
    }

    static String colorToHex(Color color) {
        String string = new String("#");
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        }
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        }
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        }
        return string;
    }

    Object cssValueToStyleConstantsValue(StyleConstants styleConstants, Object object) {
        if (object instanceof CssValue) {
            return ((CssValue)object).toStyleConstants(styleConstants);
        }
        return null;
    }

    public static Attribute[] getAllAttributeKeys() {
        Attribute[] attributeArray = new Attribute[Attribute.allAttributes.length];
        System.arraycopy(Attribute.allAttributes, 0, attributeArray, 0, Attribute.allAttributes.length);
        return attributeArray;
    }

    public static final Attribute getAttribute(String string) {
        return (Attribute)attributeMap.get(string);
    }

    int getBaseFontSize() {
        return this.baseFontSize;
    }

    Color getColor(AttributeSet attributeSet, Attribute attribute) {
        ColorValue colorValue = (ColorValue)attributeSet.getAttribute(attribute);
        if (colorValue != null) {
            return colorValue.getValue();
        }
        return null;
    }

    private Attribute getCssAlignAttribute(HTML.Tag tag, AttributeSet attributeSet) {
        return Attribute.TEXT_ALIGN;
    }

    private Attribute[] getCssAttribute(HTML.Attribute attribute) {
        return (Attribute[])htmlAttrToCssAttrMap.get(attribute);
    }

    Object getCssValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        Object object = cssValue.parseHtmlValue(string);
        return object;
    }

    Font getFont(StyleContext styleContext, AttributeSet attributeSet, int n) {
        Object object;
        Object object2;
        FontSize fontSize = (FontSize)attributeSet.getAttribute(Attribute.FONT_SIZE);
        int n2 = fontSize != null ? (int)fontSize.getValue(attributeSet) : n;
        StringValue stringValue = (StringValue)attributeSet.getAttribute(Attribute.VERTICAL_ALIGN);
        if (stringValue != null && (((String)(object2 = stringValue.toString())).indexOf("sup") >= 0 || ((String)object2).indexOf("sub") >= 0)) {
            n2 -= 2;
        }
        String string = (object2 = (FontFamily)attributeSet.getAttribute(Attribute.FONT_FAMILY)) != null ? ((FontFamily)object2).getValue() : "SansSerif";
        int n3 = 0;
        FontWeight fontWeight = (FontWeight)attributeSet.getAttribute(Attribute.FONT_WEIGHT);
        if (fontWeight != null && fontWeight.getValue() > 400) {
            n3 |= 1;
        }
        if ((object = attributeSet.getAttribute(Attribute.FONT_STYLE)) != null && object.toString().indexOf("italic") >= 0) {
            n3 |= 2;
        }
        Font font = styleContext.getFont(string, n3, n2);
        return font;
    }

    private HTML.Tag getHTMLTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag;
        }
        return null;
    }

    static int getIndexOfSize(float f) {
        int n = 0;
        while (n < sizeMap.length) {
            if (f <= (float)sizeMap[n]) {
                return n;
            }
            ++n;
        }
        return sizeMap.length - 1;
    }

    Object getInternalCSSValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        return cssValue.parseCssValue(string);
    }

    float getLength(AttributeSet attributeSet, Attribute attribute) {
        LengthValue lengthValue = (LengthValue)attributeSet.getAttribute(attribute);
        float f = lengthValue != null ? lengthValue.getValue() : 0.0f;
        return f;
    }

    float getPointSize(int n) {
        if (n < 0) {
            return sizeMap[0];
        }
        if (n > sizeMap.length - 1) {
            return sizeMap[sizeMap.length - 1];
        }
        return sizeMap[n];
    }

    float getPointSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                return this.getPointSize(this.baseFontSize + n);
            }
            if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                return this.getPointSize(this.baseFontSize + n);
            }
            int n = Integer.valueOf(string);
            return this.getPointSize(n);
        }
        return 0.0f;
    }

    static final Value getValue(String string) {
        return (Value)valueMap.get(string);
    }

    static final Color hexToColor(String string) {
        if (string.startsWith("#")) {
            String string2 = string.substring(1, Math.min(string.length(), 7));
            String string3 = "0x" + string2;
            Color color = Color.decode(string3);
            return color;
        }
        return null;
    }

    private boolean isFloater(String string) {
        return string.equals("left") || string.equals("right");
    }

    private boolean isHTMLFontTag(HTML.Tag tag) {
        return tag != null && (tag == HTML.Tag.FONT || tag == HTML.Tag.BASEFONT);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.valueConvertor = new Hashtable(Math.max(1, n));
        while (n-- > 0) {
            Object object;
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            Object object4 = StyleContext.getStaticAttribute(object2);
            if (object4 != null) {
                object2 = object4;
            }
            if ((object = StyleContext.getStaticAttribute(object3)) != null) {
                object3 = object;
            }
            if (object2 == null || object3 == null) continue;
            this.valueConvertor.put(object2, object3);
        }
    }

    void setBaseFontSize(int n) {
        this.baseFontSize = n < 1 ? 0 : (n > 7 ? 7 : n);
    }

    void setBaseFontSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                this.setBaseFontSize(this.baseFontSize + n);
            } else if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                this.setBaseFontSize(this.baseFontSize + n);
            } else {
                this.setBaseFontSize(Integer.valueOf(string));
            }
        }
    }

    static Color stringToColor(String string) {
        Color color = null;
        if (string.charAt(0) == '#') {
            color = CSS.hexToColor(string);
        } else if (string.equalsIgnoreCase("Black")) {
            color = CSS.hexToColor("#000000");
        } else if (string.equalsIgnoreCase("Silver")) {
            color = CSS.hexToColor("#C0C0C0");
        } else if (string.equalsIgnoreCase("Gray")) {
            color = CSS.hexToColor("#808080");
        } else if (string.equalsIgnoreCase("White")) {
            color = CSS.hexToColor("#FFFFFF");
        } else if (string.equalsIgnoreCase("Maroon")) {
            color = CSS.hexToColor("#800000");
        } else if (string.equalsIgnoreCase("Red")) {
            color = CSS.hexToColor("#FF0000");
        } else if (string.equalsIgnoreCase("Purple")) {
            color = CSS.hexToColor("#800080");
        } else if (string.equalsIgnoreCase("Fuchsia")) {
            color = CSS.hexToColor("#FF00FF");
        } else if (string.equalsIgnoreCase("Green")) {
            color = CSS.hexToColor("#008000");
        } else if (string.equalsIgnoreCase("Lime")) {
            color = CSS.hexToColor("#00FF00");
        } else if (string.equalsIgnoreCase("Olive")) {
            color = CSS.hexToColor("#808000");
        } else if (string.equalsIgnoreCase("Yellow")) {
            color = CSS.hexToColor("#FFFF00");
        } else if (string.equalsIgnoreCase("Navy")) {
            color = CSS.hexToColor("#000080");
        } else if (string.equalsIgnoreCase("Blue")) {
            color = CSS.hexToColor("#0000FF");
        } else if (string.equalsIgnoreCase("Teal")) {
            color = CSS.hexToColor("#008080");
        } else if (string.equalsIgnoreCase("Aqua")) {
            color = CSS.hexToColor("#00FFFF");
        }
        return color;
    }

    Attribute styleConstantsKeyToCSSKey(StyleConstants styleConstants) {
        return (Attribute)styleConstantToCssMap.get(styleConstants);
    }

    Object styleConstantsValueToCSSValue(StyleConstants styleConstants, Object object) {
        Attribute attribute = this.styleConstantsKeyToCSSKey(styleConstants);
        if (attribute != null) {
            CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
            return cssValue.fromStyleConstants(styleConstants, object);
        }
        return null;
    }

    private void translateAttribute(HTML.Attribute attribute, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Attribute[] attributeArray = this.getCssAttribute(attribute);
        String string = (String)attributeSet.getAttribute(attribute);
        if (attributeArray == null || string == null) {
            return;
        }
        int n = 0;
        while (n < attributeArray.length) {
            Object object = this.getCssValue(attributeArray[n], string);
            if (object != null) {
                mutableAttributeSet.addAttribute(attributeArray[n], object);
            }
            ++n;
        }
    }

    private void translateAttributes(HTML.Tag tag, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Attribute) {
                HTML.Attribute attribute = (HTML.Attribute)object;
                if (attribute == HTML.Attribute.ALIGN) {
                    Object object2;
                    Attribute attribute2;
                    String string = (String)attributeSet.getAttribute(HTML.Attribute.ALIGN);
                    if (string == null || (attribute2 = this.getCssAlignAttribute(tag, attributeSet)) == null || (object2 = this.getCssValue(attribute2, string)) == null) continue;
                    mutableAttributeSet.addAttribute(attribute2, object2);
                    continue;
                }
                if (attribute == HTML.Attribute.SIZE && !this.isHTMLFontTag(tag)) continue;
                this.translateAttribute(attribute, attributeSet, mutableAttributeSet);
                continue;
            }
            if (!(object instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
    }

    private void translateEmbeddedAttributes(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                Object object2 = attributeSet.getAttribute(tag);
                if (object2 == null || !(object2 instanceof AttributeSet)) continue;
                this.translateAttributes(tag, (AttributeSet)object2, mutableAttributeSet);
                continue;
            }
            if (!(object instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
    }

    AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Element element = (Element)((Object)attributeSet);
        HTML.Tag tag = this.getHTMLTag(attributeSet);
        if (tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
            AttributeSet attributeSet2 = element.getParentElement().getParentElement().getAttributes();
            this.translateAttribute(HTML.Attribute.BORDER, attributeSet2, simpleAttributeSet);
            String string = (String)attributeSet2.getAttribute(HTML.Attribute.CELLPADDING);
            if (string != null) {
                Object object = this.getInternalCSSValue(Attribute.PADDING_TOP, string);
                simpleAttributeSet.addAttribute(Attribute.PADDING_TOP, object);
                simpleAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, object);
                simpleAttributeSet.addAttribute(Attribute.PADDING_LEFT, object);
                simpleAttributeSet.addAttribute(Attribute.PADDING_RIGHT, object);
            }
        }
        if (element.isLeaf()) {
            this.translateEmbeddedAttributes(attributeSet, simpleAttributeSet);
        } else {
            this.translateAttributes(tag, attributeSet, simpleAttributeSet);
        }
        return simpleAttributeSet;
    }

    private boolean validTextAlignValue(String string) {
        return this.isFloater(string) || string.equals("center");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Enumeration enumeration = this.valueConvertor.keys();
        objectOutputStream.writeInt(this.valueConvertor.size());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = this.valueConvertor.get(object);
                if (!(object instanceof Serializable) && (object = StyleContext.getStaticAttributeKey(object)) == null) {
                    object = null;
                    object2 = null;
                } else if (!(object2 instanceof Serializable) && (object2 = StyleContext.getStaticAttributeKey(object2)) == null) {
                    object = null;
                    object2 = null;
                }
                objectOutputStream.writeObject(object);
                objectOutputStream.writeObject(object2);
            }
        }
    }

    public static final class Attribute {
        private String name;
        private String defaultValue;
        private boolean inherited;
        public static final Attribute BACKGROUND = new Attribute("background", null, false);
        public static final Attribute BACKGROUND_ATTACHMENT = new Attribute("background-attachment", "scroll", false);
        public static final Attribute BACKGROUND_COLOR = new Attribute("background-color", "transparent", false);
        public static final Attribute BACKGROUND_IMAGE = new Attribute("background-image", "none", false);
        public static final Attribute BACKGROUND_POSITION = new Attribute("background-position", null, false);
        public static final Attribute BACKGROUND_REPEAT = new Attribute("background-repeat", "repeat", false);
        public static final Attribute BORDER = new Attribute("border", null, false);
        public static final Attribute BORDER_BOTTOM = new Attribute("border-bottom", null, false);
        public static final Attribute BORDER_BOTTOM_WIDTH = new Attribute("border-bottom-width", "medium", false);
        public static final Attribute BORDER_COLOR = new Attribute("border-color", null, false);
        public static final Attribute BORDER_LEFT = new Attribute("border-left", null, false);
        public static final Attribute BORDER_LEFT_WIDTH = new Attribute("border-left-width", "medium", false);
        public static final Attribute BORDER_RIGHT = new Attribute("border-right", null, false);
        public static final Attribute BORDER_RIGHT_WIDTH = new Attribute("border-right-width", "medium", false);
        public static final Attribute BORDER_STYLE = new Attribute("border-style", "none", false);
        public static final Attribute BORDER_TOP = new Attribute("border-top", null, false);
        public static final Attribute BORDER_TOP_WIDTH = new Attribute("border-top-width", "medium", false);
        public static final Attribute BORDER_WIDTH = new Attribute("border-width", "medium", false);
        public static final Attribute CLEAR = new Attribute("clear", "none", false);
        public static final Attribute COLOR = new Attribute("color", null, true);
        public static final Attribute DISPLAY = new Attribute("display", "block", false);
        public static final Attribute FLOAT = new Attribute("float", "none", false);
        public static final Attribute FONT = new Attribute("font", null, true);
        public static final Attribute FONT_FAMILY = new Attribute("font-family", null, true);
        public static final Attribute FONT_SIZE = new Attribute("font-size", "medium", true);
        public static final Attribute FONT_STYLE = new Attribute("font-style", "normal", true);
        public static final Attribute FONT_VARIANT = new Attribute("font-variant", "normal", true);
        public static final Attribute FONT_WEIGHT = new Attribute("font-weight", "normal", true);
        public static final Attribute HEIGHT = new Attribute("height", "auto", false);
        public static final Attribute LETTER_SPACING = new Attribute("letter-spacing", "normal", true);
        public static final Attribute LINE_HEIGHT = new Attribute("line-height", "normal", true);
        public static final Attribute LIST_STYLE = new Attribute("list-style", null, true);
        public static final Attribute LIST_STYLE_IMAGE = new Attribute("list-style-image", "none", true);
        public static final Attribute LIST_STYLE_POSITION = new Attribute("list-style-position", "outside", true);
        public static final Attribute LIST_STYLE_TYPE = new Attribute("list-style-type", "disc", true);
        public static final Attribute MARGIN = new Attribute("margin", null, false);
        public static final Attribute MARGIN_BOTTOM = new Attribute("margin-bottom", "0", false);
        public static final Attribute MARGIN_LEFT = new Attribute("margin-left", "0", false);
        public static final Attribute MARGIN_RIGHT = new Attribute("margin-right", "0", false);
        public static final Attribute MARGIN_TOP = new Attribute("margin-top", "0", false);
        public static final Attribute PADDING = new Attribute("padding", null, false);
        public static final Attribute PADDING_BOTTOM = new Attribute("padding-bottom", "0", false);
        public static final Attribute PADDING_LEFT = new Attribute("padding-left", "0", false);
        public static final Attribute PADDING_RIGHT = new Attribute("padding-right", "0", false);
        public static final Attribute PADDING_TOP = new Attribute("padding-top", "0", false);
        public static final Attribute TEXT_ALIGN = new Attribute("text-align", null, true);
        public static final Attribute TEXT_DECORATION = new Attribute("text-decoration", "none", true);
        public static final Attribute TEXT_INDENT = new Attribute("text-indent", "0", true);
        public static final Attribute TEXT_TRANSFORM = new Attribute("text-transform", "none", true);
        public static final Attribute VERTICAL_ALIGN = new Attribute("vertical-align", "baseline", false);
        public static final Attribute WORD_SPACING = new Attribute("word-spacing", "normal", true);
        public static final Attribute WHITE_SPACE = new Attribute("whitespace", "normal", true);
        public static final Attribute WIDTH = new Attribute("width", "auto", false);
        static final Attribute[] allAttributes = new Attribute[]{BACKGROUND, BACKGROUND_ATTACHMENT, BACKGROUND_COLOR, BACKGROUND_IMAGE, BACKGROUND_POSITION, BACKGROUND_REPEAT, BORDER, BORDER_BOTTOM, BORDER_BOTTOM_WIDTH, BORDER_COLOR, BORDER_LEFT, BORDER_LEFT_WIDTH, BORDER_RIGHT, BORDER_RIGHT_WIDTH, BORDER_STYLE, BORDER_TOP, BORDER_TOP_WIDTH, BORDER_WIDTH, CLEAR, COLOR, DISPLAY, FLOAT, FONT, FONT_FAMILY, FONT_SIZE, FONT_STYLE, FONT_VARIANT, FONT_WEIGHT, HEIGHT, LETTER_SPACING, LINE_HEIGHT, LIST_STYLE, LIST_STYLE_IMAGE, LIST_STYLE_POSITION, LIST_STYLE_TYPE, MARGIN, MARGIN_BOTTOM, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_TOP, PADDING, PADDING_BOTTOM, PADDING_LEFT, PADDING_RIGHT, PADDING_TOP, TEXT_ALIGN, TEXT_DECORATION, TEXT_INDENT, TEXT_TRANSFORM, VERTICAL_ALIGN, WORD_SPACING, WHITE_SPACE, WIDTH};

        private Attribute(String string, String string2, boolean bl) {
            this.name = string;
            this.defaultValue = string2;
            this.inherited = bl;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public String toString() {
            return this.name;
        }
    }

    static final class Value {
        static final Value INHERITED = new Value("inherited");
        static final Value NONE = new Value("none");
        static final Value DOTTED = new Value("dotted");
        static final Value DASHED = new Value("dashed");
        static final Value SOLID = new Value("solid");
        static final Value DOUBLE = new Value("double");
        static final Value GROOVE = new Value("groove");
        static final Value RIDGE = new Value("ridge");
        static final Value INSET = new Value("inset");
        static final Value OUTSET = new Value("outset");
        static final Value BLANK_LIST_ITEM = new Value("none");
        static final Value DISC = new Value("disc");
        static final Value CIRCLE = new Value("circle");
        static final Value SQUARE = new Value("square");
        static final Value DECIMAL = new Value("decimal");
        static final Value LOWER_ROMAN = new Value("lower-roman");
        static final Value UPPER_ROMAN = new Value("upper-roman");
        static final Value LOWER_ALPHA = new Value("lower-alpha");
        static final Value UPPER_ALPHA = new Value("upper-alpha");
        private String name;
        static final Value[] allValues = new Value[]{INHERITED, NONE, DOTTED, DASHED, SOLID, DOUBLE, GROOVE, RIDGE, INSET, OUTSET, DISC, CIRCLE, SQUARE, DECIMAL, LOWER_ROMAN, UPPER_ROMAN, LOWER_ALPHA, UPPER_ALPHA, BLANK_LIST_ITEM};

        private Value(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    static class CssValue
    implements Serializable {
        String svalue;

        CssValue() {
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return null;
        }

        Object parseCssValue(String string) {
            return string;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        public String toString() {
            return this.svalue;
        }

        Object toStyleConstants(StyleConstants styleConstants) {
            return null;
        }
    }

    static class StringValue
    extends CssValue {
        StringValue() {
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (styleConstants == StyleConstants.Italic) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("italic");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Underline) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("underline");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Alignment) {
                String string;
                int n = (Integer)object;
                switch (n) {
                    case 0: {
                        string = "left";
                        break;
                    }
                    case 2: {
                        string = "right";
                        break;
                    }
                    case 1: {
                        string = "center";
                        break;
                    }
                    case 3: {
                        string = "justify";
                        break;
                    }
                    default: {
                        string = "left";
                    }
                }
                return this.parseCssValue(string);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("line-through");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("super");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("sub");
                }
                return this.parseCssValue("");
            }
            return null;
        }

        Object parseCssValue(String string) {
            StringValue stringValue = new StringValue();
            stringValue.svalue = string;
            return stringValue;
        }

        Object toStyleConstants(StyleConstants styleConstants) {
            if (styleConstants == StyleConstants.Italic) {
                if (this.svalue.indexOf("italic") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Underline) {
                if (this.svalue.indexOf("underline") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Alignment) {
                if (this.svalue.equals("right")) {
                    return new Integer(2);
                }
                if (this.svalue.equals("center")) {
                    return new Integer(1);
                }
                if (this.svalue.equals("justify")) {
                    return new Integer(3);
                }
                return new Integer(0);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (this.svalue.indexOf("line-through") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (this.svalue.indexOf("super") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (this.svalue.indexOf("sub") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }
    }

    class FontSize
    extends CssValue {
        float value;
        boolean relative;
        boolean index;
        boolean percentage;

        FontSize() {
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return this.parseCssValue(object.toString());
        }

        float getValue(AttributeSet attributeSet) {
            if (this.index) {
                return CSS.this.getPointSize((int)this.value);
            }
            return this.value;
        }

        boolean isRelative() {
            return this.relative;
        }

        Object parseCssValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                if (string.equals("xx-small")) {
                    fontSize.value = 0.0f;
                    fontSize.index = true;
                } else if (string.equals("x-small")) {
                    fontSize.value = 1.0f;
                    fontSize.index = true;
                } else if (string.equals("small")) {
                    fontSize.value = 2.0f;
                    fontSize.index = true;
                } else if (string.equals("medium")) {
                    fontSize.value = 3.0f;
                    fontSize.index = true;
                } else if (string.equals("large")) {
                    fontSize.value = 4.0f;
                    fontSize.index = true;
                } else if (string.equals("x-large")) {
                    fontSize.value = 5.0f;
                    fontSize.index = true;
                } else if (string.equals("xx-large")) {
                    fontSize.value = 6.0f;
                    fontSize.index = true;
                } else if (string.equals("bigger")) {
                    fontSize.value = 1.0f;
                    fontSize.index = true;
                    fontSize.relative = true;
                } else if (string.equals("smaller")) {
                    fontSize.value = -1.0f;
                    fontSize.index = true;
                    fontSize.relative = true;
                } else if (string.endsWith("pt")) {
                    String string2 = string.substring(0, string.length() - 2);
                    fontSize.value = Float.valueOf(string2).floatValue();
                } else {
                    fontSize.value = Float.valueOf(string).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        Object parseHtmlValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                int n = CSS.this.getBaseFontSize();
                if (string != null && string.charAt(0) == '+') {
                    int n2 = Integer.valueOf(string.substring(1));
                    fontSize.value = n + n2;
                    fontSize.index = true;
                } else if (string != null && string.charAt(0) == '-') {
                    int n3 = -Integer.valueOf(string.substring(1)).intValue();
                    fontSize.value = n + n3;
                    fontSize.index = true;
                } else {
                    fontSize.value = Integer.parseInt(string);
                    if (fontSize.value > 6.0f) {
                        fontSize.value = 6.0f;
                    } else if (fontSize.value < 0.0f) {
                        fontSize.value = 0.0f;
                    }
                    fontSize.index = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        Object toStyleConstants(StyleConstants styleConstants) {
            return new Integer((int)this.getValue(null));
        }
    }

    static class FontFamily
    extends CssValue {
        String family;

        FontFamily() {
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return this.parseCssValue(object.toString());
        }

        String getValue() {
            return this.family;
        }

        Object parseCssValue(String string) {
            FontFamily fontFamily = new FontFamily();
            fontFamily.family = string.equals("monospace") ? "Monospaced" : string;
            fontFamily.svalue = string;
            return fontFamily;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object toStyleConstants(StyleConstants styleConstants) {
            return this.family;
        }
    }

    static class FontWeight
    extends CssValue {
        int weight;

        FontWeight() {
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (object.equals(Boolean.TRUE)) {
                return this.parseCssValue("bold");
            }
            return this.parseCssValue("normal");
        }

        int getValue() {
            return this.weight;
        }

        Object parseCssValue(String string) {
            FontWeight fontWeight = new FontWeight();
            fontWeight.svalue = string;
            if (string.equals("bold")) {
                fontWeight.weight = 700;
            } else if (string.equals("normal")) {
                fontWeight.weight = 400;
            } else {
                try {
                    fontWeight.weight = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    fontWeight = null;
                }
            }
            return fontWeight;
        }

        Object toStyleConstants(StyleConstants styleConstants) {
            return this.weight > 500 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static class ColorValue
    extends CssValue {
        Color c;

        ColorValue() {
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return this.parseCssValue(CSS.colorToHex((Color)object));
        }

        Color getValue() {
            return this.c;
        }

        Object parseCssValue(String string) {
            Color color = CSS.stringToColor(string);
            if (color != null) {
                ColorValue colorValue = new ColorValue();
                colorValue.svalue = string;
                colorValue.c = color;
                return colorValue;
            }
            return null;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object toStyleConstants(StyleConstants styleConstants) {
            return this.c;
        }
    }

    static class BorderStyle
    extends CssValue {
        private transient Value style;

        BorderStyle() {
        }

        Value getValue() {
            return this.style;
        }

        Object parseCssValue(String string) {
            Value value = CSS.getValue(string);
            if (value != null && (value == Value.INSET || value == Value.OUTSET || value == Value.NONE || value == Value.DOTTED || value == Value.DASHED || value == Value.SOLID || value == Value.DOUBLE || value == Value.GROOVE || value == Value.RIDGE)) {
                BorderStyle borderStyle = new BorderStyle();
                borderStyle.svalue = string;
                borderStyle.style = value;
                return borderStyle;
            }
            return null;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            Object object = objectInputStream.readObject();
            if (object != null) {
                this.style = CSS.getValue((String)object);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.style == null) {
                objectOutputStream.writeObject(null);
            } else {
                objectOutputStream.writeObject(this.style.toString());
            }
        }
    }

    static class LengthValue
    extends CssValue {
        float span;

        LengthValue() {
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            LengthValue lengthValue = new LengthValue();
            lengthValue.svalue = object.toString();
            lengthValue.span = ((Float)object).floatValue();
            return lengthValue;
        }

        float getValue() {
            return this.span;
        }

        Object parseCssValue(String string) {
            LengthValue lengthValue = new LengthValue();
            lengthValue.svalue = string;
            try {
                if (string.endsWith("pt")) {
                    String string2 = string.substring(0, string.length() - 2);
                    lengthValue.span = Float.valueOf(string2).floatValue();
                } else {
                    lengthValue.span = Float.valueOf(string).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                lengthValue = null;
            }
            return lengthValue;
        }

        Object parseHtmlValue(String string) {
            if (string.equals("#DEFAULT")) {
                string = "1";
            }
            return this.parseCssValue(string);
        }

        Object toStyleConstants(StyleConstants styleConstants) {
            return new Float(this.span);
        }
    }

    static class ListType
    extends CssValue {
        ListType() {
        }

        Object parseCssValue(String string) {
            Object object = cssValueToInternalValueMap.get(string);
            if (object == null) {
                object = cssValueToInternalValueMap.get(string.toLowerCase());
            }
            return object;
        }

        Object parseHtmlValue(String string) {
            Object object = htmlValueToCssValueMap.get(string);
            if (object == null) {
                object = htmlValueToCssValueMap.get(string.toLowerCase());
            }
            return object;
        }
    }
}

