/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.SortedSet;
import java.util.TreeSet;

public class GC {
    private static final long NO_TARGET = Long.MAX_VALUE;
    private static long latencyTarget = Long.MAX_VALUE;
    private static Thread daemon = null;
    private static Object lock = new LatencyLock();
    static /* synthetic */ Class class$sun$misc$GC$LatencyRequest;

    private GC() {
    }

    static /* synthetic */ Thread access$2() {
        return daemon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static long currentLatencyTarget() {
        long l = latencyTarget;
        return l == Long.MAX_VALUE ? 0L : l;
    }

    public static native long maxObjectInspectionAge();

    public static LatencyRequest requestLatency(long l) {
        class Sun_misc_GC$2 {
            /* synthetic */ Sun_misc_GC$2() {
            }
        }
        return new LatencyRequest(null, l);
    }

    private static void setLatencyTarget(long l) {
        latencyTarget = l;
        if (daemon == null) {
            Daemon.create();
        } else {
            lock.notify();
        }
    }

    private static class LatencyLock {
        LatencyLock() {
        }
    }

    private static class Daemon
    extends Thread {
        private Daemon(ThreadGroup threadGroup) {
            super(threadGroup, "GC Daemon");
        }

        /* synthetic */ Daemon(2 var1_1, ThreadGroup threadGroup) {
            this(threadGroup);
        }

        public static void create() {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    Daemon daemon = new Daemon(null, threadGroup);
                    daemon.setDaemon(true);
                    daemon.setPriority(2);
                    daemon.start();
                    GC.access$3(daemon);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        }

        public void run() {
            while (true) {
                Object object = lock;
                synchronized (object) {
                    Object var4_3;
                    long l = latencyTarget;
                    if (l == Long.MAX_VALUE) {
                        daemon = null;
                        var4_3 = null;
                        return;
                    }
                    long l2 = GC.maxObjectInspectionAge();
                    if (l2 >= l) {
                        System.gc();
                        l2 = 0L;
                    }
                    try {
                        lock.wait(l - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        var4_3 = null;
                    }
                }
            }
        }
    }

    public static class LatencyRequest
    implements Comparable {
        private static long counter = 0L;
        private static SortedSet requests = null;
        private long latency;
        private long id;

        private LatencyRequest(long l) {
            if (l <= 0L) {
                throw new IllegalArgumentException("Non-positive latency: " + l);
            }
            this.latency = l;
            Object object = lock;
            synchronized (object) {
                this.id = ++counter;
                if (requests == null) {
                    requests = new TreeSet();
                }
                requests.add(this);
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        /* synthetic */ LatencyRequest(2 var1_1, long l) {
            this(l);
        }

        private static void adjustLatencyIfNeeded() {
            if (requests == null || requests.isEmpty()) {
                if (latencyTarget != Long.MAX_VALUE) {
                    GC.setLatencyTarget(Long.MAX_VALUE);
                }
            } else {
                LatencyRequest latencyRequest = (LatencyRequest)requests.first();
                if (latencyRequest.latency != latencyTarget) {
                    GC.setLatencyTarget(latencyRequest.latency);
                }
            }
        }

        public void cancel() {
            Object object = lock;
            synchronized (object) {
                if (this.latency == Long.MAX_VALUE) {
                    throw new IllegalStateException("Request already cancelled");
                }
                if (!requests.remove(this)) {
                    throw new InternalError("Latency request " + this + " not found");
                }
                if (requests.isEmpty()) {
                    requests = null;
                }
                this.latency = Long.MAX_VALUE;
                LatencyRequest.adjustLatencyIfNeeded();
            }
        }

        public int compareTo(Object object) {
            LatencyRequest latencyRequest = (LatencyRequest)object;
            long l = this.latency - latencyRequest.latency;
            if (l == 0L) {
                l = this.id - latencyRequest.id;
            }
            return l < 0L ? -1 : (l > 0L ? 1 : 0);
        }

        public String toString() {
            return String.valueOf((class$sun$misc$GC$LatencyRequest != null ? class$sun$misc$GC$LatencyRequest : (class$sun$misc$GC$LatencyRequest = GC.class$("sun.misc.GC$LatencyRequest"))).getName()) + "[" + this.latency + "," + this.id + "]";
        }
    }
}

