/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.MenuContainer;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public abstract class MenuComponent
implements Serializable {
    transient MenuComponentPeer peer;
    transient MenuContainer parent;
    transient AppContext appContext = AppContext.getAppContext();
    Font font;
    private String name;
    private boolean nameExplicitlySet = false;
    boolean newEventsOnly = false;
    static final String actionListenerK = "actionL";
    static final String itemListenerK = "itemL";
    private static final long serialVersionUID = -4536902356223894379L;

    static {
        Toolkit.loadLibraries();
        MenuComponent.initIDs();
    }

    public MenuComponent() {
        SunToolkit.insertTargetMapping(this, this.appContext);
    }

    String constructComponentName() {
        return null;
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        Toolkit.getDefaultToolkit().notifyAWTEventListeners(aWTEvent);
        if (this.newEventsOnly || this.parent != null && this.parent instanceof MenuComponent && ((MenuComponent)((Object)this.parent)).newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
            } else if (aWTEvent instanceof ActionEvent && this.parent != null) {
                ((MenuComponent)((Object)this.parent)).dispatchEvent(new ActionEvent(this.parent, aWTEvent.getID(), ((ActionEvent)aWTEvent).getActionCommand()));
            }
        } else {
            Event event = aWTEvent.convertToOld();
            if (event != null) {
                this.postEvent(event);
            }
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        return false;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            return menuContainer.getFont();
        }
        return null;
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            if (menuContainer instanceof Component) {
                font = ((Component)menuContainer).getFont_NoClientCode();
            } else if (menuContainer instanceof MenuComponent) {
                font = ((MenuComponent)((Object)menuContainer)).getFont_NoClientCode();
            }
        }
        return font;
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            MenuComponent menuComponent = this;
            synchronized (menuComponent) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    public MenuContainer getParent() {
        return this.getParent_NoClientCode();
    }

    final MenuContainer getParent_NoClientCode() {
        return this.parent;
    }

    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    protected final Object getTreeLock() {
        return Component.LOCK;
    }

    private static native void initIDs();

    protected String paramString() {
        String string = this.getName();
        return string != null ? string : "";
    }

    public boolean postEvent(Event event) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            menuContainer.postEvent(event);
        }
        return false;
    }

    protected void processEvent(AWTEvent aWTEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.appContext = AppContext.getAppContext();
        SunToolkit.insertTargetMapping(this, this.appContext);
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuComponentPeer menuComponentPeer = this.peer;
            if (menuComponentPeer != null) {
                Toolkit.getEventQueue().removeSourceEvents(this);
                this.peer = null;
                menuComponentPeer.dispose();
            }
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setName(String string) {
        MenuComponent menuComponent = this;
        synchronized (menuComponent) {
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

