/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class DatagramSocket {
    DatagramSocketImpl impl;
    boolean connected = false;
    InetAddress connectedAddress = null;
    int connectedPort = -1;
    static Class implClass;

    static {
        String string = "";
        try {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("impl.prefix", "Plain"));
            implClass = Class.forName("java.net." + string + "DatagramSocketImpl");
        }
        catch (Exception exception) {
            System.err.println("Can't find class: java.net." + string + "DatagramSocketImpl: check impl.prefix property");
        }
        if (implClass == null) {
            try {
                implClass = Class.forName("java.net.PlainDatagramSocketImpl");
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
    }

    public DatagramSocket() throws SocketException {
        this.create(0, null);
    }

    public DatagramSocket(int n) throws SocketException {
        this(n, null);
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n);
        }
        this.create(n, inetAddress);
    }

    public void close() {
        this.impl.close();
    }

    public void connect(InetAddress inetAddress, int n) {
        DatagramSocket datagramSocket = this;
        synchronized (datagramSocket) {
            if (n < 0 || n > 65535) {
                throw new IllegalArgumentException("connect: " + n);
            }
            if (inetAddress == null) {
                throw new IllegalArgumentException("connect: null address");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (inetAddress.isMulticastAddress()) {
                    securityManager.checkMulticast(inetAddress);
                } else {
                    securityManager.checkConnect(inetAddress.getHostAddress(), n);
                    securityManager.checkAccept(inetAddress.getHostAddress(), n);
                }
            }
            this.connectedAddress = inetAddress;
            this.connectedPort = n;
            this.connected = true;
        }
    }

    void create(int n, InetAddress inetAddress) throws SocketException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        try {
            this.impl = (DatagramSocketImpl)implClass.newInstance();
        }
        catch (Exception exception) {
            throw new SocketException("can't instantiate DatagramSocketImpl");
        }
        this.impl.create();
        if (inetAddress == null) {
            inetAddress = InetAddress.anyLocalAddress;
        }
        this.impl.bind(n, inetAddress);
    }

    public void disconnect() {
        DatagramSocket datagramSocket = this;
        synchronized (datagramSocket) {
            this.connectedAddress = null;
            this.connectedPort = -1;
            this.connected = false;
        }
    }

    public InetAddress getInetAddress() {
        return this.connectedAddress;
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = (InetAddress)this.impl.getOption(15);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress;
        }
        return inetAddress;
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public int getPort() {
        return this.connectedPort;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        int n = 0;
        Object object = this.impl.getOption(4098);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public synchronized int getSendBufferSize() throws SocketException {
        int n = 0;
        Object object = this.impl.getOption(4097);
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        return n;
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        SecurityManager securityManager = null;
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            if (this.connected || (securityManager = System.getSecurityManager()) != null) {
                while (true) {
                    DatagramPacket datagramPacket3;
                    InetAddress inetAddress = new InetAddress();
                    int n = this.impl.peek(inetAddress);
                    if (this.connected) {
                        if (this.connectedAddress.equals(inetAddress) && this.connectedPort == n) break;
                        datagramPacket3 = new DatagramPacket(new byte[1], 1);
                        this.impl.receive(datagramPacket3);
                        continue;
                    }
                    if (securityManager == null) continue;
                    try {
                        securityManager.checkAccept(inetAddress.getHostAddress(), n);
                    }
                    catch (SecurityException securityException) {
                        datagramPacket3 = new DatagramPacket(new byte[1], 1);
                        this.impl.receive(datagramPacket3);
                        continue;
                    }
                    break;
                }
            }
            this.impl.receive(datagramPacket);
        }
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        InetAddress inetAddress = null;
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            if (!this.connected) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (datagramPacket.getAddress().isMulticastAddress()) {
                        securityManager.checkMulticast(datagramPacket.getAddress());
                    } else {
                        securityManager.checkConnect(datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
                    }
                }
            } else {
                inetAddress = datagramPacket.getAddress();
                if (inetAddress == null) {
                    datagramPacket.setAddress(this.connectedAddress);
                    datagramPacket.setPort(this.connectedPort);
                } else if (!inetAddress.equals(this.connectedAddress) || datagramPacket.getPort() != this.connectedPort) {
                    throw new IllegalArgumentException("connected address and packet address differ");
                }
            }
            this.impl.send(datagramPacket);
        }
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("invalid receive size");
        }
        this.impl.setOption(4098, new Integer(n));
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
        if (n <= 0) {
            throw new IllegalArgumentException("negative send size");
        }
        this.impl.setOption(4097, new Integer(n));
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }
}

