/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;
import java.security.AccessController;
import sun.rmi.server.RemoteProxy;
import sun.security.action.GetPropertyAction;

public class ActivationID
implements Serializable {
    private Activator activator;
    private UID uid = new UID();
    private static final long serialVersionUID = -4608673054848209235L;
    private static String activatorClassName = (String)AccessController.doPrivileged(new GetPropertyAction("java.rmi.activation.activator.class", "sun.rmi.server.Activation$ActivatorImpl"));

    public ActivationID(Activator activator) {
        this.activator = activator;
    }

    public Remote activate(boolean bl) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            MarshalledObject marshalledObject = this.activator.activate(this, bl);
            return (Remote)marshalledObject.get();
        }
        catch (UnknownObjectException unknownObjectException) {
            throw unknownObjectException;
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (IOException iOException) {
            throw new ActivationException("activation failed", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ActivationException("activation failed", classNotFoundException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ActivationID) {
            ActivationID activationID = (ActivationID)object;
            return this.uid.equals(activationID.uid) && this.activator.equals(activationID.activator);
        }
        return false;
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uid = (UID)objectInputStream.readObject();
        try {
            Class clazz = Class.forName("sun.rmi.server." + objectInputStream.readUTF());
            RemoteRef remoteRef = (RemoteRef)clazz.newInstance();
            remoteRef.readExternal(objectInputStream);
            this.activator = (Activator)((Object)RemoteProxy.getStub(activatorClassName, remoteRef));
        }
        catch (InstantiationException instantiationException) {
            throw new UnmarshalException("Unable to create remote reference", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnmarshalException("Illegal access creating remote reference");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.writeObject(this.uid);
        RemoteRef remoteRef = ((RemoteObject)((Object)this.activator)).getRef();
        objectOutputStream.writeUTF(remoteRef.getRefClass(objectOutputStream));
        remoteRef.writeExternal(objectOutputStream);
    }
}

