/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;

public class ByteComponentRaster
extends WritableRaster {
    protected int bandOffset;
    protected int[] dataOffsets;
    protected int scanlineStride;
    protected int pixelStride;
    protected byte[] data;
    int type;

    static {
        NativeLibLoader.loadLibraries();
        ByteComponentRaster.initIDs();
    }

    public ByteComponentRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteComponentRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteComponentRaster byteComponentRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteComponentRaster);
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteComponentRasters must have byte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.type = 1;
            this.scanlineStride = componentSampleModel.getScanlineStride();
            this.pixelStride = componentSampleModel.getPixelStride();
            this.dataOffsets = componentSampleModel.getBandOffsets();
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            int n3 = 0;
            while (n3 < this.getNumDataElements()) {
                int n4 = n3++;
                this.dataOffsets[n4] = this.dataOffsets[n4] + (n * this.pixelStride + n2 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            this.type = 7;
            this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = dataBufferByte.getOffset();
            int n = rectangle.x - point.x;
            int n5 = rectangle.y - point.y;
            this.dataOffsets[0] = n * this.pixelStride + n5 * this.scanlineStride;
        } else {
            throw new RasterFormatException("IntegerComponentRasters must have ComponentSampleModel or SinglePixelPackedSampleModel");
        }
        this.bandOffset = this.dataOffsets[0];
        this.verify(false);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ByteComponentRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new ByteComponentRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[this.scanlineStride * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(this.data, n6, byArray, 0, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(this.data, n6, byArray, n7, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    byArray[n7++] = this.data[n10];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[this.numDataElements * this.scanlineStride * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                int n10 = 0;
                while (n10 < this.numDataElements) {
                    byArray[n6++] = this.data[this.dataOffsets[n10] + n8];
                    ++n10;
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        return byArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        byte[] byArray = object == null ? new byte[n3 * n4 * this.numDataElements] : (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5;
            int n9 = 0;
            while (n9 < n3) {
                int n10 = 0;
                while (n10 < this.numDataElements) {
                    byArray[n6++] = this.data[this.dataOffsets[n10] + n8];
                    ++n10;
                }
                ++n9;
                n8 += this.pixelStride;
            }
            ++n7;
            n5 += this.scanlineStride;
        }
        return byArray;
    }

    public Object getDataElements(int n, int n2, Object object) {
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n4 = 0;
        while (n4 < this.numDataElements) {
            byArray[n4] = this.data[this.dataOffsets[n4] + n3];
            ++n4;
        }
        return byArray;
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    private static native void initIDs();

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(byArray, 0, this.data, n6, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(byArray, n7, this.data, n6, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    this.data[n10] = byArray[n7++];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.numDataElements == 1) {
            n5 += this.dataOffsets[0];
            if (this.pixelStride == 1) {
                if (this.scanlineStride == n3) {
                    System.arraycopy(byArray, 0, this.data, n5, n3 * n4);
                } else {
                    int n7 = 0;
                    while (n7 < n4) {
                        System.arraycopy(byArray, n6, this.data, n5, n3);
                        n6 += n3;
                        n5 += this.scanlineStride;
                        ++n7;
                    }
                }
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    int n9 = n5;
                    int n10 = 0;
                    while (n10 < n3) {
                        this.data[n9] = byArray[n6++];
                        ++n10;
                        n9 += this.pixelStride;
                    }
                    ++n8;
                    n5 += this.scanlineStride;
                }
            }
        } else {
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n5;
                int n13 = 0;
                while (n13 < n3) {
                    int n14 = 0;
                    while (n14 < this.numDataElements) {
                        this.data[this.dataOffsets[n14] + n12] = byArray[n6++];
                        ++n14;
                    }
                    ++n13;
                    n12 += this.pixelStride;
                }
                ++n11;
                n5 += this.scanlineStride;
            }
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        byte[] byArray = (byte[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.numDataElements == 1) {
            int n7 = 0;
            int n8 = n5 + this.dataOffsets[0];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n5;
                System.arraycopy(byArray, n7, this.data, n8, n3);
                n7 += n3;
                n8 += this.scanlineStride;
                ++n9;
            }
            return;
        }
        int n11 = 0;
        while (n11 < n4) {
            int n12 = n5;
            int n13 = 0;
            while (n13 < n3) {
                int n14 = 0;
                while (n14 < this.numDataElements) {
                    this.data[this.dataOffsets[n14] + n12] = byArray[n6++];
                    ++n14;
                }
                ++n13;
                n12 += this.pixelStride;
            }
            ++n11;
            n5 += this.scanlineStride;
        }
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = n + raster.getMinX();
        int n8 = n2 + raster.getMinY();
        Object object = null;
        if (raster instanceof ByteComponentRaster) {
            ByteComponentRaster byteComponentRaster = (ByteComponentRaster)raster;
            byte[] byArray = byteComponentRaster.getDataStorage();
            if (this.numDataElements == 1) {
                int n9 = byteComponentRaster.getDataOffset(0);
                int n10 = byteComponentRaster.getScanlineStride();
                int n11 = n9;
                int n12 = this.dataOffsets[0] + (n8 - this.minY) * this.scanlineStride + (n7 - this.minX);
                if (this.pixelStride == byteComponentRaster.getPixelStride()) {
                    n3 *= this.pixelStride;
                    int n13 = 0;
                    while (n13 < n4) {
                        System.arraycopy(byArray, n11, this.data, n12, n3);
                        n11 += n10;
                        n12 += this.scanlineStride;
                        ++n13;
                    }
                    return;
                }
            }
        }
        int n14 = 0;
        while (n14 < n4) {
            object = raster.getDataElements(n5, n6 + n14, n3, 1, object);
            this.setDataElements(n7, n8 + n14, n3, 1, object);
            ++n14;
        }
    }

    public void setDataElements(int n, int n2, Object object) {
        byte[] byArray = (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n4 = 0;
        while (n4 < this.numDataElements) {
            this.data[this.dataOffsets[n4] + n3] = byArray[n4];
            ++n4;
        }
    }

    public String toString() {
        return new String("ByteComponentRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }

    private void verify(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numDataElements) {
            int n3 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[n2];
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        if (this.data.length < n) {
            throw new RasterFormatException("Data array too small (should be " + n + " )");
        }
    }
}

