/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;
import sun.net.www.http.KeepAliveCache;
import sun.net.www.http.KeepAliveStream;
import sun.security.action.GetPropertyAction;

public class HttpClient
extends NetworkClient {
    MessageHeader requests;
    boolean failedOnce = false;
    KeepAliveStream kas;
    private static RegexpPool dontProxy = new RegexpPool();
    private static String dontProxySource = null;
    static final int httpPortNumber = 80;
    public static String proxyHost = null;
    public static int proxyPort = 80;
    private String instProxy = null;
    private int instProxyPort = -1;
    protected boolean proxyDisabled;
    public boolean usingProxy = false;
    private String host;
    private int port;
    protected static KeepAliveCache kac = new KeepAliveCache();
    boolean keepingAlive = false;
    int keepAliveConnections = -1;
    int keepAliveTimeout = 0;
    protected URL url;

    private HttpClient(URL uRL) throws IOException {
        this(uRL, null, -1, false);
    }

    public HttpClient(URL uRL, String string, int n) throws IOException {
        this(uRL, string, n, false);
    }

    private HttpClient(URL uRL, String string, int n, boolean bl) throws IOException {
        this.proxyDisabled = bl;
        if (!bl) {
            this.instProxy = string;
            this.instProxyPort = n < 0 ? this.getDefaultPort() : n;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.host = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.host = uRL.getHost();
        }
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    protected HttpClient(URL uRL, boolean bl) throws IOException {
        this(uRL, null, -1, bl);
    }

    public static HttpClient New(URL uRL) throws IOException {
        HttpClient httpClient = (HttpClient)kac.get(uRL);
        if (httpClient == null) {
            httpClient = new HttpClient(uRL);
        } else {
            httpClient.url = uRL;
        }
        return httpClient;
    }

    public void closeServer() {
        try {
            this.keepingAlive = false;
            this.serverSocket.close();
        }
        catch (Exception exception) {}
    }

    protected void finalize() throws Throwable {
    }

    public static void finished(HttpClient httpClient) {
        --httpClient.keepAliveConnections;
        if (httpClient.keepAliveConnections > 0 && httpClient.keepingAlive && !httpClient.serverOutput.checkError()) {
            kac.put(httpClient.url, httpClient);
        } else {
            httpClient.closeServer();
        }
    }

    protected int getDefaultPort() {
        return 80;
    }

    private static RegexpPool getDontProxy() {
        RegexpPool regexpPool = dontProxy;
        synchronized (regexpPool) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
            if (string == dontProxySource) {
                RegexpPool regexpPool2 = dontProxy;
                Object var2_3 = null;
                return regexpPool2;
            }
            RegexpPool regexpPool3 = new RegexpPool();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        regexpPool3.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (REException rEException) {
                    System.err.println("Error in http.nonProxyHosts system property:  " + rEException);
                }
            }
            dontProxySource = string;
            dontProxy = regexpPool3;
        }
        return dontProxy;
    }

    public boolean getHttpKeepAliveSet() {
        return false;
    }

    public synchronized InputStream getInputStream() {
        return this.serverInput;
    }

    public OutputStream getOutputStream() {
        return this.serverOutput;
    }

    private String getProxyHost() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public String getProxyHostUsed() {
        if (!this.usingProxy) {
            return null;
        }
        return this.instProxy;
    }

    private int getProxyPort() {
        final int[] nArray = new int[1];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                nArray[0] = System.getProperty("http.proxyHost") != null ? Integer.getInteger("http.proxyPort", 80).intValue() : Integer.getInteger("proxyPort", 80).intValue();
                return null;
            }
        });
        return nArray[0];
    }

    public int getProxyPortUsed() {
        return this.instProxyPort;
    }

    public String getURLFile() {
        if (this.usingProxy) {
            String string = String.valueOf(this.url.getProtocol()) + "://" + this.url.getHost();
            if (this.url.getPort() != -1) {
                string = String.valueOf(string) + ":" + this.url.getPort();
            }
            return String.valueOf(string) + this.url.getFile();
        }
        return this.url.getFile();
    }

    public final boolean isKeepingAlive() {
        return this.getHttpKeepAliveSet() && this.keepingAlive;
    }

    private synchronized void openServer() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(this.host, this.port);
        }
        if (this.keepingAlive) {
            return;
        }
        RegexpPool regexpPool = HttpClient.getDontProxy();
        if (this.url.getProtocol().equals("http")) {
            if (this.instProxy != null) {
                this.privilegedOpenServer(this.instProxy, this.instProxyPort);
                this.usingProxy = true;
                return;
            }
            String string = this.getProxyHost();
            if (string != null && !this.proxyDisabled && regexpPool.match(this.url.getHost().toLowerCase()) == null && regexpPool.match(this.host) == null) {
                try {
                    int n = this.getProxyPort();
                    this.privilegedOpenServer(string, n);
                    this.instProxy = string;
                    this.instProxyPort = n;
                    this.usingProxy = true;
                    return;
                }
                catch (IOException iOException) {}
            }
            this.openServer(this.host, this.port);
            this.usingProxy = false;
            return;
        }
        if (this.instProxy != null) {
            this.privilegedSuperOpenServer(this.instProxy, this.instProxyPort);
            this.usingProxy = true;
            return;
        }
        String string = this.getProxyHost();
        if (string != null && !this.proxyDisabled && regexpPool.match(this.url.getHost().toLowerCase()) == null && regexpPool.match(this.host) == null) {
            try {
                int n = this.getProxyPort();
                this.privilegedSuperOpenServer(string, n);
                this.instProxy = string;
                this.instProxyPort = n;
                this.usingProxy = true;
                return;
            }
            catch (IOException iOException) {}
        }
        super.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    public void openServer(String string, int n) throws IOException {
        this.serverSocket = this.doConnect(string, n);
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()));
        this.serverSocket.setTcpNoDelay(true);
    }

    public boolean parseHTTP(MessageHeader messageHeader, ProgressEntry progressEntry) throws IOException {
        int n;
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        boolean bl = false;
        byte[] byArray = new byte[7];
        try {
            this.serverInput = this.serverSocket.getInputStream();
            this.serverInput = new BufferedInputStream(this.serverInput);
            this.serverInput = new PushbackInputStream(this.serverInput, 7);
            n = 0;
            while (n < 7) {
                int n2 = this.serverInput.read(byArray, n, 7 - n);
                if (n2 < 0) break;
                n += n2;
            }
            String string = null;
            bl = byArray[0] == 72 && byArray[1] == 84 && byArray[2] == 84 && byArray[3] == 80 && byArray[4] == 47 && byArray[5] == 49 && byArray[6] == 46;
            ((PushbackInputStream)this.serverInput).unread(byArray);
            if (bl) {
                messageHeader.parseHeader(this.serverInput);
                string = this.usingProxy ? messageHeader.findValue("Proxy-Connection") : messageHeader.findValue("Connection");
                if (string != null && string.toLowerCase().equals("keep-alive")) {
                    HeaderParser headerParser = new HeaderParser(messageHeader.findValue("Keep-Alive"));
                    this.keepAliveConnections = headerParser.findInt("max", 5);
                    this.keepAliveTimeout = headerParser.findInt("timeout", 5);
                }
            } else {
                if (n != 7) {
                    if (!this.failedOnce && this.requests != null) {
                        this.failedOnce = true;
                        this.closeServer();
                        this.openServer();
                        this.writeRequests(this.requests);
                        return this.parseHTTP(messageHeader, progressEntry);
                    }
                    throw new SocketException("Unexpected end of file from server");
                }
                messageHeader.set("Content-type", "unknown/unknown");
            }
        }
        catch (IOException iOException) {
            this.closeServer();
            if (!this.failedOnce && this.requests != null) {
                this.failedOnce = true;
                this.openServer();
                this.writeRequests(this.requests);
                return this.parseHTTP(messageHeader, progressEntry);
            }
            throw iOException;
        }
        n = -1;
        try {
            n = Integer.parseInt(messageHeader.findValue("content-length"));
        }
        catch (Exception exception) {}
        if (this.keepAliveConnections > 1 && n > 0) {
            this.keepingAlive = true;
        } else if (this.keepingAlive) {
            this.keepingAlive = false;
        }
        if (n > 0) {
            progressEntry.setType(this.url.getFile(), messageHeader.findValue("content-type"));
            progressEntry.update(0, n);
            if (this.keepingAlive) {
                this.kas = new KeepAliveStream(this.serverInput, progressEntry, this);
                this.serverInput = this.kas;
                this.failedOnce = false;
            } else {
                this.serverInput = new MeteredStream(this.serverInput, progressEntry);
            }
        } else {
            ProgressData.pdata.unregister(progressEntry);
        }
        return bl;
    }

    private synchronized void privilegedOpenServer(final String string, final int n) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    this.openServer(string, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private synchronized void privilegedSuperOpenServer(final String string, final int n) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    this.superOpenServer(string, n);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public static synchronized void resetProperties() {
    }

    private void superOpenServer(String string, int n) throws IOException, UnknownHostException {
        super.openServer(string, n);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.url + ")";
    }

    public void writeRequests(MessageHeader messageHeader) {
        this.requests = messageHeader;
        this.requests.print(this.serverOutput);
        this.serverOutput.flush();
    }
}

