/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jsafe;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.jsafe.RSAPrivateKey;
import sun.security.jsafe.RSAPublicKey;

public class RSAKeyFactory
extends KeyFactorySpi {
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage());
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification: " + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName("java.security.spec.RSAPublicKeySpec");
                Class<?> clazz3 = Class.forName("java.security.spec.X509EncodedKeySpec");
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz4 = Class.forName("java.security.spec.PKCS8EncodedKeySpec");
                if (clazz4.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key type");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)this.engineGetKeySpec(key, class$java$security$spec$RSAPublicKeySpec != null ? class$java$security$spec$RSAPublicKeySpec : (class$java$security$spec$RSAPublicKeySpec = RSAKeyFactory.class$("java.security.spec.RSAPublicKeySpec")));
                return this.engineGeneratePublic(rSAPublicKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = RSAKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")));
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key: " + invalidKeySpecException.getMessage());
        }
    }
}

