/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class StyleSheet
extends StyleContext {
    static final Border noBorder = new EmptyBorder(0, 0, 0, 0);
    static final int DEFAULT_FONT_SIZE = 3;
    private CSS css;
    private Hashtable selectorMapping = new Hashtable();
    private Hashtable resolvedStyles = new Hashtable();
    private Vector linkedStyleSheets;
    private URL base;
    static final SheetAttribute SPECIFICITY = new SheetAttribute("specificity", false);
    static final SheetAttribute RULE = new SheetAttribute("rule", false);
    static final SheetAttribute WEIGHT = new SheetAttribute("rule-weight", false);
    static final SheetAttribute BOX_PAINTER = new SheetAttribute("box-painter", true);
    static final SheetAttribute LIST_PAINTER = new SheetAttribute("list-painter", true);

    static {
        StyleContext.registerStaticAttributeKey(RULE);
        StyleContext.registerStaticAttributeKey(WEIGHT);
        StyleContext.registerStaticAttributeKey(BOX_PAINTER);
        StyleContext.registerStaticAttributeKey(LIST_PAINTER);
    }

    public StyleSheet() {
        if (this.css == null) {
            this.css = new CSS();
        }
    }

    private String _cleanSelectorString(String string) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        StringBuffer stringBuffer = searchBuffer.getStringBuffer();
        boolean bl = true;
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        String string2 = null;
        try {
            int n3 = 0;
            while (n3 < n2) {
                switch (cArray[n3]) {
                    case ' ': {
                        if (!bl) {
                            bl = true;
                            if (n < n3) {
                                stringBuffer.append(cArray, n, 1 + n3 - n);
                            }
                        }
                        n = n3 + 1;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        if (!bl) {
                            bl = true;
                            if (n < n3) {
                                stringBuffer.append(cArray, n, n3 - n);
                                stringBuffer.append(' ');
                            }
                        }
                        n = n3 + 1;
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
                ++n3;
            }
            if (bl && stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else if (n < n2) {
                stringBuffer.append(cArray, n, n2 - n);
            }
            string2 = stringBuffer.toString();
        }
        finally {
            Object var10_10 = null;
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
        return string2;
    }

    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        CSS.Attribute attribute;
        Object object3;
        if (this.css == null) {
            this.css = new CSS();
        }
        if (object instanceof StyleConstants && (object3 = this.css.styleConstantsValueToCSSValue((StyleConstants)object, object2)) != null && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
            return super.addAttribute(attributeSet, attribute, object3);
        }
        return super.addAttribute(attributeSet, object, object2);
    }

    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return super.addAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    boolean addCSSAttribute(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        Object object = this.css.getInternalCSSValue(attribute, string);
        if (object != null) {
            mutableAttributeSet.addAttribute(attribute, object);
            return true;
        }
        return false;
    }

    boolean addCSSAttributeFromHTML(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        Object object = this.css.getCssValue(attribute, string);
        if (object != null) {
            mutableAttributeSet.addAttribute(attribute, object);
            return true;
        }
        return false;
    }

    public void addRule(String string) {
        block2: {
            if (string == null) break block2;
            CssParser cssParser = new CssParser();
            try {
                cssParser.parse(this.getBase(), new StringReader(string), false, false);
            }
            catch (IOException iOException) {}
        }
    }

    void addRule(String[] stringArray, AttributeSet attributeSet, boolean bl) {
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        String string = stringBuffer.toString();
        Style style = this.getStyle(string);
        if (style == null) {
            Style style2 = this.addStyle(string, null);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                Object object = this.getRootSelectorMapping();
                int n3 = n - 1;
                while (n3 >= 0) {
                    object = this.getSelectorMapping(object, stringArray[n3], true);
                    --n3;
                }
                style = this.getMappingStyle(object);
                if (style == null) {
                    style = this.createStyleForSelector(string, object, style2);
                    this.refreshResolvedRules(string, stringArray, style, this.getSpecificity(object));
                }
            }
        }
        if (bl) {
            style = this.getLinkedStyle(style);
        }
        style.addAttributes(attributeSet);
    }

    private void addSortedStyle(Object object, Vector vector) {
        int n = vector.size();
        if (n > 0) {
            int n2 = this.getSpecificity(object);
            int n3 = 0;
            while (n3 < n) {
                if (n2 >= this.getSpecificity(vector.elementAt(n3))) {
                    vector.insertElementAt(object, n3);
                    return;
                }
                ++n3;
            }
        }
        vector.addElement(object);
    }

    synchronized void addStyleSheet(StyleSheet styleSheet) {
        if (this.linkedStyleSheets == null) {
            this.linkedStyleSheets = new Vector();
        }
        if (!this.linkedStyleSheets.contains(styleSheet)) {
            this.linkedStyleSheets.insertElementAt(styleSheet, 0);
            this.linkStyleSheetAt(styleSheet, 0);
        }
    }

    String cleanSelectorString(String string) {
        boolean bl = true;
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            switch (string.charAt(n)) {
                case ' ': {
                    if (bl) {
                        return this._cleanSelectorString(string);
                    }
                    bl = true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return this._cleanSelectorString(string);
                }
                default: {
                    bl = false;
                }
            }
            ++n;
        }
        if (bl) {
            return this._cleanSelectorString(string);
        }
        return string;
    }

    AttributeSet convertAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof LargeConversionSet || attributeSet instanceof SmallConversionSet) {
            return attributeSet;
        }
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!(object instanceof StyleConstants)) continue;
            LargeConversionSet largeConversionSet = new LargeConversionSet();
            Enumeration enumeration2 = attributeSet.getAttributeNames();
            while (enumeration2.hasMoreElements()) {
                Object object2;
                CSS.Attribute attribute;
                Object object3 = enumeration2.nextElement();
                Object object4 = null;
                if (object3 instanceof StyleConstants && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object3)) != null && (object4 = this.css.styleConstantsValueToCSSValue((StyleConstants)object3, object2 = attributeSet.getAttribute(object3))) != null) {
                    largeConversionSet.addAttribute(attribute, object4);
                }
                if (object4 != null) continue;
                largeConversionSet.addAttribute(object3, attributeSet.getAttribute(object3));
            }
            return largeConversionSet;
        }
        return attributeSet;
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new LargeConversionSet(attributeSet);
    }

    private Style createResolvedStyle(String string) {
        Style style;
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        try {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = string.length();
            while (n4 < n5) {
                if (n == n4) {
                    n = string.indexOf(46, n4);
                }
                if (n3 == n4) {
                    n3 = string.indexOf(35, n4);
                }
                if ((n2 = string.indexOf(32, n4)) == -1) {
                    n2 = n5;
                }
                if (n != -1 && n3 != -1 && n < n2 && n3 < n2) {
                    if (n3 < n) {
                        if (n4 == n3) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n4, n3));
                        }
                        if (n + 1 < n2) {
                            vector.addElement(string.substring(n + 1, n2));
                        } else {
                            vector.addElement(null);
                        }
                        if (n3 + 1 == n) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n3 + 1, n));
                        }
                    } else if (n3 < n2) {
                        if (n4 == n) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n4, n));
                        }
                        if (n + 1 < n3) {
                            vector.addElement(string.substring(n + 1, n3));
                        } else {
                            vector.addElement(null);
                        }
                        if (n3 + 1 == n2) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n3 + 1, n2));
                        }
                    }
                    n = n3 = n2 + 1;
                } else if (n != -1 && n < n2) {
                    if (n == n4) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n4, n));
                    }
                    if (n + 1 == n2) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n + 1, n2));
                    }
                    vector.addElement(null);
                    n = n2 + 1;
                } else if (n3 != -1 && n3 < n2) {
                    if (n3 == n4) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n4, n3));
                    }
                    vector.addElement(null);
                    if (n3 + 1 == n2) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n3 + 1, n2));
                    }
                    n3 = n2 + 1;
                } else {
                    vector.addElement(string.substring(n4, n2));
                    vector.addElement(null);
                    vector.addElement(null);
                }
                n4 = n2 + 1;
            }
            int n6 = vector.size();
            int n7 = n6 / 3;
            String[] stringArray = new String[n7];
            String[] stringArray2 = new String[n7];
            String[] stringArray3 = new String[n7];
            int n8 = 0;
            int n9 = n6 - 3;
            while (n8 < n7) {
                stringArray[n8] = (String)vector.elementAt(n9);
                stringArray2[n8] = (String)vector.elementAt(n9 + 1);
                stringArray3[n8] = (String)vector.elementAt(n9 + 2);
                ++n8;
                n9 -= 3;
            }
            style = this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
            Object var6_17 = null;
        }
        catch (Throwable throwable) {
            Object var6_18 = null;
            SearchBuffer.releaseSearchBuffer(searchBuffer);
            throw throwable;
        }
        SearchBuffer.releaseSearchBuffer(searchBuffer);
        return style;
    }

    private Style createResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        int n = vector.size();
        if (tag == HTML.Tag.IMPLIED) {
            tag = HTML.Tag.P;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)vector.elementAt(n2);
            AttributeSet attributeSet = element.getAttributes();
            if (attributeSet != null) {
                HTML.Tag tag2 = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                if (tag2 == HTML.Tag.IMPLIED) {
                    tag2 = HTML.Tag.P;
                }
                stringArray[n2] = tag2 != null ? tag2.toString() : null;
                stringArray3[n2] = attributeSet.isDefined(HTML.Attribute.CLASS) ? attributeSet.getAttribute(HTML.Attribute.CLASS).toString() : null;
                stringArray2[n2] = attributeSet.isDefined(HTML.Attribute.ID) ? attributeSet.getAttribute(HTML.Attribute.ID).toString() : null;
            } else {
                stringArray3[n2] = null;
                stringArray2[n2] = null;
                stringArray[n2] = null;
            }
            ++n2;
        }
        stringArray[0] = tag.toString();
        return this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
    }

    private synchronized Style createResolvedStyle(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        Style style;
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        Hashtable hashtable = searchBuffer.getHashtable();
        try {
            Style style2;
            String string2;
            Object object = this.getRootSelectorMapping();
            int n = stringArray.length;
            String string3 = stringArray[0];
            Object object2 = this.getSelectorMapping(object, string3, false);
            if (object2 != null) {
                this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, 1, n, hashtable);
            }
            if (stringArray3[0] != null) {
                string2 = stringArray3[0];
                object2 = this.getSelectorMapping(object, String.valueOf(string3) + "." + string2, false);
                if (object2 != null) {
                    this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, 1, n, hashtable);
                }
                if ((object2 = this.getSelectorMapping(object, "." + string2, false)) != null) {
                    this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, 1, n, hashtable);
                }
            }
            if (stringArray2[0] != null) {
                string2 = stringArray2[0];
                object2 = this.getSelectorMapping(object, String.valueOf(string3) + "#" + string2, false);
                if (object2 != null) {
                    this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, 1, n, hashtable);
                }
                if ((object2 = this.getSelectorMapping(object, "#" + string2, false)) != null) {
                    this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, 1, n, hashtable);
                }
            }
            int n2 = this.linkedStyleSheets != null ? this.linkedStyleSheets.size() : 0;
            int n3 = vector.size();
            AttributeSet[] attributeSetArray = new AttributeSet[n3 + n2];
            int n4 = 0;
            while (n4 < n3) {
                attributeSetArray[n4] = this.getMappingStyle(vector.elementAt(n4));
                ++n4;
            }
            int n5 = 0;
            while (n5 < n2) {
                style2 = ((StyleSheet)this.linkedStyleSheets.elementAt(n5)).getRule(string);
                attributeSetArray[n5 + n3] = style2 == null ? SimpleAttributeSet.EMPTY : style2;
                ++n5;
            }
            style2 = new ResolvedStyle(string, attributeSetArray, n3);
            this.resolvedStyles.put(string, style2);
            style = style2;
            Object var10_20 = null;
        }
        catch (Throwable throwable) {
            Object var10_21 = null;
            SearchBuffer.releaseSearchBuffer(searchBuffer);
            throw throwable;
        }
        SearchBuffer.releaseSearchBuffer(searchBuffer);
        return style;
    }

    protected StyleContext.SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallConversionSet(attributeSet);
    }

    private synchronized Style createStyleForSelector(String string, Object object, Style style) {
        Style style2 = (Style)((Hashtable)object).get(RULE);
        if (style2 == null) {
            style2 = style;
            ((Hashtable)object).put(RULE, style);
        }
        return style2;
    }

    public Color getBackground(AttributeSet attributeSet) {
        return this.css.getColor(attributeSet, CSS.Attribute.BACKGROUND_COLOR);
    }

    URL getBase() {
        return this.base;
    }

    public BoxPainter getBoxPainter(AttributeSet attributeSet) {
        return new BoxPainter(attributeSet, this.css, this);
    }

    public AttributeSet getDeclaration(String string) {
        if (string == null) {
            return SimpleAttributeSet.EMPTY;
        }
        CssParser cssParser = new CssParser();
        return cssParser.parseDeclaration(string);
    }

    public Font getFont(AttributeSet attributeSet) {
        return this.css.getFont(this, attributeSet, 12);
    }

    public Color getForeground(AttributeSet attributeSet) {
        Color color = this.css.getColor(attributeSet, CSS.Attribute.COLOR);
        if (color == null) {
            return Color.black;
        }
        return color;
    }

    public static int getIndexOfSize(float f) {
        return CSS.getIndexOfSize(f);
    }

    private Style getLinkedStyle(Style style) {
        Style style2 = (Style)style.getResolveParent();
        if (style2 == null) {
            style2 = this.addStyle(null, null);
            style.setResolveParent(style2);
        }
        return style2;
    }

    public ListPainter getListPainter(AttributeSet attributeSet) {
        return new ListPainter(attributeSet);
    }

    private Style getMappingStyle(Object object) {
        return (Style)((Hashtable)object).get(RULE);
    }

    public float getPointSize(int n) {
        return this.css.getPointSize(n);
    }

    public float getPointSize(String string) {
        return this.css.getPointSize(string);
    }

    private synchronized Style getResolvedStyle(String string) {
        Style style = (Style)this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string);
        }
        return style;
    }

    private synchronized Style getResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        Style style = (Style)this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string, vector, tag);
        }
        return style;
    }

    private Object getRootSelectorMapping() {
        return this.selectorMapping;
    }

    public Style getRule(String string) {
        if ((string = this.cleanSelectorString(string)) != null) {
            Style style = this.getResolvedStyle(string);
            return style;
        }
        return null;
    }

    public Style getRule(HTML.Tag tag, Element element) {
        Style style;
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        try {
            Style style2;
            AttributeSet attributeSet;
            Vector vector = searchBuffer.getVector();
            Element element2 = element;
            while (element2 != null) {
                vector.addElement(element2);
                element2 = element2.getParentElement();
            }
            int n = vector.size();
            StringBuffer stringBuffer = searchBuffer.getStringBuffer();
            int n2 = n - 1;
            while (n2 >= 1) {
                element = (Element)vector.elementAt(n2);
                attributeSet = element.getAttributes();
                Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
                String string = object instanceof HTML.Tag ? (object == HTML.Tag.IMPLIED ? HTML.Tag.P.toString() : object.toString()) : object.toString();
                stringBuffer.append(string);
                if (attributeSet != null) {
                    if (attributeSet.isDefined(HTML.Attribute.ID)) {
                        stringBuffer.append('#');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                    } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                        stringBuffer.append('.');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                    }
                }
                stringBuffer.append(' ');
                --n2;
            }
            if (tag == HTML.Tag.IMPLIED) {
                tag = HTML.Tag.P;
            }
            stringBuffer.append(tag.toString());
            element = (Element)vector.elementAt(0);
            attributeSet = element.getAttributes();
            if (attributeSet != null) {
                if (attributeSet.isDefined(HTML.Attribute.ID)) {
                    stringBuffer.append('#');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                    stringBuffer.append('.');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                }
            }
            style = style2 = this.getResolvedStyle(stringBuffer.toString(), vector, tag);
            Object var6_14 = null;
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            SearchBuffer.releaseSearchBuffer(searchBuffer);
            throw throwable;
        }
        SearchBuffer.releaseSearchBuffer(searchBuffer);
        return style;
    }

    private synchronized Object getSelectorMapping(Object object, String string, boolean bl) {
        Hashtable hashtable = (Hashtable)((Hashtable)object).get(string);
        if (hashtable == null && bl) {
            char c;
            Object object2;
            hashtable = new Hashtable(7);
            ((Hashtable)object).put(string, hashtable);
            int n = 0;
            if (object != null && (object2 = ((Hashtable)object).get(SPECIFICITY)) != null) {
                n = (Integer)object2;
            }
            if ((c = string.charAt(0)) == '.') {
                n += 100;
            } else if (c == '#') {
                n += 10000;
            } else {
                ++n;
                if (string.indexOf(46) != -1) {
                    n += 100;
                }
                if (string.indexOf(35) != -1) {
                    n += 10000;
                }
            }
            hashtable.put(SPECIFICITY, new Integer(n));
        }
        return hashtable;
    }

    String[] getSimpleSelectors(String string) {
        string = this.cleanSelectorString(string);
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        int n = 0;
        int n2 = string.length();
        while (n != -1) {
            int n3 = string.indexOf(32, n);
            if (n3 != -1) {
                vector.addElement(string.substring(n, n3));
                if (++n3 == n2) {
                    n = -1;
                    continue;
                }
                n = n3;
                continue;
            }
            vector.addElement(string.substring(n));
            n = -1;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        SearchBuffer.releaseSearchBuffer(searchBuffer);
        return objectArray;
    }

    private int getSpecificity(Object object) {
        Object object2 = ((Hashtable)object).get(SPECIFICITY);
        if (object2 != null) {
            return (Integer)object2;
        }
        return 0;
    }

    static int getSpecificity(String string) {
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            switch (string.charAt(n2)) {
                case '.': {
                    n += 100;
                    break;
                }
                case '#': {
                    n += 10000;
                    break;
                }
                case ' ': {
                    bl = true;
                    break;
                }
                default: {
                    if (!bl) break;
                    bl = false;
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }

    synchronized Enumeration getStyleSheets() {
        if (this.linkedStyleSheets == null) {
            return null;
        }
        return this.linkedStyleSheets.elements();
    }

    private synchronized void getStyles(Object object, Vector vector, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, Hashtable hashtable) {
        if (hashtable.contains(object)) {
            return;
        }
        hashtable.put(object, object);
        Style style = this.getMappingStyle(object);
        if (style != null) {
            this.addSortedStyle(object, vector);
        }
        int n3 = n;
        while (n3 < n2) {
            String string = stringArray[n3];
            if (string != null) {
                String string2;
                Object object2 = this.getSelectorMapping(object, string, false);
                if (object2 != null) {
                    this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, n3 + 1, n2, hashtable);
                }
                if (stringArray3[n3] != null) {
                    string2 = stringArray3[n3];
                    object2 = this.getSelectorMapping(object, String.valueOf(string) + "." + string2, false);
                    if (object2 != null) {
                        this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, n3 + 1, n2, hashtable);
                    }
                    if ((object2 = this.getSelectorMapping(object, "." + string2, false)) != null) {
                        this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, n3 + 1, n2, hashtable);
                    }
                }
                if (stringArray2[n3] != null) {
                    string2 = stringArray2[n3];
                    object2 = this.getSelectorMapping(object, String.valueOf(string) + "#" + string2, false);
                    if (object2 != null) {
                        this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, n3 + 1, n2, hashtable);
                    }
                    if ((object2 = this.getSelectorMapping(object, "#" + string2, false)) != null) {
                        this.getStyles(object2, vector, stringArray, stringArray2, stringArray3, n3 + 1, n2, hashtable);
                    }
                }
            }
            ++n3;
        }
    }

    public AttributeSet getViewAttributes(View view) {
        return new ViewAttributeSet(view);
    }

    void importStyleSheet(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            CssParser cssParser = new CssParser();
            cssParser.parse(uRL, bufferedReader, false, true);
            ((Reader)bufferedReader).close();
            inputStream.close();
        }
        catch (Throwable throwable) {}
    }

    private synchronized void linkStyleSheetAt(StyleSheet styleSheet, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                resolvedStyle.insertExtendedStyleAt(styleSheet.getRule(resolvedStyle.getName()), n);
            }
        }
    }

    public void loadRules(Reader reader, URL uRL) throws IOException {
        CssParser cssParser = new CssParser();
        cssParser.parse(uRL, reader, false, false);
    }

    private synchronized void refreshResolvedRules(String string, String[] stringArray, Style style, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                if (!resolvedStyle.matches(string)) continue;
                resolvedStyle.insertStyle(style, n);
            }
        }
    }

    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        CSS.Attribute attribute;
        if (object instanceof StyleConstants && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
            return super.removeAttribute(attributeSet, attribute);
        }
        return super.removeAttribute(attributeSet, object);
    }

    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration enumeration) {
        return super.removeAttributes(attributeSet, enumeration);
    }

    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return super.removeAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    private void removeMappingStyle(Object object) {
        ((Hashtable)object).remove(RULE);
    }

    public void removeStyle(String string) {
        Style style = this.getStyle(string);
        if (style != null) {
            String string2 = this.cleanSelectorString(string);
            String[] stringArray = this.getSimpleSelectors(string2);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                Object object = this.getRootSelectorMapping();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    object = this.getSelectorMapping(object, stringArray[n], true);
                    --n;
                }
                Style style2 = this.getMappingStyle(object);
                if (style2 != null) {
                    this.removeMappingStyle(object);
                    if (this.resolvedStyles.size() > 0) {
                        Enumeration enumeration = this.resolvedStyles.elements();
                        while (enumeration.hasMoreElements()) {
                            ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                            resolvedStyle.removeStyle(style2);
                        }
                    }
                }
            }
        }
        super.removeStyle(string);
    }

    synchronized void removeStyleSheet(StyleSheet styleSheet) {
        int n;
        if (this.linkedStyleSheets != null && (n = this.linkedStyleSheets.indexOf(styleSheet)) != -1) {
            this.linkedStyleSheets.removeElementAt(n);
            this.unlinkStyleSheet(styleSheet, n);
            if (n == 0 && this.linkedStyleSheets.size() == 0) {
                this.linkedStyleSheets = null;
            }
        }
    }

    void setBase(URL uRL) {
        this.base = uRL;
    }

    public void setBaseFontSize(int n) {
        this.css.setBaseFontSize(n);
    }

    public void setBaseFontSize(String string) {
        this.css.setBaseFontSize(string);
    }

    public Color stringToColor(String string) {
        return CSS.stringToColor(string);
    }

    public AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.css.translateHTMLToCSS(attributeSet);
        Style style = this.addStyle(null, null);
        style.addAttributes(attributeSet2);
        return style;
    }

    private synchronized void unlinkStyleSheet(StyleSheet styleSheet, int n) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                resolvedStyle.removeExtendedStyleAt(n);
            }
        }
    }

    class LargeConversionSet
    extends SimpleAttributeSet {
        public LargeConversionSet() {
        }

        public LargeConversionSet(AttributeSet attributeSet) {
            super(attributeSet);
        }

        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }

        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }
    }

    class SmallConversionSet
    extends StyleContext.SmallAttributeSet {
        public SmallConversionSet(AttributeSet attributeSet) {
            super(attributeSet);
        }

        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }

        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }
    }

    private static class SearchBuffer {
        static Stack searchBuffers = new Stack();
        Vector vector = null;
        StringBuffer stringBuffer = null;
        Hashtable hashtable = null;

        SearchBuffer() {
        }

        void empty() {
            if (this.stringBuffer != null) {
                this.stringBuffer.setLength(0);
            }
            if (this.vector != null) {
                this.vector.removeAllElements();
            }
            if (this.hashtable != null) {
                this.hashtable.clear();
            }
        }

        Hashtable getHashtable() {
            if (this.hashtable == null) {
                this.hashtable = new Hashtable();
            }
            return this.hashtable;
        }

        StringBuffer getStringBuffer() {
            if (this.stringBuffer == null) {
                this.stringBuffer = new StringBuffer();
            }
            return this.stringBuffer;
        }

        Vector getVector() {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            return this.vector;
        }

        static SearchBuffer obtainSearchBuffer() {
            SearchBuffer searchBuffer;
            try {
                searchBuffer = (SearchBuffer)searchBuffers.pop();
            }
            catch (EmptyStackException emptyStackException) {
                searchBuffer = new SearchBuffer();
            }
            return searchBuffer;
        }

        static void releaseSearchBuffer(SearchBuffer searchBuffer) {
            searchBuffer.empty();
            searchBuffers.push(searchBuffer);
        }
    }

    public static class BoxPainter
    implements Serializable {
        Border border;
        Insets binsets;
        CSS css;
        StyleSheet ss;

        BoxPainter(AttributeSet attributeSet, CSS cSS, StyleSheet styleSheet) {
            this.ss = styleSheet;
            this.css = cSS;
            this.border = this.getBorder(attributeSet);
            this.binsets = this.border.getBorderInsets(null);
        }

        Border getBorder(AttributeSet attributeSet) {
            Border border = noBorder;
            Object object = attributeSet.getAttribute(CSS.Attribute.BORDER_STYLE);
            if (object != null) {
                String string = object.toString();
                int n = (int)this.getLength(CSS.Attribute.BORDER_WIDTH, attributeSet);
                if (n > 0) {
                    if (string.equals("inset")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new BevelBorder(1, color.brighter(), color.darker());
                    } else if (string.equals("outset")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new BevelBorder(0, color.brighter(), color.darker());
                    } else if (string.equals("solid")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new LineBorder(color);
                    }
                }
            }
            return border;
        }

        Color getBorderColor(AttributeSet attributeSet) {
            Color color = this.css.getColor(attributeSet, CSS.Attribute.BORDER_COLOR);
            if (color == null && (color = this.css.getColor(attributeSet, CSS.Attribute.COLOR)) == null) {
                return Color.black;
            }
            return color;
        }

        public float getInset(int n, View view) {
            AttributeSet attributeSet = view.getAttributes();
            float f = 0.0f;
            switch (n) {
                case 2: {
                    f += this.getLength(CSS.Attribute.MARGIN_LEFT, attributeSet);
                    f += (float)this.binsets.left;
                    f += this.getLength(CSS.Attribute.PADDING_LEFT, attributeSet);
                    break;
                }
                case 4: {
                    f += this.getLength(CSS.Attribute.MARGIN_RIGHT, attributeSet);
                    f += (float)this.binsets.right;
                    f += this.getLength(CSS.Attribute.PADDING_RIGHT, attributeSet);
                    break;
                }
                case 1: {
                    f += this.getLength(CSS.Attribute.MARGIN_TOP, attributeSet);
                    f += (float)this.binsets.top;
                    f += this.getLength(CSS.Attribute.PADDING_TOP, attributeSet);
                    break;
                }
                case 3: {
                    f += this.getLength(CSS.Attribute.MARGIN_BOTTOM, attributeSet);
                    f += (float)this.binsets.bottom;
                    f += this.getLength(CSS.Attribute.PADDING_BOTTOM, attributeSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid side: " + n);
                }
            }
            return f;
        }

        float getLength(CSS.Attribute attribute, AttributeSet attributeSet) {
            return this.css.getLength(attributeSet, attribute);
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view) {
            AttributeSet attributeSet = view.getAttributes();
            StyleSheet styleSheet = this.ss;
            float f5 = this.getLength(CSS.Attribute.MARGIN_TOP, attributeSet);
            float f6 = this.getLength(CSS.Attribute.MARGIN_LEFT, attributeSet);
            f += f6;
            f2 += f5;
            f3 -= f6 + this.getLength(CSS.Attribute.MARGIN_RIGHT, attributeSet);
            f4 -= f5 + this.getLength(CSS.Attribute.MARGIN_BOTTOM, attributeSet);
            Color color = styleSheet != null ? styleSheet.getBackground(attributeSet) : null;
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect((int)f, (int)f2, (int)f3, (int)f4);
            }
            this.border.paintBorder(null, graphics, (int)f, (int)f2, (int)f3, (int)f4);
        }
    }

    public static class ListPainter
    implements Serializable {
        static final char[][] romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
        private int start;
        private CSS.Value type;
        URL imageurl;
        Icon img = null;
        private int bulletgap = 5;

        ListPainter(AttributeSet attributeSet) {
            String string = (String)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_IMAGE);
            this.type = null;
            if (string != null && !string.equals("none")) {
                try {
                    String string2 = null;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                    URL uRL = new URL(string2);
                    this.img = new ImageIcon(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    this.type = null;
                    this.img = null;
                }
            }
            if (this.img == null) {
                this.type = (CSS.Value)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            }
            this.start = 1;
        }

        void drawIcon(Graphics graphics, int n, int n2, int n3, float f, Component component) {
            graphics.setColor(Color.black);
            int n4 = n - this.img.getIconWidth() - this.bulletgap;
            int n5 = n2 + (int)((float)n3 * f) - 3;
            this.img.paintIcon(component, graphics, n4, n5);
        }

        void drawLetter(Graphics graphics, char c, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.black);
            String string = String.valueOf(this.formatItemNum(n4, c)) + ".";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.stringWidth(string);
            int n6 = n - n5 - this.bulletgap;
            int n7 = n2 + fontMetrics.getAscent() + fontMetrics.getLeading();
            graphics.drawString(string, n6, n7);
        }

        void drawShape(Graphics graphics, CSS.Value value, int n, int n2, int n3, float f) {
            graphics.setColor(Color.black);
            int n4 = n - this.bulletgap - 7;
            int n5 = n2 + (int)((float)n3 * f) - 3;
            if (value == CSS.Value.SQUARE) {
                graphics.drawRect(n4, n5, 7, 7);
            } else if (value == CSS.Value.CIRCLE) {
                graphics.drawOval(n4, n5, 7, 7);
            } else {
                graphics.fillOval(n4, n5, 7, 7);
            }
        }

        String formatAlphaNumerals(int n) {
            String string = "";
            string = n > 26 ? String.valueOf(this.formatAlphaNumerals(n / 26)) + this.formatAlphaNumerals(n % 26) : String.valueOf((char)(97 + n - 1));
            return string;
        }

        String formatItemNum(int n, char c) {
            String string;
            String string2 = "1";
            boolean bl = false;
            switch (c) {
                default: {
                    string = String.valueOf(n);
                    break;
                }
                case 'A': {
                    bl = true;
                }
                case 'a': {
                    string = this.formatAlphaNumerals(n);
                    break;
                }
                case 'I': {
                    bl = true;
                }
                case 'i': {
                    string = this.formatRomanNumerals(n);
                }
            }
            if (bl) {
                string = string.toUpperCase();
            }
            return string;
        }

        String formatRomanDigit(int n, int n2) {
            String string = "";
            if (n2 == 9) {
                string = String.valueOf(string) + romanChars[n][0];
                string = String.valueOf(string) + romanChars[n + 1][0];
                return string;
            }
            if (n2 == 4) {
                string = String.valueOf(string) + romanChars[n][0];
                string = String.valueOf(string) + romanChars[n][1];
                return string;
            }
            if (n2 >= 5) {
                string = String.valueOf(string) + romanChars[n][1];
                n2 -= 5;
            }
            int n3 = 0;
            while (n3 < n2) {
                string = String.valueOf(string) + romanChars[n][0];
                ++n3;
            }
            return string;
        }

        String formatRomanNumerals(int n) {
            return this.formatRomanNumerals(0, n);
        }

        String formatRomanNumerals(int n, int n2) {
            if (n2 < 10) {
                return this.formatRomanDigit(n, n2);
            }
            return String.valueOf(this.formatRomanNumerals(n + 1, n2 / 10)) + this.formatRomanDigit(n, n2 % 10);
        }

        private CSS.Value getChildType(View view) {
            CSS.Value value = (CSS.Value)view.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            if (value == null) {
                View view2;
                HTMLDocument hTMLDocument;
                value = this.type == null ? ((hTMLDocument = (HTMLDocument)(view2 = view.getParent()).getDocument()).matchNameAttribute(view2.getElement().getAttributes(), HTML.Tag.OL) ? CSS.Value.DECIMAL : CSS.Value.DISC) : this.type;
            }
            return value;
        }

        private int getRenderIndex(View view, int n) {
            int n2 = n;
            int n3 = n;
            while (n3 >= 0) {
                AttributeSet attributeSet = view.getElement().getElement(n3).getAttributes();
                if (attributeSet.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.LI) {
                    --n2;
                } else {
                    Object object = attributeSet.getAttribute(HTML.Attribute.VALUE);
                    if (object != null && object instanceof String) {
                        try {
                            int n4 = Integer.parseInt((String)object);
                            return n2 - n3 + n4;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                --n3;
            }
            return n2 + this.start;
        }

        public void paint(Graphics graphics, float f, float f2, float f3, float f4, View view, int n) {
            View view2 = view.getView(n);
            Object object = view2.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (!(object instanceof HTML.Tag) || object != HTML.Tag.LI) {
                return;
            }
            CSS.Value value = this.getChildType(view2);
            float f5 = view2.getAlignment(1);
            Font font = ((StyledDocument)view2.getDocument()).getFont(view2.getAttributes());
            if (font != null) {
                graphics.setFont(font);
            }
            if (value == CSS.Value.SQUARE || value == CSS.Value.CIRCLE || value == CSS.Value.DISC) {
                this.drawShape(graphics, value, (int)f, (int)f2, (int)f4, f5);
            } else if (value == CSS.Value.CIRCLE) {
                this.drawShape(graphics, value, (int)f, (int)f2, (int)f4, f5);
            } else if (value == CSS.Value.DECIMAL) {
                this.drawLetter(graphics, '1', (int)f, (int)f2, (int)f4, this.getRenderIndex(view, n));
            } else if (value == CSS.Value.LOWER_ALPHA) {
                this.drawLetter(graphics, 'a', (int)f, (int)f2, (int)f4, this.getRenderIndex(view, n));
            } else if (value == CSS.Value.UPPER_ALPHA) {
                this.drawLetter(graphics, 'A', (int)f, (int)f2, (int)f4, this.getRenderIndex(view, n));
            } else if (value == CSS.Value.LOWER_ROMAN) {
                this.drawLetter(graphics, 'i', (int)f, (int)f2, (int)f4, this.getRenderIndex(view, n));
            } else if (value == CSS.Value.UPPER_ROMAN) {
                this.drawLetter(graphics, 'I', (int)f, (int)f2, (int)f4, this.getRenderIndex(view, n));
            } else if (value == null && this.img != null) {
                this.drawIcon(graphics, (int)f, (int)f2, (int)f4, f5, view.getContainer());
            }
        }
    }

    static class MuxingAttributeSet
    implements AttributeSet {
        AttributeSet[] attrs;

        MuxingAttributeSet() {
        }

        MuxingAttributeSet(AttributeSet[] attributeSetArray) {
            this.attrs = attributeSetArray;
        }

        public boolean containsAttribute(Object object, Object object2) {
            return object2.equals(this.getAttribute(object));
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            boolean bl = true;
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (bl && enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                bl = attributeSet.getAttribute(object).equals(this.getAttribute(object));
            }
            return bl;
        }

        public AttributeSet copyAttributes() {
            AttributeSet[] attributeSetArray = this.getAttributes();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            boolean bl = false;
            int n = attributeSetArray.length - 1;
            while (n >= 0) {
                simpleAttributeSet.addAttributes(attributeSetArray[n]);
                --n;
            }
            return simpleAttributeSet;
        }

        public Object getAttribute(Object object) {
            AttributeSet[] attributeSetArray = this.getAttributes();
            int n = attributeSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = attributeSetArray[n2].getAttribute(object);
                if (object2 != null) {
                    return object2;
                }
                ++n2;
            }
            return null;
        }

        public int getAttributeCount() {
            AttributeSet[] attributeSetArray = this.getAttributes();
            int n = 0;
            int n2 = 0;
            while (n2 < attributeSetArray.length) {
                n += attributeSetArray[n2].getAttributeCount();
                ++n2;
            }
            return n;
        }

        public Enumeration getAttributeNames() {
            return new MuxingAttributeNameEnumeration();
        }

        protected synchronized AttributeSet[] getAttributes() {
            return this.attrs;
        }

        public AttributeSet getResolveParent() {
            return null;
        }

        protected synchronized void insertAttributeSetAt(AttributeSet attributeSet, int n) {
            int n2 = this.attrs.length;
            AttributeSet[] attributeSetArray = new AttributeSet[n2 + 1];
            if (n < n2) {
                if (n > 0) {
                    System.arraycopy(this.attrs, 0, attributeSetArray, 0, n);
                    System.arraycopy(this.attrs, n, attributeSetArray, n + 1, n2 - n);
                } else {
                    System.arraycopy(this.attrs, 0, attributeSetArray, 1, n2);
                }
            } else {
                System.arraycopy(this.attrs, 0, attributeSetArray, 0, n2);
            }
            attributeSetArray[n] = attributeSet;
            this.attrs = attributeSetArray;
        }

        public boolean isDefined(Object object) {
            AttributeSet[] attributeSetArray = this.getAttributes();
            int n = 0;
            while (n < attributeSetArray.length) {
                if (attributeSetArray[n].isDefined(object)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }

        protected synchronized void removeAttributeSetAt(int n) {
            int n2 = this.attrs.length;
            AttributeSet[] attributeSetArray = new AttributeSet[n2 - 1];
            if (n2 > 0) {
                if (n == 0) {
                    System.arraycopy(this.attrs, 1, attributeSetArray, 0, n2 - 1);
                } else if (n < n2 - 1) {
                    System.arraycopy(this.attrs, 0, attributeSetArray, 0, n);
                    System.arraycopy(this.attrs, n + 1, attributeSetArray, n, n2 - n - 1);
                } else {
                    System.arraycopy(this.attrs, 0, attributeSetArray, 0, n2 - 1);
                }
            }
            this.attrs = attributeSetArray;
        }

        protected synchronized void setAttributes(AttributeSet[] attributeSetArray) {
            this.attrs = attributeSetArray;
        }

        class MuxingAttributeNameEnumeration
        implements Enumeration {
            int attrIndex;
            Enumeration currentEnum;

            MuxingAttributeNameEnumeration() {
                this.updateEnum();
            }

            public boolean hasMoreElements() {
                if (this.currentEnum == null) {
                    return false;
                }
                return this.currentEnum.hasMoreElements();
            }

            public Object nextElement() {
                if (this.currentEnum == null) {
                    throw new NoSuchElementException("No more names");
                }
                Object object = this.currentEnum.nextElement();
                if (!this.currentEnum.hasMoreElements()) {
                    this.updateEnum();
                }
                return object;
            }

            void updateEnum() {
                AttributeSet[] attributeSetArray = MuxingAttributeSet.this.getAttributes();
                this.currentEnum = null;
                while (this.currentEnum == null && this.attrIndex < attributeSetArray.length) {
                    this.currentEnum = attributeSetArray[this.attrIndex++].getAttributeNames();
                    if (this.currentEnum.hasMoreElements()) continue;
                    this.currentEnum = null;
                }
            }
        }
    }

    class ViewAttributeSet
    extends MuxingAttributeSet {
        View host;

        ViewAttributeSet(View view) {
            this.host = view;
            Document document = view.getDocument();
            SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
            Vector vector = searchBuffer.getVector();
            try {
                if (document instanceof HTMLDocument) {
                    StyleSheet styleSheet2 = StyleSheet.this;
                    Element element = view.getElement();
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = styleSheet2.translateHTMLToCSS(attributeSet);
                    if (attributeSet2.getAttributeCount() != 0) {
                        vector.addElement(attributeSet2);
                    }
                    if (element.isLeaf()) {
                        Enumeration enumeration = attributeSet.getAttributeNames();
                        while (enumeration.hasMoreElements()) {
                            AttributeSet attributeSet3;
                            Object object;
                            Object object2 = enumeration.nextElement();
                            if (!(object2 instanceof HTML.Tag) || (HTML.Tag)object2 == HTML.Tag.A && (object = attributeSet.getAttribute((HTML.Tag)object2)) != null && object instanceof AttributeSet && (attributeSet3 = (AttributeSet)object).getAttribute(HTML.Attribute.HREF) == null || (object = styleSheet2.getRule((HTML.Tag)object2, element)) == null) continue;
                            vector.addElement(object);
                        }
                    } else {
                        Style style;
                        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                        if (tag == HTML.Tag.IMPLIED) {
                            tag = HTML.Tag.P;
                        }
                        if ((style = styleSheet2.getRule(tag, element)) != null) {
                            vector.addElement(style);
                        }
                    }
                }
                this.attrs = new AttributeSet[vector.size()];
                vector.copyInto(this.attrs);
            }
            finally {
                Object var7_16 = null;
                SearchBuffer.releaseSearchBuffer(searchBuffer);
            }
        }

        Object doGetAttribute(Object object) {
            AttributeSet attributeSet;
            CSS.Attribute attribute;
            Object object2 = super.getAttribute(object);
            if (object2 != null) {
                return object2;
            }
            if (object instanceof CSS.Attribute && (attribute = (CSS.Attribute)object).isInherited() && (attributeSet = this.getResolveParent()) != null) {
                return attributeSet.getAttribute(object);
            }
            return null;
        }

        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = this.doGetAttribute(attribute)) instanceof CSS.CssValue) {
                return ((CSS.CssValue)object2).toStyleConstants((StyleConstants)object);
            }
            return this.doGetAttribute(object);
        }

        public AttributeSet getResolveParent() {
            if (this.host == null) {
                return null;
            }
            View view = this.host.getParent();
            return view != null ? view.getAttributes() : null;
        }

        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                object = attribute;
            }
            return super.isDefined(object);
        }
    }

    static class ResolvedStyle
    extends MuxingAttributeSet
    implements Style {
        String name;
        private int extendedIndex;

        ResolvedStyle(String string, AttributeSet[] attributeSetArray, int n) {
            this.attrs = attributeSetArray;
            this.name = string;
            this.extendedIndex = n;
        }

        public void addAttribute(Object object, Object object2) {
        }

        public void addAttributes(AttributeSet attributeSet) {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        synchronized void addExtendedStyle(Style style) {
            this.insertAttributeSetAt(style, this.attrs.length);
        }

        int boundedIndexOf(String string, char c, int n, int n2) {
            int n3 = string.indexOf(c, n);
            if (n3 >= n2) {
                return -1;
            }
            return n3;
        }

        public String getName() {
            return this.name;
        }

        synchronized void insertExtendedStyleAt(Style style, int n) {
            this.insertAttributeSetAt(style, this.extendedIndex + n);
        }

        synchronized void insertStyle(Style style, int n) {
            int n2 = this.attrs.length;
            int n3 = 0;
            while (n3 < this.extendedIndex) {
                if (n > StyleSheet.getSpecificity(((Style)this.attrs[n3]).getName())) break;
                ++n3;
            }
            this.insertAttributeSetAt(style, n3);
            ++this.extendedIndex;
        }

        /*
         * Unable to fully structure code
         */
        protected boolean matches(String var1_1) {
            var2_2 = var1_1.length();
            if (var2_2 == 0) {
                return false;
            }
            var3_3 = this.name.length();
            var4_4 = var1_1.lastIndexOf(32);
            var5_5 = this.name.lastIndexOf(32);
            if (var4_4 >= 0) {
                ++var4_4;
            }
            if (var5_5 >= 0) {
                ++var5_5;
            }
            if (this.matches(var1_1, var4_4, var2_2, var5_5, var3_3)) ** GOTO lbl25
            return false;
lbl-1000:
            // 1 sources

            {
                var2_2 = var4_4 - 1;
                if ((var4_4 = var1_1.lastIndexOf(32, var2_2 - 1)) >= 0) {
                    ++var4_4;
                }
                var6_6 = false;
                while (!var6_6 && var5_5 != -1) {
                    var3_3 = var5_5 - 1;
                    if ((var5_5 = this.name.lastIndexOf(32, var3_3 - 1)) >= 0) {
                        ++var5_5;
                    }
                    var6_6 = this.matches(var1_1, var4_4, var2_2, var5_5, var3_3);
                }
                if (var6_6) continue;
                return false;
lbl25:
                // 2 sources

                ** while (var4_4 != -1)
            }
lbl26:
            // 1 sources

            return true;
        }

        boolean matches(String string, int n, int n2, int n3, int n4) {
            n = Math.max(n, 0);
            n3 = Math.max(n3, 0);
            int n5 = this.boundedIndexOf(this.name, '.', n3, n4);
            int n6 = this.boundedIndexOf(this.name, '#', n3, n4);
            int n7 = this.boundedIndexOf(string, '.', n, n2);
            int n8 = this.boundedIndexOf(string, '#', n, n2);
            if (n7 != -1) {
                if (n5 == -1) {
                    return false;
                }
                return !(n == n7 ? n4 - n5 != n2 - n7 || !string.regionMatches(n, this.name, n5, n4 - n5) : n2 - n != n4 - n3 || !string.regionMatches(n, this.name, n3, n4 - n3));
            }
            if (n8 != -1) {
                if (n6 == -1) {
                    return false;
                }
                return !(n == n8 ? n4 - n6 != n2 - n8 || !string.regionMatches(n, this.name, n6, n4 - n6) : n2 - n != n4 - n3 || !string.regionMatches(n, this.name, n3, n4 - n3));
            }
            if (n5 != -1) {
                return string.regionMatches(n, this.name, n3, n5 - n3);
            }
            if (n6 != -1) {
                return string.regionMatches(n, this.name, n3, n6 - n3);
            }
            return string.regionMatches(n, this.name, n3, n4 - n3);
        }

        public void removeAttribute(Object object) {
        }

        public void removeAttributes(Enumeration enumeration) {
        }

        public void removeAttributes(AttributeSet attributeSet) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        synchronized void removeExtendedStyleAt(int n) {
            this.removeAttributeSetAt(this.extendedIndex + n);
        }

        synchronized void removeStyle(Style style) {
            int n = this.attrs.length - 1;
            while (n >= 0) {
                if (this.attrs[n] == style) {
                    this.removeAttributeSetAt(n);
                    if (n >= this.extendedIndex) break;
                    --this.extendedIndex;
                    break;
                }
                --n;
            }
        }

        public void setResolveParent(AttributeSet attributeSet) {
        }
    }

    static class SheetAttribute {
        private boolean cache;
        private String name;

        SheetAttribute(String string, boolean bl) {
            this.name = string;
            this.cache = bl;
        }

        public boolean isCache() {
            return this.cache;
        }

        public String toString() {
            return this.name;
        }
    }

    class CssParser
    implements Serializable {
        Vector selectors = new Vector();
        Vector selectorTokens = new Vector();
        String key;
        Vector ruleTokens = new Vector();
        MutableAttributeSet declaration = new SimpleAttributeSet();
        boolean parsingDeclaration;
        boolean isLink;
        URL base;

        CssParser() {
        }

        void addImport(String string) {
            block7: {
                block6: {
                    if (!string.startsWith("url(") || !string.endsWith(")")) break block6;
                    try {
                        URL uRL = new URL(string.substring(4, string.length() - 1));
                        if (uRL != null) {
                            StyleSheet.this.importStyleSheet(uRL);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {}
                    break block7;
                }
                if (this.base == null) break block7;
                try {
                    URL uRL = new URL(this.base, string);
                    if (uRL != null) {
                        StyleSheet.this.importStyleSheet(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }

        void addKeyValueToDeclaration() {
            Object object;
            CSS.Attribute attribute = CSS.getAttribute(this.key);
            if (attribute != null && (object = this.getValue(attribute)) != null) {
                this.declaration.addAttribute(attribute, object);
            }
            this.ruleTokens.removeAllElements();
        }

        void addRule() {
            if (this.parsingDeclaration) {
                throw new RuntimeException("Declaration should not contain rules");
            }
            int n = this.selectors.size();
            int n2 = 0;
            while (n2 < n) {
                String[] stringArray = (String[])this.selectors.elementAt(n2);
                if (stringArray.length > 0) {
                    StyleSheet.this.addRule(stringArray, this.declaration, this.isLink);
                }
                ++n2;
            }
            this.declaration.removeAttributes(this.declaration);
            this.selectors.removeAllElements();
        }

        void addSelector() {
            Object[] objectArray = new String[this.selectorTokens.size()];
            this.selectorTokens.copyInto(objectArray);
            this.selectors.addElement(objectArray);
            this.selectorTokens.removeAllElements();
        }

        String getDeclarationString() {
            String string = "";
            int n = this.ruleTokens.size();
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + this.ruleTokens.elementAt(n2);
                ++n2;
            }
            this.ruleTokens.removeAllElements();
            return string;
        }

        Object getValue(CSS.Attribute attribute) {
            return StyleSheet.this.css.getInternalCSSValue(attribute, this.getDeclarationString());
        }

        void parse(URL uRL, Reader reader, boolean bl, boolean bl2) throws IOException {
            this.base = uRL;
            this.isLink = bl2;
            this.declaration.removeAttributes(this.declaration);
            this.selectorTokens.removeAllElements();
            this.selectors.removeAllElements();
            this.ruleTokens.removeAllElements();
            this.parsingDeclaration = bl;
            StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.slashStarComments(true);
            streamTokenizer.wordChars(35, 35);
            boolean bl3 = bl;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            StringBuffer stringBuffer = null;
            boolean bl7 = false;
            char[] cArray = new char[1];
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                block0 : switch (n) {
                    case -3: {
                        if (bl4) {
                            if (bl5) {
                                stringBuffer.append(streamTokenizer.sval);
                            } else if (streamTokenizer.sval.equals("import")) {
                                bl5 = true;
                                if (stringBuffer == null) {
                                    stringBuffer = new StringBuffer();
                                } else {
                                    stringBuffer.setLength(0);
                                }
                            }
                        } else if (bl3) {
                            this.ruleTokens.addElement(streamTokenizer.sval);
                        } else {
                            if (bl7) {
                                this.selectorTokens.addElement(String.valueOf('.') + streamTokenizer.sval);
                            } else {
                                this.selectorTokens.addElement(streamTokenizer.sval);
                            }
                            bl6 = true;
                        }
                        bl7 = false;
                        break;
                    }
                    case -2: {
                        bl7 = false;
                        if (bl4) {
                            if (!bl5) break;
                            stringBuffer.append(streamTokenizer.nval);
                            break;
                        }
                        if (bl3) {
                            this.ruleTokens.addElement(new Integer((int)streamTokenizer.nval));
                            break;
                        }
                        if (streamTokenizer.nval == 0.0) {
                            bl7 = true;
                            break;
                        }
                        String string = (String)this.selectorTokens.lastElement();
                        string = String.valueOf(string) + (int)streamTokenizer.nval;
                        this.selectorTokens.setElementAt(string, this.selectorTokens.size() - 1);
                        bl6 = true;
                        break;
                    }
                    default: {
                        bl7 = false;
                        if (bl4) {
                            if (streamTokenizer.ttype == 59) {
                                bl4 = false;
                                if (!bl5) break;
                                if (!bl6) {
                                    this.addImport(stringBuffer.toString());
                                }
                                bl5 = false;
                                break;
                            }
                            if (!bl5) break;
                            if (streamTokenizer.ttype == 39 || streamTokenizer.ttype == 34) {
                                stringBuffer.append(streamTokenizer.sval);
                                break;
                            }
                            stringBuffer.append((char)streamTokenizer.ttype);
                            break;
                        }
                        switch (streamTokenizer.ttype) {
                            case 123: {
                                bl6 = true;
                                this.addSelector();
                                bl3 = true;
                                break block0;
                            }
                            case 125: {
                                if (this.ruleTokens.size() > 0) {
                                    this.addKeyValueToDeclaration();
                                }
                                this.addRule();
                                bl3 = false;
                                break block0;
                            }
                            case 59: {
                                this.addKeyValueToDeclaration();
                                break block0;
                            }
                            case 58: {
                                this.key = this.getDeclarationString();
                                break block0;
                            }
                            case 44: {
                                if (bl3) {
                                    this.ruleTokens.addElement(new Character(','));
                                    break block0;
                                }
                                this.addSelector();
                                break block0;
                            }
                            case 64: {
                                bl4 = true;
                                bl5 = false;
                                break block0;
                            }
                        }
                        if (bl3) {
                            this.ruleTokens.addElement(new Character(','));
                            break;
                        }
                        if (this.selectorTokens.size() == 0) {
                            cArray[0] = (char)streamTokenizer.ttype;
                            this.selectorTokens.addElement(new String(cArray));
                            break;
                        }
                        String string = (String)this.selectorTokens.lastElement();
                        string = String.valueOf(string) + (char)streamTokenizer.ttype;
                        this.selectorTokens.setElementAt(string, this.selectorTokens.size() - 1);
                    }
                    case 10: 
                }
                n = streamTokenizer.nextToken();
            }
            if (this.parsingDeclaration && this.ruleTokens.size() > 0) {
                this.addKeyValueToDeclaration();
            }
        }

        AttributeSet parseDeclaration(Reader reader) throws IOException {
            this.parse(this.base, reader, true, false);
            return this.declaration.copyAttributes();
        }

        AttributeSet parseDeclaration(String string) {
            try {
                return this.parseDeclaration(new StringReader(string));
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

