/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.AffineTransform;
import sun.awt.font.NativeFontWrapper;

public class FontDesignMetrics
extends FontMetrics {
    private Font font;
    private float ascent;
    private float descent;
    private float leading;
    private float maxAdvance;
    private double[] matrix;
    private int[] cache;

    public FontDesignMetrics(Font font, float f, float f2, float f3, float f4) {
        super(font);
        this.font = font;
        this.ascent = f;
        this.descent = f2;
        this.leading = f3;
        this.maxAdvance = f4;
        float f5 = font.getSize2D();
        AffineTransform affineTransform = font.getTransform();
        affineTransform.scale(f5, f5);
        this.matrix = new double[4];
        affineTransform.getMatrix(this.matrix);
        this.cache = new int[256];
        int n = 0;
        while (n < 256) {
            this.cache[n] = -1;
            ++n;
        }
    }

    public int charWidth(char c) {
        int n;
        if ((c & 0xFF) == c) {
            n = this.cache[c];
            if (n == -1) {
                this.cache[c] = n = (int)(0.5 + (double)NativeFontWrapper.getAdvance(this.font, c, this.matrix, false, false));
            }
        } else {
            n = (int)(0.5 + (double)NativeFontWrapper.getAdvance(this.font, c, this.matrix, false, false));
        }
        return n;
    }

    public int getAscent() {
        return (int)(0.9999 + (double)this.ascent);
    }

    public int getDescent() {
        return (int)(0.9999 + (double)this.descent);
    }

    public int getLeading() {
        return (int)(0.9999 + (double)this.leading);
    }

    public int getMaxAdvance() {
        return (int)(0.9999 + (double)this.maxAdvance);
    }

    public int stringWidth(String string) {
        if (string.length() > 0) {
            int n = string.length();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += this.charWidth(string.charAt(n3));
                ++n3;
            }
            return n2;
        }
        return 0;
    }
}

